/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationKey;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCache;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationSelector;
import org.seasar.dbflute.s2dao.rowcreator.TnRowCreator;
import org.seasar.dbflute.s2dao.rshandler.TnAbstractBeanResultSetHandler;

public class TnBeanListResultSetHandler
extends TnAbstractBeanResultSetHandler {
    public TnBeanListResultSetHandler(TnBeanMetaData beanMetaData, TnRowCreator rowCreator, TnRelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        final ArrayList list = new ArrayList();
        this.mappingBean(rs, new BeanRowHandler(){

            @Override
            public void handle(Object row) throws SQLException {
                list.add(row);
            }
        });
        return list;
    }

    protected void mappingBean(ResultSet rs, BeanRowHandler handler) throws SQLException {
        Map<String, String> selectColumnMap = null;
        Map<String, TnPropertyMapping> propertyCache = null;
        Map<String, Map<String, TnPropertyMapping>> relPropCache = null;
        TnRelationRowCache relRowCache = null;
        TnRelationSelector relSelector = null;
        TnBeanMetaData basePointBmd = this.getBeanMetaData();
        boolean hasCB = this.hasConditionBean();
        boolean emptyRelationCB = hasCB && this.isSelectedRelationEmpty();
        boolean specifiedOutsideSql = this.hasOutsideSqlContext() && this.isSpecifiedOutsideSql();
        boolean skipRelationLoop = emptyRelationCB || specifiedOutsideSql;
        Map<String, Integer> selectIndexMap = ResourceContext.getSelectIndexMap();
        while (rs.next()) {
            if (selectColumnMap == null) {
                selectColumnMap = this.createSelectColumnMap(rs);
            }
            if (propertyCache == null) {
                propertyCache = this.createPropertyCache(selectColumnMap);
            }
            Object row = this.createRow(rs, selectIndexMap, propertyCache);
            if (skipRelationLoop) {
                this.adjustCreatedRow(row, basePointBmd);
                handler.handle(row);
                continue;
            }
            if (relSelector == null) {
                relSelector = this.createRelationSelector(hasCB);
            }
            if (relPropCache == null) {
                relPropCache = this.createRelationPropertyCache(selectColumnMap, selectIndexMap, relSelector);
            }
            if (relRowCache == null) {
                relRowCache = this.createRelationRowCache(hasCB);
            }
            List<TnRelationPropertyType> rptList = basePointBmd.getRelationPropertyTypeList();
            for (TnRelationPropertyType rpt : rptList) {
                if (relSelector.isNonSelectedRelation(rpt.getRelationNoSuffixPart())) continue;
                this.mappingFirstRelation(rs, row, rpt, selectColumnMap, selectIndexMap, relPropCache, relRowCache, relSelector);
            }
            this.adjustCreatedRow(row, basePointBmd);
            handler.handle(row);
        }
    }

    protected TnRelationSelector createRelationSelector(final boolean hasCB) {
        final ConditionBean cb = hasCB ? ConditionBeanContext.getConditionBeanOnThread() : null;
        return new TnRelationSelector(){

            @Override
            public boolean isNonLimitMapping() {
                return hasCB;
            }

            @Override
            public boolean isNonSelectedRelation(String relationNoSuffix) {
                return cb != null && !cb.getSqlClause().hasSelectedRelation(relationNoSuffix);
            }

            @Override
            public boolean isNonSelectedNextConnectingRelation(String relationNoSuffix) {
                return cb != null && !cb.getSqlClause().isSelectedNextConnectingRelation(relationNoSuffix);
            }
        };
    }

    protected TnRelationRowCache createRelationRowCache(boolean hasCB) {
        int selectedRelationCount;
        int defaultRelSize = 4;
        int relSize = hasCB ? ((selectedRelationCount = this.getSelectedRelationCount()) > 0 ? selectedRelationCount : 4) : 4;
        boolean canRowCache = hasCB ? this.canRelationMappingCache() : true;
        return new TnRelationRowCache(relSize, canRowCache);
    }

    protected void mappingFirstRelation(ResultSet rs, Object row, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, Map<String, Map<String, TnPropertyMapping>> relPropCache, TnRelationRowCache relRowCache, TnRelationSelector relSelector) throws SQLException {
        String relationNoSuffix = this.getFirstLevelRelationPath(rpt);
        TnRelationKey relKey = relRowCache.createRelationKey(rs, rpt, selectColumnMap, selectIndexMap, relationNoSuffix);
        if (relKey == null) {
            return;
        }
        Object relationRow = relRowCache.getRelationRow(relationNoSuffix, relKey);
        if (relationRow == null && (relationRow = this.createRelationRow(rs, rpt, selectColumnMap, selectIndexMap, relKey, relPropCache, relRowCache, relSelector)) != null) {
            this.adjustCreatedRow(relationRow, rpt.getYourBeanMetaData());
            relRowCache.addRelationRow(relationNoSuffix, relKey, relationRow);
        }
        if (relationRow != null) {
            rpt.getPropertyDesc().setValue(row, relationRow);
        }
    }

    protected String getFirstLevelRelationPath(TnRelationPropertyType rpt) {
        return rpt.getRelationNoSuffixPart();
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected boolean isSelectedRelationEmpty() {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().isSelectedRelationEmpty();
    }

    protected int getSelectedRelationCount() {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().getSelectedRelationCount();
    }

    protected boolean canRelationMappingCache() {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.canRelationMappingCache();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected boolean isSpecifiedOutsideSql() {
        if (!this.hasOutsideSqlContext()) {
            return false;
        }
        OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
        return context.isSpecifiedOutsideSql();
    }

    protected static interface BeanRowHandler {
        public void handle(Object var1) throws SQLException;
    }
}

