/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnUpdateEntityDynamicCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnBatchUpdateHandler;

public class TnBatchUpdateDynamicCommand
extends TnUpdateEntityDynamicCommand {
    private static final int[] NON_BATCH_UPDATE = new int[0];

    public TnBatchUpdateDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    protected Object doExecute(Object bean, TnPropertyType[] propertyTypes, String sql, UpdateOption<ConditionBean> option) {
        if (!(bean instanceof List)) {
            String msg = "The argument 'args[0]' should be list: " + bean;
            throw new IllegalArgumentException(msg);
        }
        List beanList = (List)bean;
        TnBatchUpdateHandler handler = this.createBatchUpdateHandler(propertyTypes, sql, option);
        return handler.executeBatch(beanList);
    }

    @Override
    protected Set<?> getModifiedPropertyNames(Object bean) {
        return Collections.EMPTY_SET;
    }

    @Override
    protected boolean isModifiedProperty(Set<?> modifiedSet, TnPropertyType pt) {
        return true;
    }

    protected TnBatchUpdateHandler createBatchUpdateHandler(TnPropertyType[] boundPropTypes, String sql, UpdateOption<ConditionBean> option) {
        TnBatchUpdateHandler handler = this.newBatchUpdateHandler(boundPropTypes, sql);
        handler.setOptimisticLockHandling(this._optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this._versionNoAutoIncrementOnMemory);
        handler.setUpdateOption(option);
        return handler;
    }

    protected TnBatchUpdateHandler newBatchUpdateHandler(TnPropertyType[] boundPropTypes, String sql) {
        return new TnBatchUpdateHandler(this._dataSource, this._statementFactory, sql, this._beanMetaData, boundPropTypes);
    }

    @Override
    protected String createNonUpdateLogMessage(Object bean) {
        StringBuilder sb = new StringBuilder();
        String tableDbName = this._targetDBMeta.getTableDbName();
        sb.append("...Skipping batch update because of non-specified: table=").append(tableDbName);
        if (bean instanceof List) {
            List entityList = (List)bean;
            sb.append(", batchSize=").append(entityList.size());
        }
        return sb.toString();
    }

    @Override
    protected Object getNonUpdateReturn() {
        return NON_BATCH_UPDATE;
    }
}

