/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractQueryDynamicCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.util.Srl;

public class TnQueryUpdateDynamicCommand
extends TnAbstractQueryDynamicCommand {
    protected TnBeanMetaData _beanMetaData;

    public TnQueryUpdateDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        Entity entity = this.extractEntityWithCheck(args);
        ConditionBean cb = this.extractConditionBeanWithCheck(args);
        UpdateOption<ConditionBean> option = this.extractUpdateOptionWithCheck(args);
        this.prepareStatementConfigOnThreadIfExists(option);
        String[] argNames = new String[]{"entity", "pmb"};
        Class[] argTypes = new Class[]{entity.getClass(), cb.getClass()};
        Object[] realArgs = new Object[]{entity, cb};
        ArrayList<TnPropertyType> boundPropTypeList = new ArrayList<TnPropertyType>();
        String twoWaySql = this.buildQueryUpdateTwoWaySql(entity, cb, option, boundPropTypeList);
        if (twoWaySql == null) {
            return 0;
        }
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, realArgs);
        TnCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setExceptionMessageSqlArgs(context.getBindVariables());
        handler.setFirstBoundPropTypeList(boundPropTypeList);
        int rows = handler.execute(realArgs);
        return rows;
    }

    protected Entity extractEntityWithCheck(Object[] args) {
        this.assertArgument(args);
        Object firstArg = args[0];
        if (!(firstArg instanceof Entity)) {
            String msg = "The type of first argument should be " + Entity.class + ":";
            msg = msg + " type=" + firstArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (Entity)firstArg;
    }

    protected ConditionBean extractConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object secondArg = args[1];
        if (!(secondArg instanceof ConditionBean)) {
            String msg = "The type of second argument should be " + ConditionBean.class + ":";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)secondArg;
    }

    protected UpdateOption<ConditionBean> extractUpdateOptionWithCheck(Object[] args) {
        this.assertArgument(args);
        if (args.length < 3) {
            return null;
        }
        Object thirdArg = args[2];
        if (thirdArg == null) {
            return null;
        }
        if (!(thirdArg instanceof UpdateOption)) {
            String msg = "The type of third argument should be " + UpdateOption.class + ":";
            msg = msg + " type=" + thirdArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        UpdateOption option = (UpdateOption)thirdArg;
        return option;
    }

    protected void prepareStatementConfigOnThreadIfExists(UpdateOption<ConditionBean> option) {
        StatementConfig config;
        StatementConfig statementConfig = config = option != null ? option.getUpdateStatementConfig() : null;
        if (config != null) {
            InternalMapContext.setUpdateStatementConfig(config);
        }
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument at least! But:";
            msg = msg + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected String buildQueryUpdateTwoWaySql(Entity entity, ConditionBean cb, final UpdateOption<ConditionBean> option, List<TnPropertyType> boundPropTypeList) {
        String columnDbName;
        ColumnInfo columnInfo;
        LinkedHashMap<String, Object> columnParameterMap = new LinkedHashMap<String, Object>();
        DBMeta dbmeta = entity.getDBMeta();
        Set<String> modifiedPropertyNames = entity.modifiedProperties();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        for (ColumnInfo columnInfo2 : columnInfoList) {
            if (columnInfo2.isOptimisticLock()) continue;
            final String columnDbName2 = columnInfo2.getColumnDbName();
            if (option != null && option.hasStatement(columnDbName2)) {
                columnParameterMap.put(columnDbName2, new SqlClause.QueryUpdateSetCalculationHandler(){

                    @Override
                    public String buildStatement(String aliasName) {
                        return option.buildStatement(columnDbName2, aliasName);
                    }
                });
                continue;
            }
            String propertyName = columnInfo2.getPropertyName();
            if (!modifiedPropertyNames.contains(propertyName)) continue;
            Object value = columnInfo2.read(entity);
            if (value != null) {
                columnParameterMap.put(columnDbName2, "/*entity." + propertyName + "*/null");
                TnPropertyType propertyType = this._beanMetaData.getPropertyType(propertyName);
                boundPropTypeList.add(propertyType);
                continue;
            }
            columnParameterMap.put(columnDbName2, "null");
        }
        if (columnParameterMap.isEmpty()) {
            return null;
        }
        if (dbmeta.hasVersionNo()) {
            columnInfo = dbmeta.getVersionNoColumnInfo();
            columnDbName = columnInfo.getColumnDbName();
            columnParameterMap.put(columnDbName, new SqlClause.QueryUpdateSetCalculationHandler(){

                @Override
                public String buildStatement(String aliasName) {
                    ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
                    return (aliasName != null ? aliasName : "") + columnSqlName + " + 1";
                }
            });
        }
        if (dbmeta.hasUpdateDate()) {
            columnInfo = dbmeta.getUpdateDateColumnInfo();
            columnInfo.write(entity, ResourceContext.getAccessTimestamp());
            columnDbName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            columnParameterMap.put(columnDbName, "/*entity." + propertyName + "*/null");
            boundPropTypeList.add(this._beanMetaData.getPropertyType(propertyName));
        }
        if (option != null && option.isQueryUpdateForcedDirectAllowed()) {
            cb.getSqlClause().allowQueryUpdateForcedDirect();
        }
        return cb.getSqlClause().getClauseQueryUpdate(columnParameterMap);
    }

    @Override
    protected String getUpdateSQLFailureProcessTitle() {
        return "query update";
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this._beanMetaData = beanMetaData;
    }
}

