/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader.CSVTokenizer;

public final class QuotedCSVTokenizer
implements CSVTokenizer {
    private final char separatorChar;
    private final boolean trim;
    private final boolean addEmptyStrings;
    private final List<String> columnNames;
    private final char quoteChar;

    public QuotedCSVTokenizer(char separatorChar, boolean trim, boolean addEmptyStrings, List<String> columnNames, char quoteChar) {
        this.separatorChar = separatorChar;
        this.trim = trim;
        this.addEmptyStrings = addEmptyStrings;
        this.columnNames = columnNames;
        this.quoteChar = quoteChar;
    }

    @Override
    public void tokenizeLine(String line, BufferedReader reader, Record record) throws IOException {
        char DELIMITER = this.separatorChar;
        char QUOTE = this.quoteChar;
        StringBuilder sb = new StringBuilder(30);
        boolean isQuoted = false;
        int i = 0;
        int j = 0;
        while (true) {
            char c;
            if (!isQuoted) {
                if (i == line.length()) break;
                c = line.charAt(i);
                if (c == DELIMITER) {
                    this.put(sb, j, record);
                    ++j;
                    sb.setLength(0);
                } else if (c == QUOTE) {
                    if (sb.length() == 0) {
                        isQuoted = true;
                    } else if (i + 1 < line.length() && line.charAt(i + 1) == QUOTE) {
                        sb.append(c);
                        ++i;
                    } else {
                        isQuoted = true;
                    }
                } else {
                    sb.append(c);
                }
            } else {
                assert (isQuoted);
                if (i == line.length()) {
                    sb.append('\n');
                    i = -1;
                    line = reader.readLine();
                    if (line == null) {
                        throw new IllegalStateException("unexpected end of file, unclosed quotation");
                    }
                } else {
                    c = line.charAt(i);
                    if (c == QUOTE) {
                        if (i + 1 < line.length() && line.charAt(i + 1) == QUOTE) {
                            sb.append(c);
                            ++i;
                        } else {
                            isQuoted = false;
                        }
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
        if (j != 0 || sb.length() != 0) {
            this.put(sb, j, record);
        }
    }

    private void put(StringBuilder sb, int j, Record record) {
        String columnName;
        if (j >= this.columnNames.size()) {
            this.columnNames.add("column" + j);
        }
        if ((columnName = this.columnNames.get(j)).length() != 0) {
            String col = sb.toString();
            String string = col = this.trim ? col.trim() : col;
            if (col.length() > 0 || this.addEmptyStrings) {
                record.put(columnName, col);
            }
        }
    }
}

