/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.db.allcommon;

import org.seasar.robot.db.allcommon.DBCurrent;
import org.seasar.robot.db.allcommon.DBFluteConfig;
import org.seasar.robot.db.allcommon.DBMetaInstanceHandler;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.robot.dbflute.cbean.sqlclause.AbstractSqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseDb2;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseDefault;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseDerby;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseFirebird;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseH2;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseMsAccess;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClausePostgreSql;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseSqlServer;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseSqlite;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseSybase;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;

public class ImplementedSqlClauseCreator
implements SqlClauseCreator {
    @Override
    public SqlClause createSqlClause(ConditionBean cb) {
        String tableDbName = cb.getTableDbName();
        SqlClause sqlClause = this.createSqlClause(tableDbName);
        return sqlClause;
    }

    @Override
    public SqlClause createSqlClause(String tableDbName) {
        SqlClause sqlClause = this.doCreateSqlClause(tableDbName);
        this.setupSqlClauseOption(sqlClause);
        return sqlClause;
    }

    protected SqlClause doCreateSqlClause(String tableDbName) {
        AbstractSqlClause sqlClause = this.isCurrentDBDef(DBDef.MySQL) ? this.createSqlClauseMySql(tableDbName) : (this.isCurrentDBDef(DBDef.PostgreSQL) ? this.createSqlClausePostgreSql(tableDbName) : (this.isCurrentDBDef(DBDef.Oracle) ? this.createSqlClauseOracle(tableDbName) : (this.isCurrentDBDef(DBDef.DB2) ? this.createSqlClauseDb2(tableDbName) : (this.isCurrentDBDef(DBDef.SQLServer) ? this.createSqlClauseSqlServer(tableDbName) : (this.isCurrentDBDef(DBDef.H2) ? this.createSqlClauseH2(tableDbName) : (this.isCurrentDBDef(DBDef.Derby) ? this.createSqlClauseDerby(tableDbName) : (this.isCurrentDBDef(DBDef.SQLite) ? this.createSqlClauseSqlite(tableDbName) : (this.isCurrentDBDef(DBDef.MSAccess) ? this.createSqlClauseMsAccess(tableDbName) : (this.isCurrentDBDef(DBDef.FireBird) ? this.createSqlClauseFirebird(tableDbName) : (this.isCurrentDBDef(DBDef.Sybase) ? this.createSqlClauseSybase(tableDbName) : this.createSqlClauseH2(tableDbName)))))))))));
        this.prepareSupporterComponent(sqlClause);
        return sqlClause;
    }

    protected SqlClauseMySql createSqlClauseMySql(String tableDbName) {
        return new SqlClauseMySql(tableDbName);
    }

    protected SqlClausePostgreSql createSqlClausePostgreSql(String tableDbName) {
        return new SqlClausePostgreSql(tableDbName);
    }

    protected SqlClauseOracle createSqlClauseOracle(String tableDbName) {
        return new SqlClauseOracle(tableDbName);
    }

    protected SqlClauseDb2 createSqlClauseDb2(String tableDbName) {
        return new SqlClauseDb2(tableDbName);
    }

    protected SqlClauseSqlServer createSqlClauseSqlServer(String tableDbName) {
        return new SqlClauseSqlServer(tableDbName);
    }

    protected SqlClauseH2 createSqlClauseH2(String tableDbName) {
        return new SqlClauseH2(tableDbName);
    }

    protected SqlClauseDerby createSqlClauseDerby(String tableDbName) {
        return new SqlClauseDerby(tableDbName);
    }

    protected SqlClauseSqlite createSqlClauseSqlite(String tableDbName) {
        return new SqlClauseSqlite(tableDbName);
    }

    protected SqlClauseMsAccess createSqlClauseMsAccess(String tableDbName) {
        return new SqlClauseMsAccess(tableDbName);
    }

    protected SqlClauseFirebird createSqlClauseFirebird(String tableDbName) {
        return new SqlClauseFirebird(tableDbName);
    }

    protected SqlClauseSybase createSqlClauseSybase(String tableDbName) {
        return new SqlClauseSybase(tableDbName);
    }

    protected SqlClause createSqlClauseDefault(String tableDbName) {
        return new SqlClauseDefault(tableDbName);
    }

    protected void prepareSupporterComponent(AbstractSqlClause sqlClause) {
        sqlClause.dbmetaProvider(this.getDBMetaProvider()).cipherManager(this.getGearedCipherManager());
    }

    protected DBMetaProvider getDBMetaProvider() {
        return DBMetaInstanceHandler.getProvider();
    }

    protected GearedCipherManager getGearedCipherManager() {
        return DBFluteConfig.getInstance().getGearedCipherManager();
    }

    protected void setupSqlClauseOption(SqlClause sqlClause) {
        if (this.isInnerJoinAutoDetect()) {
            sqlClause.allowInnerJoinAutoDetect();
        }
        if (this.isEmptyStringQueryAllowed()) {
            sqlClause.allowEmptyStringQuery();
        }
        if (this.isInvalidQueryChecked()) {
            sqlClause.checkInvalidQuery();
        }
        if (this.isDisableSelectIndex()) {
            sqlClause.disableSelectIndex();
        }
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return DBCurrent.getInstance().isCurrentDBDef(currentDBDef);
    }

    protected boolean isInnerJoinAutoDetect() {
        return DBFluteConfig.getInstance().isInnerJoinAutoDetect();
    }

    protected boolean isEmptyStringQueryAllowed() {
        return DBFluteConfig.getInstance().isEmptyStringQueryAllowed();
    }

    protected boolean isInvalidQueryChecked() {
        return DBFluteConfig.getInstance().isInvalidQueryChecked();
    }

    protected boolean isDisableSelectIndex() {
        return DBFluteConfig.getInstance().isDisableSelectIndex();
    }
}

