/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QLog {
    private static final Log _log = LogFactory.getLog(QLog.class);
    protected static boolean _queryLogLevelInfo;
    protected static boolean _loggingInHolidayMood;
    protected static boolean _locked;

    public static void log(String sql) {
        if (_queryLogLevelInfo) {
            _log.info((Object)sql);
        } else {
            _log.debug((Object)sql);
        }
    }

    public static boolean isLogEnabled() {
        if (_loggingInHolidayMood) {
            return false;
        }
        if (_queryLogLevelInfo) {
            return _log.isInfoEnabled();
        }
        return _log.isDebugEnabled();
    }

    protected static boolean isQueryLogLevelInfo() {
        return _queryLogLevelInfo;
    }

    public static void setQueryLogLevelInfo(boolean queryLogLevelInfo) {
        QLog.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting queryLogLevelInfo: " + queryLogLevelInfo));
        }
        _queryLogLevelInfo = queryLogLevelInfo;
    }

    protected static boolean isLoggingInHolidayMood() {
        return _loggingInHolidayMood;
    }

    public static void setLoggingInHolidayMood(boolean loggingInHolidayMood) {
        QLog.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting loggingInHolidayMood: " + loggingInHolidayMood));
        }
        _loggingInHolidayMood = loggingInHolidayMood;
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Locking the log object for query!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Unlocking the log object for query!");
        }
        _locked = false;
    }

    protected static void assertNotLocked() {
        if (!QLog.isLocked()) {
            return;
        }
        String msg = "The QLog is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    static {
        _locked = true;
    }
}

