/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core.command;

import java.util.Map;
import org.seasar.robot.dbflute.bhv.core.SqlExecution;
import org.seasar.robot.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.robot.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.execution.SelectNextValExecution;
import org.seasar.robot.dbflute.bhv.core.supplement.SequenceCache;
import org.seasar.robot.dbflute.bhv.core.supplement.SequenceCacheHandler;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.exception.SequenceCacheIncrementSizeInvalidException;
import org.seasar.robot.dbflute.exception.SequenceSelectIllegalStateException;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;

public class SelectNextValCommand<RESULT>
extends AbstractBehaviorCommand<RESULT> {
    protected Class<RESULT> _resultType;
    protected DBMeta _dbmeta;
    protected SequenceCacheHandler _sequenceCacheHandler;

    @Override
    public String getCommandName() {
        return "selectNextVal";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return this._resultType;
    }

    @Override
    public boolean isConditionBean() {
        return false;
    }

    @Override
    public boolean isOutsideSql() {
        return false;
    }

    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public boolean isSelect() {
        return true;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public boolean isSelectCursor() {
        return false;
    }

    @Override
    public boolean isInsert() {
        return false;
    }

    @Override
    public boolean isUpdate() {
        return false;
    }

    @Override
    public boolean isDelete() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this._tableDbName + ":" + this.getCommandName() + "()";
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            @Override
            public SqlExecution createSqlExecution() {
                TnResultSetHandler handler = SelectNextValCommand.this.createDynamicScalarResultSetHandler(SelectNextValCommand.this._resultType);
                return SelectNextValCommand.this.createSelectNextValExecution(handler);
            }
        };
    }

    protected SqlExecution createSelectNextValExecution(TnResultSetHandler handler) {
        this.assertStatus("createSelectNextValExecution");
        DBMeta dbmeta = this._dbmeta;
        this.assertTableHasSequence();
        String sql = this.getSequenceNextValSql();
        this.assertSequenceReturnsNotNull(sql, dbmeta);
        SequenceCache sequenceCache = this.findSequenceCache(dbmeta);
        sql = this.prepareSequenceCache(sql, sequenceCache);
        return this.createSequenceExecution(handler, sql, sequenceCache);
    }

    protected String getSequenceNextValSql() {
        return this._dbmeta.getSequenceNextValSql();
    }

    protected String prepareSequenceCache(String sql, SequenceCache sequenceCache) {
        DBMeta dbmeta = this._dbmeta;
        Integer incrementSize = dbmeta.getSequenceIncrementSize();
        Integer cacheSize = dbmeta.getSequenceCacheSize();
        return this.doPrepareSequenceCache(sql, sequenceCache, incrementSize, cacheSize);
    }

    protected String doPrepareSequenceCache(String sql, SequenceCache sequenceCache, Integer incrementSize, Integer cacheSize) {
        if (sequenceCache != null) {
            DBMeta dbmeta = this._dbmeta;
            if (incrementSize != null) {
                this.assertIncrementSizeNotMinusAndNotZero(incrementSize, dbmeta);
                sql = this._sequenceCacheHandler.filterNextValSql(cacheSize, incrementSize, sql);
            }
        }
        return sql;
    }

    protected void assertTableHasSequence() {
        if (!this._dbmeta.hasSequence()) {
            String msg = "If it uses sequence, the table should be related to a sequence:";
            msg = msg + " table=" + this._dbmeta.getTableDbName() + " sequence=" + this._dbmeta.getSequenceName();
            throw new SequenceSelectIllegalStateException(msg);
        }
    }

    protected void assertSequenceReturnsNotNull(String nextValSql, DBMeta dbmeta) {
        if (nextValSql == null) {
            String msg = "If it uses sequence, SQL for next value should exist:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            throw new SequenceSelectIllegalStateException(msg);
        }
    }

    protected SequenceCache findSequenceCache(DBMeta dbmeta) {
        String tableName = dbmeta.getTableDbName();
        String sequenceName = dbmeta.getSequenceName();
        Integer cacheSize = dbmeta.getSequenceCacheSize();
        Integer incrementSize = dbmeta.getSequenceIncrementSize();
        return this.doFindSequenceCache(tableName, sequenceName, cacheSize, incrementSize);
    }

    protected SequenceCache doFindSequenceCache(String tableName, String sequenceName, Integer cacheSize, Integer incrementSize) {
        return this._sequenceCacheHandler.findSequenceCache(tableName, sequenceName, this._dataSource, this._resultType, cacheSize, incrementSize);
    }

    protected void assertIncrementSizeNotMinusAndNotZero(Integer incrementSize, DBMeta dbmeta) {
        if (incrementSize <= 0) {
            String msg = "The increment size should not be minus or zero if you use sequence cache:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            msg = msg + " cacheSize=" + dbmeta.getSequenceCacheSize();
            msg = msg + " incrementSize=" + dbmeta.getSequenceIncrementSize();
            throw new SequenceCacheIncrementSizeInvalidException(msg);
        }
    }

    protected SelectNextValExecution createSequenceExecution(TnResultSetHandler handler, String sql, SequenceCache sequenceCache) {
        Map<String, Class<?>> argNameTypeMap = this.newArgNameTypeMap();
        return this.newSelectNextValExecution(argNameTypeMap, sql, handler, sequenceCache);
    }

    protected SelectNextValExecution newSelectNextValExecution(Map<String, Class<?>> argNameTypeMap, String sql, TnResultSetHandler handler, SequenceCache sequenceCache) {
        return new SelectNextValExecution(this._dataSource, this._statementFactory, argNameTypeMap, sql, handler, sequenceCache);
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        this.assertStatus("getSqlExecutionArgument");
        return new Object[0];
    }

    @Override
    public ConditionBean getConditionBean() {
        return null;
    }

    @Override
    public String getOutsideSqlPath() {
        return null;
    }

    @Override
    public String getParameterBean() {
        return null;
    }

    @Override
    public OutsideSqlOption getOutsideSqlOption() {
        return null;
    }

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        if (this._dbmeta == null) {
            throw new IllegalStateException(this.buildAssertMessage("_dbmeta", methodName));
        }
    }

    public void setResultType(Class<RESULT> resultType) {
        this._resultType = resultType;
    }

    public void setDBMeta(DBMeta dbmeta) {
        this._dbmeta = dbmeta;
    }

    public void setSequenceCacheHandler(SequenceCacheHandler sequenceCacheHandler) {
        this._sequenceCacheHandler = sequenceCacheHandler;
    }
}

