/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.sqlclause.subquery;

import java.util.Date;
import java.util.List;
import org.seasar.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.DerivedReferrer;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlNameProvider;

public class QueryDerivedReferrer
extends DerivedReferrer {
    protected final String _operand;
    protected final Object _value;
    protected final String _parameterPath;

    public QueryDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String operand, Object value, String parameterPath) {
        super(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQuerySqlClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity);
        this._operand = operand;
        this._value = value;
        this._parameterPath = parameterPath;
    }

    @Override
    protected String doBuildDerivedReferrer(String function, ColumnRealName columnRealName, ColumnSqlName relatedColumnSqlName, String subQueryClause, String beginMark, String endMark, String endIndent) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(beginMark).append(subQueryClause);
        sb.append(this.ln()).append(endIndent).append(") ");
        sb.append(this._operand);
        if (this._value != null) {
            String parameter;
            String prefix = "/*pmb.";
            String suffix = "*/null";
            if (this.isOperandBetween() && this.isValueListType()) {
                String fromParameter = this.buildListParameter("/*pmb.", 0, "*/null");
                String toParameter = this.buildListParameter("/*pmb.", 1, "*/null");
                parameter = fromParameter + " and " + toParameter;
            } else {
                parameter = "/*pmb." + this._parameterPath + "*/null";
            }
            sb.append(" ").append(parameter);
        }
        sb.append(endMark);
        return sb.toString();
    }

    protected boolean isOperandBetween() {
        return "between".equalsIgnoreCase(this._operand);
    }

    protected boolean isValueListType() {
        return this._value instanceof List;
    }

    protected String buildListParameter(String prefix, int index, String suffix) {
        return prefix + this._parameterPath + ".get(" + index + ")" + suffix;
    }

    @Override
    protected void throwDerivedReferrerInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwQueryDerivedReferrerInvalidColumnSpecificationException(function);
    }

    @Override
    protected void doAssertDerivedReferrerColumnType(String function, String derivedColumnDbName, Class<?> derivedColumnType) {
        Object value = this._value;
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(derivedColumnType)) {
            this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
        }
        if (value != null) {
            Class<?> parameterType = value.getClass();
            if (String.class.isAssignableFrom(derivedColumnType) && !String.class.isAssignableFrom(parameterType)) {
                this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
            }
            if (Number.class.isAssignableFrom(derivedColumnType) && !Number.class.isAssignableFrom(parameterType)) {
                this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
            }
            if (Date.class.isAssignableFrom(derivedColumnType) && !Date.class.isAssignableFrom(parameterType)) {
                this.throwQueryDerivedReferrerUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
            }
        }
    }

    protected void throwQueryDerivedReferrerUnmatchedColumnTypeException(String function, String derivedColumnDbName, Class<?> derivedColumnType) {
        this.createCBExThrower().throwQueryDerivedReferrerUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType, this._value);
    }
}

