/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.dbway;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.robot.dbflute.dbway.DBWay;
import org.seasar.robot.dbflute.dbway.StringConnector;

public class WayOfMySQL
implements DBWay,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final StringConnector ORIGINAL_STRING_CONNECTOR = new StringConnector(){

        @Override
        public String connect(Object ... elements) {
            StringBuilder sb = new StringBuilder();
            sb.append("concat(");
            int index = 0;
            for (Object element : elements) {
                if (index > 0) {
                    sb.append(", ");
                }
                sb.append(element);
                ++index;
            }
            sb.append(")");
            return sb.toString();
        }
    };

    @Override
    public String buildSequenceNextValSql(String sequenceName) {
        return null;
    }

    @Override
    public String getIdentitySelectSql() {
        return "SELECT LAST_INSERT_ID()";
    }

    @Override
    public boolean isBlockCommentSupported() {
        return true;
    }

    @Override
    public boolean isLineCommentSupported() {
        return true;
    }

    @Override
    public boolean isScrollableCursorSupported() {
        return true;
    }

    @Override
    public List<String> getOriginalWildCardList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public StringConnector getStringConnector() {
        return ORIGINAL_STRING_CONNECTOR;
    }

    @Override
    public boolean isUniqueConstraintException(String sqlState, Integer errorCode) {
        return errorCode != null && errorCode == 1062;
    }

    public static enum FullTextSearchModifier {
        InBooleanMode("in boolean mode"),
        InNaturalLanguageMode("in natural language mode"),
        InNaturalLanguageModeWithQueryExpansion("in natural language mode with query expansion"),
        WithQueryExpansion("with query expansion");

        private static final Map<String, FullTextSearchModifier> _codeValueMap;
        private String _code;

        private FullTextSearchModifier(String code) {
            this._code = code;
        }

        public String code() {
            return this._code;
        }

        public static FullTextSearchModifier codeOf(Object code) {
            if (code == null) {
                return null;
            }
            return _codeValueMap.get(code.toString().toLowerCase());
        }

        static {
            _codeValueMap = new HashMap<String, FullTextSearchModifier>();
            for (FullTextSearchModifier value : FullTextSearchModifier.values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }
    }
}

