/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.seasar.robot.dbflute.exception.ParseDateExpressionFailureException;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.helper.secretary.BusinessDayDeterminer;
import org.seasar.robot.dbflute.helper.secretary.DateCompareCallback;
import org.seasar.robot.dbflute.util.DfTypeUtil;

public class HandyDate
implements Serializable {
    private static final long serialVersionUID = -5181512291555841795L;
    protected final Calendar _cal;
    protected int _yearBeginMonth;
    protected int _monthBeginDay;
    protected int _dayBeginHour;
    protected int _weekBeginDay;

    public HandyDate(Date date) {
        this.assertConstructorArgumentNotNull("date", date);
        this._cal = this.createCalendar(null);
        this.prepareDefaultBeginAttribute();
        this._cal.setTime(date);
    }

    public HandyDate(String exp) {
        this.assertConstructorArgumentNotNull("exp", exp);
        TimeZone timeZone = null;
        this._cal = this.createCalendar(timeZone);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate((Object)exp, timeZone));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, TimeZone timeZone) {
        this.assertConstructorArgumentNotNull("exp", exp);
        this.assertConstructorArgumentNotNull("timeZone", timeZone);
        this._cal = this.createCalendar(timeZone);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate((Object)exp, timeZone));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, String pattern) {
        this.assertConstructorArgumentNotNull("exp", exp);
        this.assertConstructorArgumentNotNull("pattern", pattern);
        TimeZone timeZone = null;
        this._cal = this.createCalendar(timeZone);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate(exp, pattern, timeZone));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    public HandyDate(String exp, String pattern, TimeZone timeZone) {
        this.assertConstructorArgumentNotNull("exp", exp);
        this.assertConstructorArgumentNotNull("pattern", pattern);
        this.assertConstructorArgumentNotNull("timeZone", timeZone);
        this._cal = this.createCalendar(timeZone);
        this.prepareDefaultBeginAttribute();
        try {
            this._cal.setTime(DfTypeUtil.toDate(exp, pattern, timeZone));
        }
        catch (DfTypeUtil.ParseDateException e) {
            this.throwParseDateExpressionFailureException(exp, e);
        }
    }

    protected void assertConstructorArgumentNotNull(String name, Object value) {
        if (value == null) {
            String msg = "The constructor argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected Calendar createCalendar(TimeZone timeZone) {
        Calendar cal = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
        return cal;
    }

    protected void prepareDefaultBeginAttribute() {
        this._yearBeginMonth = this._cal.getActualMinimum(2) + 1;
        this._monthBeginDay = this._cal.getActualMinimum(5);
        this._dayBeginHour = this._cal.getActualMinimum(11);
        this._weekBeginDay = 1;
    }

    protected void throwParseDateExpressionFailureException(String exp, DfTypeUtil.ParseDateException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to parse the expression as date.");
        br.addItem("Expression");
        br.addElement(exp);
        String msg = br.buildExceptionMessage();
        throw new ParseDateExpressionFailureException(msg, e);
    }

    public HandyDate timeZone(TimeZone timeZone) {
        this.assertArgumentNotNull("timeZone", timeZone);
        this._cal.setTimeZone(timeZone);
        return this;
    }

    public HandyDate addYear(int years) {
        DfTypeUtil.addCalendarYear(this._cal, years);
        return this;
    }

    public HandyDate addMonth(int months) {
        DfTypeUtil.addCalendarMonth(this._cal, months);
        return this;
    }

    public HandyDate addDay(int days) {
        DfTypeUtil.addCalendarDay(this._cal, days);
        return this;
    }

    public HandyDate addHour(int hours) {
        DfTypeUtil.addCalendarHour(this._cal, hours);
        return this;
    }

    public HandyDate addMinute(int minutes) {
        DfTypeUtil.addCalendarMinute(this._cal, minutes);
        return this;
    }

    public HandyDate addSecond(int seconds) {
        DfTypeUtil.addCalendarSecond(this._cal, seconds);
        return this;
    }

    public HandyDate addMillisecond(int milliseconds) {
        DfTypeUtil.addCalendarMillisecond(this._cal, milliseconds);
        return this;
    }

    public HandyDate addWeek(int weeks) {
        DfTypeUtil.addCalendarWeek(this._cal, weeks);
        return this;
    }

    public HandyDate moveToYear(int year) {
        DfTypeUtil.moveToCalendarYear(this._cal, year);
        return this;
    }

    public HandyDate moveToYearJust() {
        DfTypeUtil.moveToCalendarYearJust(this._cal, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToYearJustAdded(int years) {
        DfTypeUtil.moveToCalendarYearJustAdded(this._cal, years);
        return this;
    }

    public HandyDate moveToYearJustFor(int year) {
        DfTypeUtil.moveToCalendarYearJustFor(this._cal, year);
        return this;
    }

    public HandyDate moveToYearTerminal() {
        DfTypeUtil.moveToCalendarYearTerminal(this._cal, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToYearTerminalAdded(int years) {
        DfTypeUtil.moveToCalendarYearTerminalAdded(this._cal, years);
        return this;
    }

    public HandyDate moveToYearTerminalFor(int year) {
        DfTypeUtil.moveToCalendarYearTerminalFor(this._cal, year);
        return this;
    }

    public HandyDate moveToMonth(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonth(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthJust() {
        DfTypeUtil.moveToCalendarMonthJust(this._cal, this._monthBeginDay);
        this.moveToDayJust();
        return this;
    }

    public HandyDate moveToMonthJustAdded(int months) {
        DfTypeUtil.moveToCalendarMonthJustAdded(this._cal, months);
        return this;
    }

    public HandyDate moveToMonthJustFor(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonthJustFor(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthTerminal() {
        DfTypeUtil.moveToCalendarMonthTerminal(this._cal, this._monthBeginDay);
        this.moveToDayTerminal();
        return this;
    }

    public HandyDate moveToMonthTerminalAdded(int months) {
        DfTypeUtil.moveToCalendarMonthTerminalAdded(this._cal, months);
        return this;
    }

    public HandyDate moveToMonthTerminalFor(int month) {
        this.assertValidMonth(month);
        DfTypeUtil.moveToCalendarMonthTerminalFor(this._cal, month);
        return this;
    }

    public HandyDate moveToMonthFirstWeekdayJust() {
        this.moveToMonthJust();
        if (this.isWeek_DayOfWeek1st_Sunday()) {
            this.addDay(1);
        } else if (this.isWeek_DayOfWeek7th_Saturday()) {
            this.addDay(2);
        }
        return this;
    }

    public HandyDate moveToMonthLastWeekdayTerminal() {
        this.moveToMonthTerminal();
        if (this.isWeek_DayOfWeek1st_Sunday()) {
            this.addDay(-2);
        } else if (this.isWeek_DayOfWeek7th_Saturday()) {
            this.addDay(-1);
        }
        return this;
    }

    public HandyDate moveToMonthFirstWeekendJust() {
        this.moveToMonthJust();
        while (!this.isWeek_DayOfWeekWeekend()) {
            this.addDay(1);
        }
        return this;
    }

    public HandyDate moveToMonthLastWeekendTerminal() {
        this.moveToMonthTerminal();
        while (!this.isWeek_DayOfWeekWeekend()) {
            this.addDay(-1);
        }
        return this;
    }

    public HandyDate moveToDay(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDay(this._cal, day);
        return this;
    }

    public HandyDate moveToDayJust() {
        DfTypeUtil.moveToCalendarDayJust(this._cal, this._dayBeginHour);
        return this;
    }

    public HandyDate moveToDayJustAdded(int days) {
        DfTypeUtil.moveToCalendarDayJustAdded(this._cal, days);
        return this;
    }

    public HandyDate moveToDayJustFor(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDayJustFor(this._cal, day);
        return this;
    }

    public HandyDate moveToDayTerminal() {
        DfTypeUtil.moveToCalendarDayTerminal(this._cal, this._dayBeginHour);
        return this;
    }

    public HandyDate moveToDayTerminalAdded(int days) {
        DfTypeUtil.moveToCalendarDayTerminalAdded(this._cal, days);
        return this;
    }

    public HandyDate moveToDayTerminalFor(int day) {
        this.assertValidDay(day);
        DfTypeUtil.moveToCalendarDayTerminalFor(this._cal, day);
        return this;
    }

    public HandyDate moveToHour(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHour(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJust() {
        DfTypeUtil.moveToCalendarHourJust(this._cal);
        return this;
    }

    public HandyDate moveToHourJustAdded(int hours) {
        DfTypeUtil.moveToCalendarHourJustAdded(this._cal, hours);
        return this;
    }

    public HandyDate moveToHourJustFor(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHourJustFor(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourTerminal() {
        DfTypeUtil.moveToCalendarHourTerminal(this._cal);
        return this;
    }

    public HandyDate moveToHourTerminalAdded(int hours) {
        DfTypeUtil.moveToCalendarHourTerminalAdded(this._cal, hours);
        return this;
    }

    public HandyDate moveToHourTerminalFor(int hour) {
        this.assertValidHour(hour);
        DfTypeUtil.moveToCalendarHourTerminalFor(this._cal, hour);
        return this;
    }

    public HandyDate moveToHourJustNoon() {
        DfTypeUtil.moveToCalendarHourJustNoon(this._cal);
        return this;
    }

    public HandyDate moveToMinute(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinute(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteJust() {
        DfTypeUtil.moveToCalendarMinuteJust(this._cal);
        return this;
    }

    public HandyDate moveToMinuteJustAdded(int minutes) {
        DfTypeUtil.moveToCalendarMinuteJustAdded(this._cal, minutes);
        return this;
    }

    public HandyDate moveToMinuteJustFor(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinuteJustFor(this._cal, minute);
        return this;
    }

    public HandyDate moveToMinuteTerminal() {
        DfTypeUtil.moveToCalendarMinuteTerminal(this._cal);
        return this;
    }

    public HandyDate moveToMinuteTerminal\u00c5dded(int minutes) {
        DfTypeUtil.moveToCalendarMinuteTerminalAdded(this._cal, minutes);
        return this;
    }

    public HandyDate moveToMinuteTerminalFor(int minute) {
        this.assertValidMinute(minute);
        DfTypeUtil.moveToCalendarMinuteTerminalFor(this._cal, minute);
        return this;
    }

    public HandyDate moveToSecond(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecond(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondJust() {
        DfTypeUtil.moveToCalendarSecondJust(this._cal);
        return this;
    }

    public HandyDate moveToSecondJustFor(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecondJustFor(this._cal, second);
        return this;
    }

    public HandyDate moveToSecondJustAdded(int seconds) {
        DfTypeUtil.moveToCalendarSecondJustAdded(this._cal, seconds);
        return this;
    }

    public HandyDate moveToSecondTerminal() {
        DfTypeUtil.moveToCalendarSecondTerminal(this._cal);
        return this;
    }

    public HandyDate moveToSecondTerminalAdded(int seconds) {
        DfTypeUtil.moveToCalendarSecondTerminalAdded(this._cal, seconds);
        return this;
    }

    public HandyDate moveToSecondTerminalFor(int second) {
        this.assertValidSecond(second);
        DfTypeUtil.moveToCalendarSecondTerminalFor(this._cal, second);
        return this;
    }

    public HandyDate moveToMillisecond(int millisecond) {
        this.assertValidMillisecond(millisecond);
        DfTypeUtil.moveToCalendarMillisecond(this._cal, millisecond);
        return this;
    }

    public HandyDate moveToWeekOfMonth(int weekOfMonth) {
        DfTypeUtil.moveToCalendarWeekOfMonth(this._cal, weekOfMonth);
        return this;
    }

    public HandyDate moveToWeekOfYear(int weekOfYear) {
        DfTypeUtil.moveToCalendarWeekOfYear(this._cal, weekOfYear);
        return this;
    }

    public HandyDate moveToWeekJust() {
        DfTypeUtil.moveToCalendarWeekJust(this._cal, this._weekBeginDay);
        return this;
    }

    public HandyDate moveToWeekTerminal() {
        DfTypeUtil.moveToCalendarWeekTerminal(this._cal, this._weekBeginDay);
        return this;
    }

    public HandyDate moveToQuarterOfYearJust() {
        DfTypeUtil.moveToCalendarQuarterOfYearJust(this._cal, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearJustAdded(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustAdded(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearJustFor(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthJust();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminal() {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(this._cal, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminalAdded(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalAdded(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToQuarterOfYearTerminalFor(int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalFor(this._cal, quarterOfYear, this._yearBeginMonth);
        this.moveToMonthTerminal();
        return this;
    }

    public HandyDate moveToNextBusinessDay(BusinessDayDeterminer determiner) {
        block1: {
            this.assertArgumentNotNull("determiner", determiner);
            int addedLimit = 1000;
            int addedCount = 0;
            do {
                this.addDay(1);
                ++addedCount;
                if (determiner.isBusinessDay(this)) break block1;
            } while (addedCount <= 1000);
            String msg = "Business day is so far: limit=1000";
            throw new IllegalStateException(msg);
        }
        return this;
    }

    public HandyDate moveToNextBusinessDay(int movedDays, BusinessDayDeterminer determiner) {
        this.assertArgumentNotNull("determiner", determiner);
        if (movedDays < 0) {
            String msg = "The argument 'movedDays' should not be minus: " + movedDays;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < movedDays; ++i) {
            this.moveToNextBusinessDay(determiner);
        }
        return this;
    }

    public HandyDate clearTimeParts() {
        DfTypeUtil.clearCalendarTimeParts(this._cal);
        return this;
    }

    public HandyDate clearMinuteWithRear() {
        DfTypeUtil.clearCalendarMinuteWithRear(this._cal);
        return this;
    }

    public HandyDate clearSecondWithRear() {
        DfTypeUtil.clearCalendarSecondWithRear(this._cal);
        return this;
    }

    public HandyDate clearMillisecond() {
        DfTypeUtil.clearCalendarMillisecond(this._cal);
        return this;
    }

    public boolean isMatch(Date date) {
        this.assertArgumentNotNull("date", date);
        return this._cal.getTimeInMillis() == date.getTime();
    }

    public boolean isGreaterThan(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterThanAll(date);
    }

    public boolean isGreaterThanAll(Date ... dates) {
        return this.doCompareAll(this.createGreaterThanCompareCallback(), dates);
    }

    public boolean isGreaterThanAny(Date ... dates) {
        return this.doCompareAny(this.createGreaterThanCompareCallback(), dates);
    }

    protected DateCompareCallback createGreaterThanCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.after(date);
            }
        };
    }

    public boolean isGreaterEqual(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isGreaterEqualAll(date);
    }

    public boolean isGreaterEqualAll(Date ... dates) {
        return this.doCompareAll(this.createGreaterEqualCompareCallback(), dates);
    }

    public boolean isGreaterEqualAny(Date ... dates) {
        return this.doCompareAny(this.createGreaterEqualCompareCallback(), dates);
    }

    protected DateCompareCallback createGreaterEqualCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.after(date) || current.equals(date);
            }
        };
    }

    public boolean isLessThan(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessThanAll(date);
    }

    public boolean isLessThanAll(Date ... dates) {
        return this.doCompareAll(this.createLessThanCompareCallback(), dates);
    }

    public boolean isLessThanAny(Date ... dates) {
        return this.doCompareAny(this.createLessThanCompareCallback(), dates);
    }

    protected DateCompareCallback createLessThanCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.before(date);
            }
        };
    }

    public boolean isLessEqual(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isLessEqualAll(date);
    }

    public boolean isLessEqualAll(Date ... dates) {
        return this.doCompareAll(this.createLessEqualCompareCallback(), dates);
    }

    public boolean isLessEqualAny(Date ... dates) {
        return this.doCompareAny(this.createLessEqualCompareCallback(), dates);
    }

    protected DateCompareCallback createLessEqualCompareCallback() {
        return new DateCompareCallback(){

            @Override
            public boolean isTarget(Date current, Date date) {
                return current.before(date) || current.equals(date);
            }
        };
    }

    protected boolean doCompareAll(DateCompareCallback callback, Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Date current = this.getDate();
        for (Date date : dates) {
            if (callback.isTarget(current, date)) continue;
            return false;
        }
        return true;
    }

    protected boolean doCompareAny(DateCompareCallback callback, Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Date current = this.getDate();
        for (Date date : dates) {
            if (!callback.isTarget(current, date)) continue;
            return true;
        }
        return false;
    }

    protected void assertCompareDateArrayValid(Date[] dates) {
        if (dates == null || dates.length == 0) {
            String msg = "The argument 'dates' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean isYear(int year) {
        return this.getYear() == year;
    }

    public boolean isYearSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.getYear() == this.prepareCompareDate(date).getYear();
    }

    public boolean isYearSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getYear() == handyDate.getYear();
    }

    public boolean isYear_AnnoDomini() {
        return this.getYear() > 0;
    }

    public boolean isYear_BeforeChrist() {
        return this.getYear() < 0;
    }

    public boolean isMonth(int month) {
        return this.getMonthAsOneOrigin() == month;
    }

    public boolean isMonthSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.getMonthAsOneOrigin() == this.prepareCompareDate(date).getMonthAsOneOrigin();
    }

    public boolean isMonthSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getMonthAsOneOrigin() == handyDate.getMonthAsOneOrigin();
    }

    public boolean isMonthOfYearSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isMonthOfYearSameAs(this.prepareCompareDate(date));
    }

    public boolean isMonthOfYearSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isYearSameAs(handyDate) && this.getMonthAsOneOrigin() == handyDate.getMonthAsOneOrigin();
    }

    public boolean isMonth01_January() {
        return this.isMonth(1);
    }

    public boolean isMonth02_February() {
        return this.isMonth(2);
    }

    public boolean isMonth03_March() {
        return this.isMonth(3);
    }

    public boolean isMonth04_April() {
        return this.isMonth(4);
    }

    public boolean isMonth05_May() {
        return this.isMonth(5);
    }

    public boolean isMonth06_June() {
        return this.isMonth(6);
    }

    public boolean isMonth07_July() {
        return this.isMonth(7);
    }

    public boolean isMonth08_August() {
        return this.isMonth(8);
    }

    public boolean isMonth09_September() {
        return this.isMonth(9);
    }

    public boolean isMonth10_October() {
        return this.isMonth(10);
    }

    public boolean isMonth11_November() {
        return this.isMonth(11);
    }

    public boolean isMonth12_December() {
        return this.isMonth(12);
    }

    public boolean isDay(int day) {
        return this.getDay() == day;
    }

    public boolean isDaySameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.getDay() == this.prepareCompareDate(date).getDay();
    }

    public boolean isDaySameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getDay() == handyDate.getDay();
    }

    public boolean isDayOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isDayOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isDayOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isMonthOfYearSameAs(handyDate) && this.getDay() == handyDate.getDay();
    }

    public boolean isDay_MonthFirstDay() {
        return this.isDay(this._cal.getActualMinimum(5));
    }

    public boolean isDay_MonthLastDay() {
        return this.isDay(this._cal.getActualMaximum(5));
    }

    public boolean isHour(int hour) {
        return this.getHour() == hour;
    }

    public boolean isHourSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isHourSameAs(this.prepareCompareDate(date));
    }

    public boolean isHourSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getHour() == handyDate.getHour();
    }

    public boolean isHourOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isHourOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isHourOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isDayOfDateSameAs(handyDate) && this.getHour() == handyDate.getHour();
    }

    public boolean isMinute(int minute) {
        return this.getMinute() == minute;
    }

    public boolean isMinuteSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getMinute() == handyDate.getMinute();
    }

    public boolean isMinuteOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isMinuteOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isMinuteOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isHourOfDateSameAs(handyDate) && this.getMinute() == handyDate.getMinute();
    }

    public boolean isSecond(int second) {
        return this.getSecond() == second;
    }

    public boolean isSecondSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.getSecond() == handyDate.getSecond();
    }

    public boolean isSecondOfDateSameAs(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.isSecondOfDateSameAs(this.prepareCompareDate(date));
    }

    public boolean isSecondOfDateSameAs(HandyDate handyDate) {
        this.assertArgumentNotNull("handyDate", handyDate);
        return this.isMinuteOfDateSameAs(handyDate) && this.getSecond() == handyDate.getSecond();
    }

    public boolean isWeek_DayOfWeek1st_Sunday() {
        return this.getDayOfWeek() == 1;
    }

    public boolean isWeek_DayOfWeek2nd_Monday() {
        return this.getDayOfWeek() == 2;
    }

    public boolean isWeek_DayOfWeek3rd_Tuesday() {
        return this.getDayOfWeek() == 3;
    }

    public boolean isWeek_DayOfWeek4th_Wednesday() {
        return this.getDayOfWeek() == 4;
    }

    public boolean isWeek_DayOfWeek5th_Thursday() {
        return this.getDayOfWeek() == 5;
    }

    public boolean isWeek_DayOfWeek6th_Friday() {
        return this.getDayOfWeek() == 6;
    }

    public boolean isWeek_DayOfWeek7th_Saturday() {
        return this.getDayOfWeek() == 7;
    }

    public boolean isWeek_DayOfWeekWeekday() {
        return !this.isWeek_DayOfWeek1st_Sunday() && !this.isWeek_DayOfWeek7th_Saturday();
    }

    public boolean isWeek_DayOfWeekWeekend() {
        return this.isWeek_DayOfWeek1st_Sunday() || this.isWeek_DayOfWeek7th_Saturday();
    }

    public int calculateCalendarDistanceYears(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isYearSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        return you.getYear() - this.getYear();
    }

    public int calculateDistanceYears(Date date) {
        return this.calculateCalendarDistanceYears(date);
    }

    public int calculateCalendarDistanceMonths(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isMonthOfYearSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        int countMonths = 0;
        while (!this.isMonthOfYearSameAs(you)) {
            int baseMonths;
            boolean sameAs = this.isYearSameAs(you);
            int n = sameAs ? this.getMonthAsOneOrigin() : (baseMonths = greater ? 12 : 1);
            int adjustmentMonths = sameAs ? 0 : (greater ? 1 : -1);
            int plusMonths = baseMonths - you.getMonthAsOneOrigin() + adjustmentMonths;
            you.addMonth(plusMonths);
            countMonths += plusMonths;
        }
        return -1 * countMonths;
    }

    public int calculateDistanceMonths(Date date) {
        return this.calculateCalendarDistanceMonths(date);
    }

    public int calculateCalendarDistanceDays(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isDayOfDateSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        int countDays = 0;
        while (!this.isDayOfDateSameAs(you)) {
            int baseDays;
            boolean sameAs = this.isMonthOfYearSameAs(you);
            int n = sameAs ? this.getDay() : (baseDays = greater ? you.getLastDayOfMonth() : you.getFirstDayOfMonth());
            int adjustmentDays = sameAs ? 0 : (greater ? 1 : -1);
            int plusDays = baseDays - you.getDay() + adjustmentDays;
            you.addDay(plusDays);
            countDays += plusDays;
        }
        return -1 * countDays;
    }

    public int calculateDistanceDays(Date date) {
        return this.calculateCalendarDistanceDays(date);
    }

    public int calculateCalendarDistanceHours(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isHourOfDateSameAs(date)) {
            return 0;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        int countHours = 0;
        while (!this.isHourOfDateSameAs(you)) {
            int baseHours;
            boolean sameAs = this.isDayOfDateSameAs(you);
            int n = sameAs ? this.getHour() : (baseHours = greater ? 23 : 0);
            int adjustmentHours = sameAs ? 0 : (greater ? 1 : -1);
            int plusHours = baseHours - you.getHour() + adjustmentHours;
            you.addHour(plusHours);
            countHours += plusHours;
        }
        return -1 * countHours;
    }

    public long calculateCalendarDistanceMinutes(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isMinuteOfDateSameAs(date)) {
            return 0L;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        long countMinutes = 0L;
        while (!this.isMinuteOfDateSameAs(you)) {
            int baseMinutes;
            boolean sameAs = this.isHourOfDateSameAs(you);
            int n = sameAs ? this.getMinute() : (baseMinutes = greater ? 59 : 0);
            int adjustmentMinutes = sameAs ? 0 : (greater ? 1 : -1);
            int plusMinutes = baseMinutes - you.getMinute() + adjustmentMinutes;
            you.addMinute(plusMinutes);
            countMinutes += (long)plusMinutes;
        }
        return -1L * countMinutes;
    }

    public long calculateCalendarDistanceSeconds(Date date) {
        this.assertArgumentNotNull("date", date);
        if (this.isSecondOfDateSameAs(date)) {
            return 0L;
        }
        HandyDate you = this.prepareCompareDate(date);
        boolean greater = this.isGreaterThan(date);
        long countSeconds = 0L;
        while (!this.isSecondOfDateSameAs(you)) {
            int baseSeconds;
            boolean sameAs = this.isMinuteOfDateSameAs(you);
            int n = sameAs ? this.getSecond() : (baseSeconds = greater ? 59 : 0);
            int adjustmentSeconds = sameAs ? 0 : (greater ? 1 : -1);
            int plusSeconds = baseSeconds - you.getSecond() + adjustmentSeconds;
            you.addSecond(plusSeconds);
            countSeconds += (long)plusSeconds;
        }
        return -1L * countSeconds;
    }

    public long calculateCalendarDistanceMilliseconds(Date date) {
        this.assertArgumentNotNull("date", date);
        return date.getTime() - this._cal.getTimeInMillis();
    }

    public int calculateMeasuredDistanceYears(Date date) {
        int months = this.calculateMeasuredDistanceMonths(date);
        return months / 12 + (months % 12 > 6 ? 1 : 0);
    }

    public int calculateMeasuredDistanceMonths(Date date) {
        int months;
        HandyDate copyInstance = this.createCopyInstance();
        int diffDays = copyInstance.addMonth(months = this.calculateCalendarDistanceMonths(date)).calculateCalendarDistanceDays(date);
        return months + (diffDays > 15 ? 1 : (diffDays < -15 ? -1 : 0));
    }

    public int calculateMeasuredDistanceDays(Date date) {
        int hours = this.calculateMeasuredDistanceHours(date);
        return hours / 24 + (hours % 24 > 12 ? 1 : 0);
    }

    public int calculateMeasuredDistanceHours(Date date) {
        long minutes = this.calculateMeasuredDistanceMinutes(date);
        return (int)(minutes / 60L) + (minutes % 60L > 30L ? 1 : 0);
    }

    public long calculateMeasuredDistanceMinutes(Date date) {
        long seconds = this.calculateMeasuredDistanceSeconds(date);
        return seconds / 60L + (seconds % 60L > 30L ? 1L : 0L);
    }

    public long calculateMeasuredDistanceSeconds(Date date) {
        long milliseconds = this.calculateCalendarDistanceMilliseconds(date);
        return milliseconds / 1000L + (milliseconds % 1000L > 500L ? 1L : 0L);
    }

    public int calculateSizeBusinessDays(Date date, BusinessDayDeterminer determiner) {
        this.assertArgumentNotNull("date", date);
        if (this.isDayOfDateSameAs(date)) {
            return 0;
        }
        int countDays = 0;
        HandyDate you = this.prepareCompareDate(date);
        if (determiner.isBusinessDay(you)) {
            ++countDays;
        }
        boolean greater = this.isGreaterThan(date);
        while (!this.isDayOfDateSameAs(you)) {
            you.addDay(greater ? 1 : -1);
            if (!determiner.isBusinessDay(you)) continue;
            ++countDays;
        }
        return countDays > 0 ? countDays : countDays * -1;
    }

    public int calculateSizeWeekdays(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.calculateSizeBusinessDays(date, new BusinessDayDeterminer(){

            @Override
            public boolean isBusinessDay(HandyDate handyDate) {
                return handyDate.isWeek_DayOfWeekWeekday();
            }
        });
    }

    public int calculateSizeWeekendDays(Date date) {
        this.assertArgumentNotNull("date", date);
        return this.calculateSizeBusinessDays(date, new BusinessDayDeterminer(){

            @Override
            public boolean isBusinessDay(HandyDate handyDate) {
                return handyDate.isWeek_DayOfWeekWeekend();
            }
        });
    }

    public Date chooseNearestDate(Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Long nearestMillis = null;
        Date nearestDate = null;
        long standardMillis = this._cal.getTimeInMillis();
        for (Date date : dates) {
            long distanceMillis = date.getTime() - standardMillis;
            boolean past = false;
            if (distanceMillis < 0L) {
                distanceMillis *= -1L;
                past = true;
            }
            if (nearestMillis == null || nearestMillis > distanceMillis) {
                nearestMillis = distanceMillis;
                nearestDate = date;
                continue;
            }
            if (nearestMillis != distanceMillis || past) continue;
            nearestDate = date;
        }
        return nearestDate;
    }

    public Date chooseNearestFutureDate(Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Long nearestMillis = null;
        Date nearestDate = null;
        long standardMillis = this._cal.getTimeInMillis();
        for (Date date : dates) {
            long distanceMillis = date.getTime() - standardMillis;
            if (distanceMillis < 0L || nearestMillis != null && nearestMillis <= distanceMillis) continue;
            nearestMillis = distanceMillis;
            nearestDate = date;
        }
        return nearestDate;
    }

    public Date chooseNearestPastDate(Date ... dates) {
        this.assertCompareDateArrayValid(dates);
        Long nearestMillis = null;
        Date nearestDate = null;
        long standardMillis = this._cal.getTimeInMillis();
        for (Date date : dates) {
            long distanceMillis = date.getTime() - standardMillis;
            if (distanceMillis > 0L || nearestMillis != null && nearestMillis <= (distanceMillis *= -1L)) continue;
            nearestMillis = distanceMillis;
            nearestDate = date;
        }
        return nearestDate;
    }

    public HandyDate beginYear_Month(Date yearBeginMonth) {
        this.assertArgumentNotNull("yearBeginMonth", yearBeginMonth);
        Calendar cal = Calendar.getInstance();
        cal.setTime(yearBeginMonth);
        this._yearBeginMonth = cal.get(2) + 1;
        return this;
    }

    public HandyDate beginYear_Month(int yearBeginMonth) {
        this.assertNotMinusNotOver("yearBeginMonth", yearBeginMonth, 12);
        this._yearBeginMonth = yearBeginMonth;
        return this;
    }

    public HandyDate beginYear_Month01_January() {
        this._yearBeginMonth = 1;
        return this;
    }

    public HandyDate beginYear_Month02_February() {
        this._yearBeginMonth = 2;
        return this;
    }

    public HandyDate beginYear_Month03_March() {
        this._yearBeginMonth = 3;
        return this;
    }

    public HandyDate beginYear_Month04_April() {
        this._yearBeginMonth = 4;
        return this;
    }

    public HandyDate beginYear_Month05_May() {
        this._yearBeginMonth = 5;
        return this;
    }

    public HandyDate beginYear_Month06_June() {
        this._yearBeginMonth = 6;
        return this;
    }

    public HandyDate beginYear_Month07_July() {
        this._yearBeginMonth = 7;
        return this;
    }

    public HandyDate beginYear_Month08_August() {
        this._yearBeginMonth = 8;
        return this;
    }

    public HandyDate beginYear_Month09_September() {
        this._yearBeginMonth = 9;
        return this;
    }

    public HandyDate beginYear_Month10_October() {
        this._yearBeginMonth = 10;
        return this;
    }

    public HandyDate beginYear_Month11_November() {
        this._yearBeginMonth = 11;
        return this;
    }

    public HandyDate beginYear_Month12_December() {
        this._yearBeginMonth = 12;
        return this;
    }

    public HandyDate beginYear_PreviousMonth(int yearBeginMonth) {
        this.assertNotMinusNotOver("yearBeginMonth", yearBeginMonth, 12);
        this._yearBeginMonth = -yearBeginMonth;
        return this;
    }

    public HandyDate beginMonth_Day(Date monthBeginDay) {
        this.assertArgumentNotNull("monthBeginDay", monthBeginDay);
        Calendar cal = Calendar.getInstance();
        cal.setTime(monthBeginDay);
        this._monthBeginDay = cal.get(5);
        return this;
    }

    public HandyDate beginMonth_Day(int monthBeginDay) {
        this.assertNotMinusNotOver("monthBeginDay", monthBeginDay, 31);
        this._monthBeginDay = monthBeginDay;
        return this;
    }

    public HandyDate beginMonth_PreviousDay(int monthBeginDay) {
        this.assertNotMinusNotOver("monthBeginDay", monthBeginDay, 31);
        this._monthBeginDay = -monthBeginDay;
        return this;
    }

    public HandyDate beginDay_Hour(Date dayBeginHour) {
        this.assertArgumentNotNull("dayBeginHour", dayBeginHour);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dayBeginHour);
        this._dayBeginHour = cal.get(11);
        return this;
    }

    public HandyDate beginDay_Hour(int dayBeginHour) {
        this.assertNotMinusNotOver("dayBeginHour", dayBeginHour, 23);
        this._dayBeginHour = dayBeginHour;
        return this;
    }

    public HandyDate beginDay_PreviousHour(int dayBeginHour) {
        this.assertNotMinusNotOver("dayBeginHour", dayBeginHour, 23);
        this._dayBeginHour = -dayBeginHour;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek(Date weekBeginDayOfWeek) {
        this.assertArgumentNotNull("weekBeginDayOfWeek", weekBeginDayOfWeek);
        Calendar cal = Calendar.getInstance();
        cal.setTime(weekBeginDayOfWeek);
        this._weekBeginDay = cal.get(7);
        return this;
    }

    public HandyDate beginWeek_DayOfWeek1st_Sunday() {
        this._weekBeginDay = 1;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek2nd_Monday() {
        this._weekBeginDay = 2;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek3rd_Tuesday() {
        this._weekBeginDay = 3;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek4th_Wednesday() {
        this._weekBeginDay = 4;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek5th_Thursday() {
        this._weekBeginDay = 5;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek6th_Friday() {
        this._weekBeginDay = 6;
        return this;
    }

    public HandyDate beginWeek_DayOfWeek7th_Saturday() {
        this._weekBeginDay = 7;
        return this;
    }

    public Date getDate() {
        return new Date(this._cal.getTimeInMillis());
    }

    public Timestamp getTimestamp() {
        return new Timestamp(this._cal.getTimeInMillis());
    }

    public int getYear() {
        int year = this._cal.get(1);
        int era = this._cal.get(0);
        return era == 1 ? year : -year;
    }

    public int getMonthAsOneOrigin() {
        return this._cal.get(2) + 1;
    }

    public int getMonthAsZeroOrigin() {
        return this._cal.get(2);
    }

    public int getDay() {
        return this._cal.get(5);
    }

    public int getHour() {
        return this._cal.get(11);
    }

    public int getMinute() {
        return this._cal.get(12);
    }

    public int getSecond() {
        return this._cal.get(13);
    }

    public int getMillisecond() {
        return this._cal.get(14);
    }

    public int getDayOfWeek() {
        return this._cal.get(7);
    }

    public int getFirstDayOfMonth() {
        return this._cal.getActualMinimum(5);
    }

    public int getLastDayOfMonth() {
        return this._cal.getActualMaximum(5);
    }

    public String toDisp(String pattern) {
        this.assertArgumentNotNull("pattern", pattern);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, this._cal.getTimeZone(), null);
        return dateFormat.format(date);
    }

    public String toDisp(String pattern, TimeZone timeZone) {
        this.assertArgumentNotNull("pattern", pattern);
        this.assertArgumentNotNull("timeZone", timeZone);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, timeZone, null);
        return dateFormat.format(date);
    }

    public String toDisp(String pattern, TimeZone timeZone, Locale locale) {
        this.assertArgumentNotNull("pattern", pattern);
        this.assertArgumentNotNull("timeZone", timeZone);
        this.assertArgumentNotNull("locale", locale);
        Date date = this._cal.getTime();
        DateFormat dateFormat = this.createDateFormat(pattern, timeZone, locale);
        return dateFormat.format(date);
    }

    protected DateFormat createDateFormat(String pattern, TimeZone timeZone, Locale locale) {
        SimpleDateFormat dateFormat = locale != null ? new SimpleDateFormat(pattern, locale) : new SimpleDateFormat(pattern);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HandyDate) {
            HandyDate date = (HandyDate)obj;
            String pattern = this.getBasicPattern();
            return date.toDisp(pattern).equals(this.toDisp(pattern));
        }
        return false;
    }

    public int hashCode() {
        return this.toDisp(this.getBasicPattern()).hashCode();
    }

    public String toString() {
        return this.toDisp(this.getBasicPattern());
    }

    protected String getBasicPattern() {
        if (this.isYear_BeforeChrist()) {
            return "'BC'yyyy/MM/dd HH:mm:ss.SSS";
        }
        return "yyyy/MM/dd HH:mm:ss.SSS";
    }

    public HandyDate deepCopy() {
        HandyDate cloned = this.createCopyInstance();
        this.inheritBeginAttribute(cloned);
        return cloned;
    }

    protected HandyDate createCopyInstance() {
        return this.createCopyInstance(this.getDate());
    }

    protected HandyDate createCopyInstance(Date date) {
        HandyDate copy = new HandyDate(date);
        this.inheritTimeZone(copy);
        this.inheritBeginAttribute(copy);
        return copy;
    }

    protected void inheritTimeZone(HandyDate copy) {
        TimeZone timeZone = this._cal.getTimeZone();
        if (timeZone != null) {
            copy.timeZone(timeZone);
        }
    }

    protected void inheritBeginAttribute(HandyDate cloned) {
        cloned._yearBeginMonth = this._yearBeginMonth;
        cloned._monthBeginDay = this._monthBeginDay;
        cloned._dayBeginHour = this._dayBeginHour;
        cloned._weekBeginDay = this._weekBeginDay;
    }

    protected HandyDate prepareCompareDate(Date date) {
        return this.createCopyInstance(date);
    }

    protected void assertArgumentNotNull(String name, Object value) {
        if (value == null) {
            String msg = "The argument '" + name + "' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertNotMinusNotOver(String name, int value, int max) {
        if (value < 0) {
            String msg = "The argument '" + name + "' should not be minus: value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value > max) {
            String msg = "The argument '" + name + "' should not be over: value=" + value + " max=" + max;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidMonth(int month) {
        if (month < 1 || month > 12) {
            String msg = "The argument 'month' should be 1 to 12: " + month;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidDay(int day) {
        int firstDayOfMonth = this.getFirstDayOfMonth();
        int lastDayOfMonth = this.getLastDayOfMonth();
        if (day < firstDayOfMonth || day > lastDayOfMonth) {
            String msg = "The argument 'day' should be " + firstDayOfMonth + " to " + lastDayOfMonth + ": " + day;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidHour(int hour) {
    }

    protected void assertValidMinute(int minute) {
        if (minute < 0 || minute > 59) {
            String msg = "The argument 'minute' should be 0 to 59: " + minute;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidSecond(int second) {
        if (second < 0 || second > 59) {
            String msg = "The argument 'second' should be 0 to 59: " + second;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertValidMillisecond(int millisecond) {
        if (millisecond < 0 || millisecond > 999) {
            String msg = "The argument 'millisecond' should be 0 to 999: " + millisecond;
            throw new IllegalArgumentException(msg);
        }
    }
}

