/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.beans.exception;

public class DfBeanConstructorNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Class<?> targetClass;
    private Object[] methodArgs;
    private Class<?>[] paramTypes;

    public DfBeanConstructorNotFoundException(Class<?> targetClass, Object[] methodArgs) {
        super("The constructor was not found: class=" + targetClass.getName() + " args=" + DfBeanConstructorNotFoundException.getSignature(methodArgs));
        this.targetClass = targetClass;
        this.methodArgs = methodArgs;
    }

    public DfBeanConstructorNotFoundException(Class<?> targetClass, Class<?>[] paramTypes) {
        super("The constructor was not found: class=" + targetClass.getName() + " args=" + DfBeanConstructorNotFoundException.getSignature(paramTypes));
        this.targetClass = targetClass;
        this.paramTypes = paramTypes;
    }

    private static String getSignature(Object[] methodArgs) {
        StringBuffer buf = new StringBuffer(100);
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (methodArgs[i] != null) {
                    buf.append(methodArgs[i].getClass().getName());
                    continue;
                }
                buf.append("null");
            }
        }
        return buf.toString();
    }

    private static String getSignature(Class<?>[] paramTypes) {
        StringBuffer buf = new StringBuffer(100);
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (paramTypes[i] != null) {
                    buf.append(paramTypes[i].getName());
                    continue;
                }
                buf.append("null");
            }
        }
        return buf.toString();
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Object[] getMethodArgs() {
        return this.methodArgs;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }
}

