/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.beans.exception;

public class DfBeanMethodNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Class<?> targetClass;
    private String methodName;
    private Class<?>[] methodArgClasses;

    public DfBeanMethodNotFoundException(Class<?> targetClass, String methodName, Object[] methodArgs) {
        super("The method was not found: class=" + targetClass.getName() + " method=" + methodName + " args=" + DfBeanMethodNotFoundException.getSignature(methodArgs));
        this.targetClass = targetClass;
        this.methodName = methodName;
        if (methodArgs != null) {
            this.methodArgClasses = new Class[methodArgs.length];
            for (int i = 0; i < methodArgs.length; ++i) {
                if (methodArgs[i] == null) continue;
                this.methodArgClasses[i] = methodArgs[i].getClass();
            }
        }
    }

    public DfBeanMethodNotFoundException(Class<?> targetClass, String methodName, Class<?>[] methodArgClasses) {
        super("The method was not found: class=" + targetClass.getName() + " method=" + methodName + " args=" + DfBeanMethodNotFoundException.getSignature(methodArgClasses));
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.methodArgClasses = methodArgClasses;
    }

    private static String getSignature(Object[] methodArgs) {
        StringBuffer buf = new StringBuffer(100);
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (methodArgs[i] != null) {
                    buf.append(methodArgs[i].getClass().getName());
                    continue;
                }
                buf.append("null");
            }
        }
        return buf.toString();
    }

    private static String getSignature(Class<?>[] paramTypes) {
        StringBuffer buf = new StringBuffer(100);
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (paramTypes[i] != null) {
                    buf.append(paramTypes[i].getName());
                    continue;
                }
                buf.append("null");
            }
        }
        return buf.toString();
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getMethodArgClasses() {
        return this.methodArgClasses;
    }
}

