/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.seasar.robot.dbflute.helper.filesystem.FileHierarchyTracingHandler;
import org.seasar.robot.dbflute.helper.filesystem.exception.FileHierarchyTracingIOFailureException;

public class FileHierarchyTracer {
    public void trace(File rootDir, FileHierarchyTracingHandler handler) {
        if (rootDir == null) {
            String msg = "The argument 'rootDir' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            this.doTrace(rootDir, handler);
        }
        catch (IOException e) {
            String msg = "Failed to trace the directory: " + rootDir;
            throw new FileHierarchyTracingIOFailureException(msg, e);
        }
    }

    protected void doTrace(File currentDir, final FileHierarchyTracingHandler handler) throws IOException {
        File[] listFiles = currentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return handler.isTargetFileOrDir(file);
            }
        });
        if (listFiles == null) {
            return;
        }
        this.orderListFiles(listFiles);
        for (File elementFile : listFiles) {
            if (elementFile.isDirectory()) {
                this.doTrace(elementFile, handler);
                continue;
            }
            handler.handleFile(elementFile);
        }
    }

    protected void orderListFiles(File[] listFiles) {
        Arrays.sort(listFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }
}

