/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.outsidesql.executor;

import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.robot.dbflute.bhv.core.command.OutsideSqlSelectCursorCommand;
import org.seasar.robot.dbflute.jdbc.CursorHandler;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.robot.dbflute.outsidesql.factory.OutsideSqlContextFactory;
import org.seasar.robot.dbflute.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.robot.dbflute.outsidesql.typed.CursorHandlingPmb;

public class OutsideSqlCursorExecutor<BEHAVIOR> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected DBDef _currentDBDef;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final OutsideSqlContextFactory _outsideSqlContextFactory;
    protected final OutsideSqlFilter _outsideSqlFilter;
    protected final OutsideSqlExecutorFactory _outsideSqlExecutorFactory;

    public OutsideSqlCursorExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, OutsideSqlOption outsideSqlOption, OutsideSqlContextFactory outsideSqlContextFactory, OutsideSqlFilter outsideSqlFilter, OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._outsideSqlOption = outsideSqlOption;
        this._outsideSqlContextFactory = outsideSqlContextFactory;
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
        this._outsideSqlFilter = outsideSqlFilter;
    }

    public <ENTITY> Object selectCursor(CursorHandlingPmb<BEHAVIOR, ENTITY> pmb, CursorHandler handler) {
        if (pmb == null) {
            String msg = "The argument 'pmb' (typed parameter-bean) should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.doSelectCursor(pmb.getOutsideSqlPath(), pmb, handler);
    }

    public Object selectCursor(String path, Object pmb, CursorHandler handler) {
        return this.doSelectCursor(path, pmb, handler);
    }

    protected Object doSelectCursor(String path, Object pmb, CursorHandler handler) {
        if (path == null) {
            String msg = "The argument 'path' of outside-SQL should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (handler == null) {
            String msg = "The argument 'handler' of cursor should not be null: path=" + path;
            throw new IllegalArgumentException(msg);
        }
        return this.invoke(this.createSelectCursorCommand(path, pmb, handler));
    }

    protected BehaviorCommand<Object> createSelectCursorCommand(String path, Object pmb, CursorHandler handler) {
        return this.xsetupCommand(this.newOutsideSqlSelectCursorCommand(), path, pmb, handler);
    }

    protected OutsideSqlSelectCursorCommand newOutsideSqlSelectCursorCommand() {
        return new OutsideSqlSelectCursorCommand();
    }

    protected OutsideSqlSelectCursorCommand xsetupCommand(OutsideSqlSelectCursorCommand cmd, String path, Object pmb, CursorHandler handler) {
        cmd.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setOutsideSqlPath(path);
        cmd.setParameterBean(pmb);
        cmd.setOutsideSqlOption(this._outsideSqlOption);
        cmd.setCurrentDBDef(this._currentDBDef);
        cmd.setOutsideSqlContextFactory(this._outsideSqlContextFactory);
        cmd.setOutsideSqlFilter(this._outsideSqlFilter);
        cmd.setCursorHandler(handler);
        return cmd;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlCursorExecutor<BEHAVIOR> removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public OutsideSqlCursorExecutor<BEHAVIOR> removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public OutsideSqlCursorExecutor<BEHAVIOR> formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public OutsideSqlCursorExecutor<BEHAVIOR> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }
}

