/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis.monitor;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.monitor.MonitoringTask;
import jp.sf.fess.solr.plugin.util.MonitoringUtil;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeSource;

public class MonitoringTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final boolean VERBOSE = false;
    protected static final Reader ILLEGAL_STATE_READER = new Reader(){

        @Override
        public int read(char[] cbuf, int off, int len) {
            throw new IllegalStateException("TokenStream contract violation: reset()/close() call missing, reset() called multiple times, or subclass does not call super.reset(). Please see Javadocs of TokenStream class for more information about the correct consuming workflow.");
        }

        @Override
        public void close() {
        }
    };
    protected ResourceLoader loader;
    protected TokenizerFactory baseTokenizerFactory;
    protected final Map<String, String> baseArgs;
    protected String baseClass;
    protected volatile long factoryTimestamp;
    protected Field inputPendingField;
    protected Field attributesField;
    protected Field attributeImplsField;
    protected Field currentStateField;
    protected long lastCheckedTime;
    protected MonitoringTask monitoringFileTask;

    public MonitoringTokenizerFactory(Map<String, String> args) {
        super(args);
        try {
            this.inputPendingField = Tokenizer.class.getDeclaredField("inputPending");
            this.inputPendingField.setAccessible(true);
            this.attributesField = AttributeSource.class.getDeclaredField("attributes");
            this.attributesField.setAccessible(true);
            this.attributeImplsField = AttributeSource.class.getDeclaredField("attributeImpls");
            this.attributeImplsField.setAccessible(true);
            this.currentStateField = AttributeSource.class.getDeclaredField("currentState");
            this.currentStateField.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load fields.", e);
        }
        this.baseArgs = new HashMap<String, String>(args);
    }

    public void inform(final ResourceLoader loader) throws IOException {
        this.loader = loader;
        Map<String, String> monitorArgs = MonitoringUtil.createMonitorArgs(this.baseArgs);
        this.baseClass = MonitoringUtil.initBaseArgs(this.baseArgs, this.luceneMatchVersion.toString());
        this.baseTokenizerFactory = (TokenizerFactory)MonitoringUtil.createFactory(this.baseClass, this.baseArgs, loader);
        this.factoryTimestamp = System.currentTimeMillis();
        this.monitoringFileTask = MonitoringUtil.createMonitoringTask(monitorArgs, loader, new MonitoringTask.Callback(){

            @Override
            public void process() {
                MonitoringTokenizerFactory.this.baseTokenizerFactory = (TokenizerFactory)MonitoringUtil.createFactory(MonitoringTokenizerFactory.this.baseClass, MonitoringTokenizerFactory.this.baseArgs, loader);
                MonitoringTokenizerFactory.this.factoryTimestamp = System.currentTimeMillis();
            }
        });
        if (this.baseTokenizerFactory instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)this.baseTokenizerFactory).inform(loader);
        }
    }

    public Tokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
        return new TokenizerWrapper(factory, input);
    }

    public class TokenizerWrapper
    extends Tokenizer {
        protected Tokenizer tokenizer;
        protected AttributeSource.AttributeFactory factory;
        protected long tokenizerTimestamp;

        TokenizerWrapper(AttributeSource.AttributeFactory factory, Reader input) {
            super(ILLEGAL_STATE_READER);
            this.factory = factory;
            this.tokenizer = this.createTokenizer(input);
        }

        public void close() throws IOException {
            this.tokenizer.close();
        }

        public void reset() throws IOException {
            Reader inputPending = this.getInputPending();
            if (MonitoringTokenizerFactory.this.factoryTimestamp > this.tokenizerTimestamp) {
                this.tokenizer = this.createTokenizer(inputPending);
            } else if (inputPending != ILLEGAL_STATE_READER) {
                this.tokenizer.setReader(inputPending);
            }
            this.tokenizer.reset();
            MonitoringTokenizerFactory.this.monitoringFileTask.process();
        }

        public boolean incrementToken() throws IOException {
            return this.tokenizer.incrementToken();
        }

        public void end() throws IOException {
            this.tokenizer.end();
        }

        public int hashCode() {
            return this.tokenizer.hashCode();
        }

        public boolean equals(Object obj) {
            return this.tokenizer.equals(obj);
        }

        public String toString() {
            return this.tokenizer.toString();
        }

        protected Reader getInputPending() {
            try {
                return (Reader)MonitoringTokenizerFactory.this.inputPendingField.get((Object)this);
            }
            catch (Exception e) {
                return null;
            }
        }

        protected Tokenizer createTokenizer(Reader inputPending) {
            this.tokenizerTimestamp = MonitoringTokenizerFactory.this.factoryTimestamp;
            Tokenizer newTokenizer = MonitoringTokenizerFactory.this.baseTokenizerFactory.create(this.factory, inputPending);
            try {
                Object attributesObj = MonitoringTokenizerFactory.this.attributesField.get(newTokenizer);
                MonitoringTokenizerFactory.this.attributesField.set((Object)this, attributesObj);
                Object attributeImplsObj = MonitoringTokenizerFactory.this.attributeImplsField.get(newTokenizer);
                MonitoringTokenizerFactory.this.attributeImplsField.set((Object)this, attributeImplsObj);
                Object currentStateObj = MonitoringTokenizerFactory.this.currentStateField.get(newTokenizer);
                MonitoringTokenizerFactory.this.currentStateField.set((Object)this, currentStateObj);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to update the tokenizer.", e);
            }
            return newTokenizer;
        }
    }
}

