/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import jp.sf.fess.solr.plugin.suggest.SuggestUpdateConfig;
import jp.sf.fess.solr.plugin.suggest.entity.SuggestFieldInfo;
import jp.sf.fess.solr.plugin.suggest.entity.SuggestItem;
import jp.sf.fess.solr.plugin.suggest.enums.RequestType;
import jp.sf.fess.solr.plugin.suggest.index.DocumentReader;
import jp.sf.fess.solr.plugin.suggest.index.IndexUpdater;
import jp.sf.fess.solr.plugin.suggest.index.SuggestSolrServer;
import jp.sf.fess.solr.plugin.suggest.util.TransactionLogUtil;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.exception.FessSuggestException;
import jp.sf.fess.suggest.normalizer.SuggestNormalizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.update.TransactionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestUpdateController {
    private static final Logger logger = LoggerFactory.getLogger(SuggestUpdateController.class);
    protected final UpdateTask updateTask;
    protected final TransactionLogParseTask transactionLogParseTask;
    protected final IndexUpdater indexUpdater;
    protected int limitDocumentQueuingNum = 50;
    protected int limitTermQueuingNum = 50000;
    protected final BlockingQueue<Request> requestQueue = new LinkedBlockingQueue<Request>();
    protected final List<String> labelFieldNameList = Collections.synchronizedList(new ArrayList());
    protected final List<String> roleFieldNameList = Collections.synchronizedList(new ArrayList());
    protected final List<SuggestFieldInfo> suggestFieldInfoList;
    protected final SuggestUpdateConfig config;

    public SuggestUpdateController(SuggestUpdateConfig config, List<SuggestFieldInfo> fieldInfoList) {
        SuggestSolrServer suggestSolrServer = new SuggestSolrServer(config.getSolrServer());
        this.indexUpdater = new IndexUpdater(suggestSolrServer);
        this.indexUpdater.setUpdateInterval(config.getUpdateInterval());
        this.suggestFieldInfoList = fieldInfoList;
        this.config = config;
        this.updateTask = new UpdateTask();
        this.transactionLogParseTask = new TransactionLogParseTask(new TransactionLogParseListener(){

            @Override
            public void addCBK(SolrInputDocument solrInputDocument) {
                SuggestUpdateController.this.add(solrInputDocument);
            }

            @Override
            public void deleteByQueryCBK(String query) {
                SuggestUpdateController.this.deleteByQuery(query);
            }

            @Override
            public void commitCBK() {
                SuggestUpdateController.this.commit();
            }
        });
    }

    public void start() {
        this.indexUpdater.start();
        this.updateTask.start();
        this.transactionLogParseTask.start();
    }

    public void setLimitTermQueuingNum(int limitTermQueuingNum) {
        this.limitTermQueuingNum = limitTermQueuingNum;
    }

    public void setLimitDocumentQueuingNum(int limitDocumentQueuingNum) {
        this.limitDocumentQueuingNum = limitDocumentQueuingNum;
    }

    public void add(SolrInputDocument doc) {
        this.request(new Request(RequestType.ADD, doc));
    }

    public void commit() {
        this.request(new Request(RequestType.COMMIT, null));
    }

    public void deleteByQuery(String query) {
        this.request(new Request(RequestType.DELETE_BY_QUERY, query));
    }

    public void addTransactionLog(File translog) {
        this.transactionLogParseTask.addTransactionLog(translog);
    }

    public void close() {
        if (logger.isInfoEnabled()) {
            logger.info("closing suggestController");
        }
        this.updateTask.close();
        this.transactionLogParseTask.close();
        this.indexUpdater.close();
        this.requestQueue.clear();
        try {
            this.transactionLogParseTask.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.updateTask.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.indexUpdater.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void request(Request request) {
        while ((this.requestQueue.size() > this.limitDocumentQueuingNum || this.indexUpdater.getQueuingItemNum() > this.limitTermQueuingNum) && this.updateTask.isRunning()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting dequeue documents... doc:" + this.requestQueue.size() + " term:" + this.indexUpdater.getQueuingItemNum());
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        try {
            this.requestQueue.put(request);
        }
        catch (Exception e) {
            logger.warn("Failed to add " + request, (Throwable)e);
        }
    }

    public void addLabelFieldName(String labelFieldName) {
        this.labelFieldNameList.add(labelFieldName);
    }

    public void addRoleFieldName(String roleFieldName) {
        this.roleFieldNameList.add(roleFieldName);
    }

    protected static interface TransactionLogParseListener {
        public void addCBK(SolrInputDocument var1);

        public void deleteByQueryCBK(String var1);

        public void commitCBK();
    }

    protected static class TransactionLogParseTask
    extends Thread {
        protected static final Logger logger = LoggerFactory.getLogger(TransactionLogParseTask.class);
        protected AtomicBoolean isRunning = new AtomicBoolean(false);
        protected BlockingQueue<File> transactionLogQueue = new LinkedBlockingQueue<File>();
        protected final TransactionLogParseListener listener;

        public TransactionLogParseTask(TransactionLogParseListener listener) {
            this.listener = listener;
        }

        public void close() {
            this.transactionLogQueue.clear();
            this.isRunning.set(false);
            this.interrupt();
        }

        public void addTransactionLog(File translog) {
            try {
                this.transactionLogQueue.put(translog);
            }
            catch (Exception e) {
                logger.warn("Failed to add " + translog, (Throwable)e);
            }
        }

        @Override
        public void run() {
            if (logger.isInfoEnabled()) {
                logger.info("Starting TransactionLogParseTask...");
            }
            this.isRunning.set(true);
            while (this.isRunning.get()) {
                TransactionLog.LogReader tlogReader;
                TransactionLog translog;
                File file;
                try {
                    file = this.transactionLogQueue.take();
                }
                catch (InterruptedException e1) {
                    break;
                }
                if (!file.exists()) {
                    logger.warn(file.getAbsolutePath() + " doesn't exist.");
                    continue;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Loading... " + file.getAbsolutePath());
                }
                try {
                    translog = TransactionLogUtil.createSuggestTransactionLog(file, null, true);
                }
                catch (Exception e) {
                    logger.warn("Failed to create transactionLog instance. " + file.getAbsolutePath(), (Throwable)e);
                    continue;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Getting LogReader");
                }
                if ((tlogReader = translog.getReader(0L)) == null) {
                    logger.warn("Failed to get reader.");
                    continue;
                }
                while (true) {
                    Object o = null;
                    if (!this.isRunning.get()) break;
                    try {
                        o = tlogReader.next();
                    }
                    catch (Exception e) {
                        logger.warn("Failed to read transaction log. ", (Throwable)e);
                    }
                    if (o == null) break;
                    try {
                        List entry = (List)o;
                        int operationAndFlags = (Integer)entry.get(0);
                        int oper = operationAndFlags & 0xF;
                        switch (oper) {
                            case 1: {
                                SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("add " + sdoc);
                                }
                                this.listener.addCBK(sdoc);
                                break;
                            }
                            case 3: {
                                String query = (String)entry.get(2);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("deleteByQuery " + query);
                                }
                                this.listener.deleteByQueryCBK(query);
                                break;
                            }
                            case 4: {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("commit");
                                }
                                this.listener.commitCBK();
                                break;
                            }
                            default: {
                                throw new FessSuggestException("Unknown Operation! " + oper);
                            }
                        }
                    }
                    catch (FessSuggestException e) {
                        logger.warn("Unknown Operation.", (Throwable)e);
                    }
                }
                tlogReader.close();
                translog.decref();
            }
        }
    }

    protected static class Request {
        public RequestType type;
        public Object obj;

        public Request(RequestType type, Object o) {
            this.type = type;
            this.obj = o;
        }
    }

    protected class UpdateTask
    extends Thread {
        protected AtomicBoolean running = new AtomicBoolean(false);

        protected UpdateTask() {
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                Request request;
                try {
                    request = SuggestUpdateController.this.requestQueue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                switch (request.type) {
                    case ADD: {
                        int count = 0;
                        long start = System.currentTimeMillis();
                        for (SuggestFieldInfo fieldInfo : SuggestUpdateController.this.suggestFieldInfoList) {
                            List<String> fieldNameList = fieldInfo.getFieldNameList();
                            TokenizerFactory tokenizerFactory = fieldInfo.getTokenizerFactory();
                            SuggestReadingConverter converter = fieldInfo.getSuggestReadingConverter();
                            SuggestNormalizer normalizer = fieldInfo.getSuggestNormalizer();
                            SolrInputDocument doc = (SolrInputDocument)request.obj;
                            DocumentReader reader = new DocumentReader(tokenizerFactory, converter, normalizer, doc, fieldNameList, SuggestUpdateController.this.labelFieldNameList, SuggestUpdateController.this.roleFieldNameList, SuggestUpdateController.this.config.getExpiresField(), SuggestUpdateController.this.config.getSegmentField());
                            try {
                                SuggestItem item;
                                while ((item = reader.next()) != null) {
                                    while (count % 10000 == 0 && SuggestUpdateController.this.indexUpdater.getQueuingItemNum() > SuggestUpdateController.this.limitTermQueuingNum && this.isRunning()) {
                                        Thread.sleep(1000L);
                                    }
                                    SuggestUpdateController.this.indexUpdater.addSuggestItem(item);
                                    ++count;
                                }
                            }
                            catch (InterruptedException e) {
                                logger.warn("updateTask is interrupted");
                                break;
                            }
                            catch (Exception e) {
                                logger.warn("Failed to tokenize document.", (Throwable)e);
                            }
                        }
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("updateTask finish add. took:" + (System.currentTimeMillis() - start) + " count: " + count);
                        break;
                    }
                    case COMMIT: {
                        SuggestUpdateController.this.indexUpdater.commit();
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        SuggestUpdateController.this.indexUpdater.deleteByQuery(request.obj.toString());
                        break;
                    }
                }
            }
        }

        private void close() {
            this.running.set(false);
            this.interrupt();
        }

        public boolean isRunning() {
            return this.running.get();
        }
    }
}

