/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest.index;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestSolrServer {
    private static final String IDS = "ids";
    private static final String GET_PATH = "/get";
    private static final String MATCH_ALL_QUERY = "*:*";
    private static final Logger logger = LoggerFactory.getLogger(SuggestSolrServer.class);
    private SolrServer solrServer;

    protected SuggestSolrServer(String url) {
        try {
            HttpSolrServer server = new HttpSolrServer(url);
            server.setConnectionTimeout(10000);
            server.setMaxRetries(3);
            this.solrServer = server;
        }
        catch (Exception e) {
            logger.warn("Failed to create SuggestSolrServer object.", (Throwable)e);
        }
    }

    public SuggestSolrServer(SolrServer server) {
        this.solrServer = server;
    }

    public void add(SolrInputDocument doc) throws IOException, SolrServerException {
        this.solrServer.add(doc);
    }

    public void add(List<SolrInputDocument> documents) throws IOException, SolrServerException {
        this.solrServer.add(documents);
    }

    public void commit() throws IOException, SolrServerException {
        this.solrServer.commit();
    }

    public void deleteAll() throws IOException, SolrServerException {
        this.solrServer.deleteByQuery(MATCH_ALL_QUERY);
    }

    public void deleteByQuery(String query) throws IOException, SolrServerException {
        this.solrServer.deleteByQuery(query);
    }

    public SolrDocumentList select(String query) throws IOException, SolrServerException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(query);
        solrQuery.setFields(new String[]{"id", "count_i", "label_s_m", "role_s_m", "fieldname_s_m"});
        QueryResponse queryResponse = this.solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        return queryResponse.getResults();
    }

    public SolrDocumentList get(String ids) throws IOException, SolrServerException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler(GET_PATH);
        solrQuery.set(IDS, new String[]{ids});
        QueryResponse response = this.solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        return response.getResults();
    }

    public void shutdown() {
        this.solrServer.shutdown();
    }
}

