/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.ExceptionUtils;

public final class ChineseTokenizerAdapter
implements ITokenizer {
    private static final Pattern numeric = Pattern.compile("[\\-+'$]?\\d+([:\\-/,.]?\\d+)*[%$]?");
    private Tokenizer sentenceTokenizer;
    private TokenStream wordTokenFilter;
    private CharTermAttribute term = null;
    private final MutableCharArray tempCharSequence = new MutableCharArray(new char[0]);

    public ChineseTokenizerAdapter() {
        this.sentenceTokenizer = new SentenceTokenizer((Reader)new StringReader(""));
    }

    @Override
    public short nextToken() throws IOException {
        boolean hasNextToken = this.wordTokenFilter.incrementToken();
        if (hasNextToken) {
            short flags = 0;
            char[] image = this.term.buffer();
            int length = this.term.length();
            this.tempCharSequence.reset(image, 0, length);
            flags = length == 1 && image[0] == ',' ? (short)3 : (numeric.matcher(this.tempCharSequence).matches() ? (short)2 : 1);
            return flags;
        }
        return -1;
    }

    @Override
    public void setTermBuffer(MutableCharArray array) {
        array.reset(this.term.buffer(), 0, this.term.length());
    }

    @Override
    public void reset(Reader input) throws IOException {
        try {
            if (this.wordTokenFilter != null) {
                this.wordTokenFilter.end();
                this.wordTokenFilter.close();
            }
            this.sentenceTokenizer.setReader(input);
            this.wordTokenFilter = new WordTokenFilter((TokenStream)this.sentenceTokenizer);
            this.term = (CharTermAttribute)this.wordTokenFilter.addAttribute(CharTermAttribute.class);
            this.wordTokenFilter.reset();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }
}

