/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CollectionsHandler.class);
    protected final CoreContainer coreContainer;
    static Set<String> KNOWN_ROLES = ImmutableSet.of((Object)"overseer");
    public static long DEFAULT_ZK_TIMEOUT = 180000L;

    public CollectionsHandler() {
        this.coreContainer = null;
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        CollectionParams.CollectionAction action = null;
        String a = params.get("action");
        if (a != null) {
            action = CollectionParams.CollectionAction.get((String)a);
        }
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
        }
        switch (action) {
            case CREATE: {
                this.handleCreateAction(req, rsp);
                break;
            }
            case DELETE: {
                this.handleDeleteAction(req, rsp);
                break;
            }
            case RELOAD: {
                this.handleReloadAction(req, rsp);
                break;
            }
            case SYNCSHARD: {
                this.handleSyncShardAction(req, rsp);
                break;
            }
            case CREATEALIAS: {
                this.handleCreateAliasAction(req, rsp);
                break;
            }
            case DELETEALIAS: {
                this.handleDeleteAliasAction(req, rsp);
                break;
            }
            case SPLITSHARD: {
                this.handleSplitShardAction(req, rsp);
                break;
            }
            case DELETESHARD: {
                this.handleDeleteShardAction(req, rsp);
                break;
            }
            case CREATESHARD: {
                this.handleCreateShard(req, rsp);
                break;
            }
            case DELETEREPLICA: {
                this.handleRemoveReplica(req, rsp);
                break;
            }
            case MIGRATE: {
                this.handleMigrate(req, rsp);
                break;
            }
            case ADDROLE: {
                this.handleRole(CollectionParams.CollectionAction.ADDROLE, req, rsp);
                break;
            }
            case REMOVEROLE: {
                this.handleRole(CollectionParams.CollectionAction.REMOVEROLE, req, rsp);
                break;
            }
            case CLUSTERPROP: {
                this.handleProp(req, rsp);
                break;
            }
            case ADDREPLICA: {
                this.handleAddReplica(req, rsp);
                break;
            }
            case REQUESTSTATUS: {
                this.handleRequestStatus(req, rsp);
                break;
            }
            case OVERSEERSTATUS: {
                this.handleOverseerStatus(req, rsp);
                break;
            }
            case LIST: {
                this.handleListAction(req, rsp);
                break;
            }
            case CLUSTERSTATUS: {
                this.handleClusterStatus(req, rsp);
                break;
            }
            default: {
                throw new RuntimeException("Unknown action: " + action);
            }
        }
        rsp.setHttpCaching(false);
    }

    private void handleOverseerStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        Map props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", CollectionParams.CollectionAction.OVERSEERSTATUS.toLower()});
        this.handleResponse(CollectionParams.CollectionAction.OVERSEERSTATUS.toLower(), new ZkNodeProps(props), rsp);
    }

    private void handleProp(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        req.getParams().required().check(new String[]{"name"});
        String name = req.getParams().get("name");
        if (!OverseerCollectionProcessor.KNOWN_CLUSTER_PROPS.contains(name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not a known cluster property " + name);
        }
        Map props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", CollectionParams.CollectionAction.CLUSTERPROP.toLower()});
        CollectionsHandler.copyIfNotNull(req.getParams(), props, "name", "val");
        Overseer.getInQueue(this.coreContainer.getZkController().getZkClient()).offer(ZkStateReader.toJSON((Object)props));
    }

    private void handleRole(CollectionParams.CollectionAction action, SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        req.getParams().required().check(new String[]{"role", "node"});
        Map map = ZkNodeProps.makeMap((Object[])new Object[]{"operation", action.toLower()});
        CollectionsHandler.copyIfNotNull(req.getParams(), map, "role", "node");
        ZkNodeProps m = new ZkNodeProps(map);
        if (!KNOWN_ROLES.contains(m.getStr("role"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
        }
        this.handleResponse(action.toString().toLowerCase(Locale.ROOT), m, rsp);
    }

    private void handleRequestStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.debug("REQUESTSTATUS action invoked: " + req.getParamString());
        req.getParams().required().check(new String[]{"requestid"});
        String requestId = req.getParams().get("requestid");
        if (requestId.equals("-1")) {
            if (requestId.equals("-1")) {
                this.coreContainer.getZkController().getOverseerCompletedMap().clear();
                this.coreContainer.getZkController().getOverseerFailureMap().clear();
                return;
            }
        } else {
            SimpleOrderedMap success;
            NamedList results = new NamedList();
            if (this.coreContainer.getZkController().getOverseerCompletedMap().contains(requestId)) {
                success = new SimpleOrderedMap();
                success.add("state", (Object)"completed");
                success.add("msg", (Object)("found " + requestId + " in completed tasks"));
                results.add("status", (Object)success);
            } else if (this.coreContainer.getZkController().getOverseerRunningMap().contains(requestId)) {
                success = new SimpleOrderedMap();
                success.add("state", (Object)"running");
                success.add("msg", (Object)("found " + requestId + " in submitted tasks"));
                results.add("status", (Object)success);
            } else if (this.coreContainer.getZkController().getOverseerFailureMap().contains(requestId)) {
                success = new SimpleOrderedMap();
                success.add("state", (Object)"failed");
                success.add("msg", (Object)("found " + requestId + " in failed tasks"));
                results.add("status", (Object)success);
            } else {
                SimpleOrderedMap failure = new SimpleOrderedMap();
                failure.add("state", (Object)"notfound");
                failure.add("msg", (Object)("Did not find taskid [" + requestId + "] in any tasks queue"));
                results.add("status", (Object)failure);
            }
            OverseerSolrResponse response = new OverseerSolrResponse(results);
            rsp.getValues().addAll(response.getResponse());
        }
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        this.handleResponse(operation, m, rsp, DEFAULT_ZK_TIMEOUT);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        if (m.containsKey("async") && m.get("async") != null) {
            String asyncId = m.getStr("async");
            if (asyncId.equals("-1")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "requestid can not be -1. It is reserved for cleanup purposes.");
            }
            NamedList r = new NamedList();
            if (this.coreContainer.getZkController().getOverseerCompletedMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerFailureMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerRunningMap().contains(asyncId)) {
                r.add("error", (Object)"Task with the same requestid already exists.");
            } else {
                this.coreContainer.getZkController().getOverseerCollectionQueue().offer(ZkStateReader.toJSON((Object)m));
            }
            r.add("requestid", (Object)((String)m.get("async")));
            OverseerSolrResponse response = new OverseerSolrResponse(r);
            rsp.getValues().addAll(response.getResponse());
            return;
        }
        DistributedQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerCollectionQueue().offer(ZkStateReader.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unkown case");
        }
    }

    private void handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Reloading Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "reloadcollection", "name", name});
        this.handleResponse("reloadcollection", m, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException, SolrServerException, IOException {
        log.info("Syncing shard : " + req.getParamString());
        String collection = req.getParams().required().get("collection");
        String shard = req.getParams().required().get("shard");
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        Replica leaderProps = clusterState.getLeader(collection, shard);
        ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
        HttpSolrServer server = new HttpSolrServer(nodeProps.getBaseUrl());
        try {
            server.setConnectionTimeout(15000);
            server.setSoTimeout(60000);
            CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
            reqSyncShard.setCollection(collection);
            reqSyncShard.setShard(shard);
            reqSyncShard.setCoreName(nodeProps.getCoreName());
            server.request((SolrRequest)reqSyncShard);
        }
        finally {
            server.shutdown();
        }
    }

    private void handleCreateAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        log.info("Create alias action : " + req.getParamString());
        String name = req.getParams().required().get("name");
        String collections = req.getParams().required().get("collections");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "createalias", "name", name, "collections", collections});
        this.handleResponse("createalias", m, rsp);
    }

    private void handleDeleteAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        log.info("Delete alias action : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletealias", "name", name});
        this.handleResponse("deletealias", m, rsp);
    }

    private void handleDeleteAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Deleting Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletecollection", "name", name});
        this.handleResponse("deletecollection", m, rsp);
    }

    private void handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException {
        log.info("Creating Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        if (name == null) {
            log.error("Collection name is required to create a new collection");
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection name is required to create a new collection");
        }
        Map props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", "createcollection", "fromApi", "true"});
        CollectionsHandler.copyIfNotNull(req.getParams(), props, "name", "replicationFactor", "collection.configName", "numShards", "maxShardsPerNode", "createNodeSet", "shards", "async", "router.");
        this.copyPropertiesIfNotNull(req.getParams(), props);
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("createcollection", m, rsp);
    }

    private void handleRemoveReplica(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Remove replica: " + req.getParamString());
        req.getParams().required().check(new String[]{"collection", "shard", "replica"});
        Map map = ZkNodeProps.makeMap((Object[])new Object[]{"operation", "deletereplica"});
        CollectionsHandler.copyIfNotNull(req.getParams(), map, "collection", "shard", "replica", "async");
        ZkNodeProps m = new ZkNodeProps(map);
        this.handleResponse("deletereplica", m, rsp);
    }

    private void handleCreateShard(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Create shard: " + req.getParamString());
        req.getParams().required().check(new String[]{"collection", "shard"});
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        if (!"implicit".equals(((Map)clusterState.getCollection(req.getParams().get("collection")).get("router")).get("name"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
        }
        Map map = ZkNodeProps.makeMap((Object[])new Object[]{"operation", "createshard"});
        CollectionsHandler.copyIfNotNull(req.getParams(), map, "collection", "shard", "replicationFactor", "createNodeSet", "async");
        this.copyPropertiesIfNotNull(req.getParams(), map);
        ZkNodeProps m = new ZkNodeProps(map);
        this.handleResponse("createshard", m, rsp);
    }

    private static void copyIfNotNull(SolrParams params, Map<String, Object> props, String ... keys) {
        ArrayList<String> prefixes = new ArrayList<String>(1);
        if (keys != null) {
            for (String key : keys) {
                if (key.endsWith(".")) {
                    prefixes.add(key);
                    continue;
                }
                String v = params.get(key);
                if (v == null) continue;
                props.put(key, v);
            }
        }
        if (prefixes.isEmpty()) {
            return;
        }
        Iterator it = params.getParameterNamesIterator();
        Object prefix = null;
        while (it.hasNext()) {
            String name = (String)it.next();
            for (int i = 0; i < prefixes.size(); ++i) {
                String val;
                if (!name.startsWith((String)prefixes.get(i)) || (val = params.get(name)) == null) continue;
                props.put(name, val);
            }
        }
    }

    private void copyPropertiesIfNotNull(SolrParams params, Map<String, Object> props) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith("property.")) continue;
            props.put(param, params.get(param));
        }
    }

    private void handleDeleteShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException {
        log.info("Deleting Shard : " + req.getParamString());
        String name = req.getParams().required().get("collection");
        String shard = req.getParams().required().get("shard");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("collection", name);
        props.put("operation", "deleteshard");
        props.put("shard", shard);
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("deleteshard", m, rsp);
    }

    private void handleSplitShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Splitting shard : " + req.getParamString());
        String name = req.getParams().required().get("collection");
        String shard = req.getParams().get("shard");
        String rangesStr = req.getParams().get("ranges");
        String splitKey = req.getParams().get("split.key");
        if (splitKey == null && shard == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: shard");
        }
        if (splitKey != null && shard != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
        }
        if (splitKey != null && rangesStr != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", "splitshard");
        props.put("collection", name);
        if (shard != null) {
            props.put("shard", shard);
        }
        if (splitKey != null) {
            props.put("split.key", splitKey);
        }
        if (rangesStr != null) {
            props.put("ranges", rangesStr);
        }
        if (req.getParams().get("async") != null) {
            props.put("async", req.getParams().get("async"));
        }
        this.copyPropertiesIfNotNull(req.getParams(), props);
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("splitshard", m, rsp, DEFAULT_ZK_TIMEOUT * 5L);
    }

    private void handleMigrate(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Migrate action invoked: " + req.getParamString());
        req.getParams().required().check(new String[]{"collection", "split.key", "target.collection"});
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", "migrate");
        CollectionsHandler.copyIfNotNull(req.getParams(), props, "collection", "split.key", "target.collection", "forward.timeout", "async");
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("migrate", m, rsp, DEFAULT_ZK_TIMEOUT * 20L);
    }

    private void handleAddReplica(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Add replica action invoked: " + req.getParamString());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toString());
        CollectionsHandler.copyIfNotNull(req.getParams(), props, "collection", "node", "shard", "_route_", "name", "instanceDir", "dataDir");
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse(CollectionParams.CollectionAction.ADDREPLICA.toString(), m, rsp);
    }

    private void handleClusterStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", CollectionParams.CollectionAction.CLUSTERSTATUS.toLower());
        CollectionsHandler.copyIfNotNull(req.getParams(), props, "collection", "shard", "_route_");
        this.handleResponse(CollectionParams.CollectionAction.CLUSTERSTATUS.toString(), new ZkNodeProps(props), rsp);
    }

    private void handleListAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        Map props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", CollectionParams.CollectionAction.LIST.toString().toLowerCase(Locale.ROOT)});
        this.handleResponse(CollectionParams.CollectionAction.LIST.toString(), new ZkNodeProps(props), rsp);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/trunk/solr/core/src/java/org/apache/solr/handler/admin/CollectionHandler.java $";
    }
}

