/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.util.SolrPluginUtils;

public class DebugComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "debug";
    private static final AtomicLong ridCounter = new AtomicLong();
    private static final Map<Integer, String> stages;
    private static final Set<String> EXCLUDE_SET;

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.isDebugTrack() && rb.isDistrib) {
            this.doDebugTrack(rb);
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.isDebug()) {
            DocList results = null;
            if (rb.getResults() != null) {
                results = rb.getResults().docList;
            }
            NamedList stdinfo = SolrPluginUtils.doStandardDebug(rb.req, rb.getQueryString(), rb.getQuery(), results, rb.isDebugQuery(), rb.isDebugResults());
            NamedList info = rb.getDebugInfo();
            if (info == null) {
                rb.setDebugInfo((NamedList<Object>)stdinfo);
                info = stdinfo;
            } else {
                info.addAll(stdinfo);
            }
            if (rb.isDebugQuery() && rb.getQparser() != null) {
                rb.getQparser().addDebugInfo(rb.getDebugInfo());
            }
            if (null != rb.getDebugInfo()) {
                if (rb.isDebugQuery() && null != rb.getFilters()) {
                    info.add("filter_queries", (Object)rb.req.getParams().getParams("fq"));
                    ArrayList<String> fqs = new ArrayList<String>(rb.getFilters().size());
                    for (Query fq : rb.getFilters()) {
                        fqs.add(QueryParsing.toString(fq, rb.req.getSchema()));
                    }
                    info.add("parsed_filter_queries", fqs);
                }
                rb.rsp.add(COMPONENT_NAME, rb.getDebugInfo());
            }
        }
    }

    private void doDebugTrack(ResponseBuilder rb) {
        SolrQueryRequest req = rb.req;
        String rid = req.getParams().get("rid");
        if (rid == null || "".equals(rid)) {
            rid = this.generateRid(rb);
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.add("rid", new String[]{rid});
            req.setParams((SolrParams)params);
        }
        rb.addDebug(rid, "track", "rid");
        rb.rsp.addToLog("rid", rid);
    }

    private String generateRid(ResponseBuilder rb) {
        String hostName = rb.req.getCore().getCoreDescriptor().getCoreContainer().getHostName();
        return hostName + "-" + rb.req.getCore().getName() + "-" + System.currentTimeMillis() + "-" + ridCounter.getAndIncrement();
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.isDebug()) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            sreq.purpose |= 0x100;
            if (rb.isDebugAll()) {
                sreq.params.set("debugQuery", new String[]{"true"});
            } else {
                if (rb.isDebugQuery()) {
                    sreq.params.add(COMPONENT_NAME, new String[]{"query"});
                }
                if (rb.isDebugResults()) {
                    sreq.params.add(COMPONENT_NAME, new String[]{"results"});
                }
            }
        } else {
            sreq.params.set("debugQuery", new String[]{"false"});
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
        if (rb.isDebugTimings()) {
            sreq.params.add(COMPONENT_NAME, new String[]{"timing"});
        }
        if (rb.isDebugTrack()) {
            sreq.params.add(COMPONENT_NAME, new String[]{"track"});
            sreq.params.set("rid", new String[]{rb.req.getParams().get("rid")});
            sreq.params.set("requestPurpose", new String[]{SolrPluginUtils.getRequestPurpose(sreq.purpose)});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (rb.isDebugTrack() && rb.isDistrib && !rb.finished.isEmpty()) {
            NamedList stageList = (NamedList)((NamedList)rb.getDebugInfo().get("track")).get(stages.get(rb.stage));
            if (stageList == null) {
                stageList = new NamedList();
                rb.addDebug(stageList, "track", stages.get(rb.stage));
            }
            for (ShardResponse response : sreq.responses) {
                stageList.add(response.getShard(), this.getTrackResponse(response));
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.isDebug() && rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            SimpleOrderedMap info = rb.getDebugInfo();
            SimpleOrderedMap explain = new SimpleOrderedMap();
            NamedList.NamedListEntry[] arr = new NamedList.NamedListEntry[rb.resultIds.size()];
            boolean hasGetDebugResponses = false;
            for (ShardRequest sreq : rb.finished) {
                for (ShardResponse srsp : sreq.responses) {
                    NamedList sdebug = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                    info = (NamedList)this.merge(sdebug, info, EXCLUDE_SET);
                    if ((sreq.purpose & 0x100) == 0) continue;
                    hasGetDebugResponses = true;
                    if (!rb.isDebugResults()) continue;
                    NamedList sexplain = (NamedList)sdebug.get("explain");
                    for (int i = 0; i < sexplain.size(); ++i) {
                        String id = sexplain.getName(i);
                        ShardDoc sdoc = rb.resultIds.get(id);
                        int idx = sdoc.positionInResponse;
                        arr[idx] = new NamedList.NamedListEntry(id, sexplain.getVal(i));
                    }
                }
            }
            if (rb.isDebugResults()) {
                explain = SolrPluginUtils.removeNulls((NamedList)new SimpleOrderedMap((Map.Entry[])arr));
            }
            if (!hasGetDebugResponses) {
                if (info == null) {
                    info = new SimpleOrderedMap();
                }
                SolrPluginUtils.doStandardQueryDebug(rb.req, rb.getQueryString(), rb.getQuery(), rb.isDebugQuery(), (NamedList)info);
                if (rb.isDebugQuery() && rb.getQparser() != null) {
                    rb.getQparser().addDebugInfo((NamedList<Object>)info);
                }
            }
            if (rb.isDebugResults()) {
                int idx = info.indexOf("explain", 0);
                if (idx >= 0) {
                    info.setVal(idx, (Object)explain);
                } else {
                    info.add("explain", (Object)explain);
                }
            }
            rb.setDebugInfo((NamedList<Object>)info);
            rb.rsp.add(COMPONENT_NAME, rb.getDebugInfo());
        }
    }

    private NamedList<String> getTrackResponse(ShardResponse shardResponse) {
        NamedList namedList = new NamedList();
        NamedList responseNL = shardResponse.getSolrResponse().getResponse();
        NamedList responseHeader = (NamedList)responseNL.get("responseHeader");
        if (responseHeader != null) {
            namedList.add("QTime", (Object)responseHeader.get("QTime").toString());
        }
        namedList.add("ElapsedTime", (Object)String.valueOf(shardResponse.getSolrResponse().getElapsedTime()));
        namedList.add("RequestPurpose", (Object)shardResponse.getShardRequest().params.get("requestPurpose"));
        SolrDocumentList docList = (SolrDocumentList)shardResponse.getSolrResponse().getResponse().get("response");
        if (docList != null) {
            namedList.add("NumFound", (Object)String.valueOf(docList.getNumFound()));
        }
        namedList.add("Response", (Object)String.valueOf(responseNL));
        return namedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object merge(Object source, Object dest, Set<String> exclude) {
        if (source == null) {
            return dest;
        }
        if (dest == null) {
            if (!(source instanceof NamedList)) return source;
            dest = source instanceof SimpleOrderedMap ? new SimpleOrderedMap() : new NamedList();
        } else {
            if (dest instanceof Collection) {
                if (source instanceof Collection) {
                    ((Collection)dest).addAll((Collection)source);
                    return dest;
                } else {
                    ((Collection)dest).add(source);
                }
                return dest;
            }
            if (source instanceof Number) {
                if (dest instanceof Number) {
                    if (!(source instanceof Double) && !(dest instanceof Double)) return ((Number)source).longValue() + ((Number)dest).longValue();
                    return ((Number)source).doubleValue() + ((Number)dest).doubleValue();
                }
            } else if (source instanceof String && source.equals(dest)) {
                return dest;
            }
        }
        if (source instanceof NamedList && dest instanceof NamedList) {
            NamedList tmp = new NamedList();
            NamedList sl = (NamedList)source;
            NamedList dl = (NamedList)dest;
            for (int i = 0; i < sl.size(); ++i) {
                String dkey;
                String skey = sl.getName(i);
                if (exclude != null && exclude.contains(skey)) continue;
                Object sval = sl.getVal(i);
                int didx = -1;
                if (i < dl.size() && (skey == (dkey = dl.getName(i)) || skey != null && skey.equals(dkey))) {
                    didx = i;
                }
                if (didx == -1) {
                    didx = dl.indexOf(skey, 0);
                }
                if (didx == -1) {
                    tmp.add(skey, this.merge(sval, null, null));
                    continue;
                }
                dl.setVal(didx, this.merge(sval, dl.getVal(didx), null));
            }
            dl.addAll(tmp);
            return dl;
        }
        ArrayList<Object> t = new ArrayList<Object>();
        t.add(dest);
        t.add(source);
        return t;
    }

    @Override
    public String getDescription() {
        return "Debug Information";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_8/solr/core/src/java/org/apache/solr/handler/component/DebugComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    static {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(ResponseBuilder.STAGE_START, "START");
        map.put(ResponseBuilder.STAGE_PARSE_QUERY, "PARSE_QUERY");
        map.put(ResponseBuilder.STAGE_TOP_GROUPS, "TOP_GROUPS");
        map.put(ResponseBuilder.STAGE_EXECUTE_QUERY, "EXECUTE_QUERY");
        map.put(ResponseBuilder.STAGE_GET_FIELDS, "GET_FIELDS");
        map.put(ResponseBuilder.STAGE_DONE, "DONE");
        stages = Collections.unmodifiableMap(map);
        EXCLUDE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("explain")));
    }
}

