/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.CollapsingQParserPlugin;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;

public class ExpandComponent
extends SearchComponent
implements PluginInfoInitialized,
SolrCoreAware {
    public static final String COMPONENT_NAME = "expand";
    private PluginInfo info = PluginInfo.EMPTY_INFO;

    @Override
    public void init(PluginInfo info) {
        this.info = info;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.doExpand = true;
        }
    }

    @Override
    public void inform(SolrCore core) {
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        List<Query> filters;
        if (!rb.doExpand) {
            return;
        }
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        boolean isShard = params.getBool("isShard", false);
        String ids = params.get("ids");
        if (ids == null && isShard) {
            return;
        }
        String field = params.get("expand.field");
        if (field == null && (filters = rb.getFilters()) != null) {
            for (Query q : filters) {
                if (!(q instanceof CollapsingQParserPlugin.CollapsingPostFilter)) continue;
                CollapsingQParserPlugin.CollapsingPostFilter cp = (CollapsingQParserPlugin.CollapsingPostFilter)q;
                field = cp.getField();
            }
        }
        if (field == null) {
            throw new IOException("Expand field is null.");
        }
        String sortParam = params.get("expand.sort");
        String[] fqs = params.getParams("expand.fq");
        String qs = params.get("expand.q");
        int limit = params.getInt("expand.rows", 5);
        Sort sort = null;
        if (sortParam != null) {
            sort = QueryParsing.parseSortSpec(sortParam, rb.req).getSort();
        }
        Query query = null;
        if (qs == null) {
            query = rb.getQuery();
        } else {
            try {
                QParser parser = QParser.getParser(qs, null, req);
                query = parser.getQuery();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        ArrayList<Query> newFilters = new ArrayList<Query>();
        if (fqs == null) {
            List<Query> filters2 = rb.getFilters();
            if (filters2 != null) {
                for (Query q : filters2) {
                    if (q instanceof CollapsingQParserPlugin.CollapsingPostFilter) continue;
                    newFilters.add(q);
                }
            }
        } else {
            try {
                for (String fq : fqs) {
                    if (fq == null || fq.trim().length() == 0 || fq.equals("*:*")) continue;
                    QParser fqp = QParser.getParser(fq, null, req);
                    newFilters.add(fqp.getQuery());
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        SolrIndexSearcher searcher = req.getSearcher();
        AtomicReader reader = searcher.getAtomicReader();
        SortedDocValues values = FieldCache.DEFAULT.getTermsIndex(reader, field);
        FixedBitSet groupBits = new FixedBitSet(values.getValueCount());
        DocList docList = rb.getResults().docList;
        IntOpenHashSet collapsedSet = new IntOpenHashSet(docList.size() * 2);
        DocIterator idit = docList.iterator();
        while (idit.hasNext()) {
            int doc = idit.nextDoc();
            int ord = values.getOrd(doc);
            if (ord <= -1) continue;
            groupBits.set(ord);
            collapsedSet.add(doc);
        }
        Collector collector = null;
        GroupExpandCollector groupExpandCollector = new GroupExpandCollector(values, groupBits, collapsedSet, limit, sort);
        SolrIndexSearcher.ProcessedFilter pfilter = searcher.getProcessedFilter(null, newFilters);
        if (pfilter.postFilter != null) {
            pfilter.postFilter.setLastDelegate(groupExpandCollector);
            collector = pfilter.postFilter;
        } else {
            collector = groupExpandCollector;
        }
        searcher.search(query, pfilter.filter, collector);
        IntObjectOpenHashMap groups = groupExpandCollector.getGroups();
        Iterator it = groups.iterator();
        HashMap<String, DocSlice> outMap = new HashMap<String, DocSlice>();
        BytesRef bytesRef = new BytesRef();
        CharsRef charsRef = new CharsRef();
        FieldType fieldType = searcher.getSchema().getField(field).getType();
        while (it.hasNext()) {
            IntObjectCursor cursor = (IntObjectCursor)it.next();
            int ord = cursor.key;
            TopDocsCollector topDocsCollector = (TopDocsCollector)cursor.value;
            TopDocs topDocs = topDocsCollector.topDocs();
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (scoreDocs.length <= 0) continue;
            int[] docs = new int[scoreDocs.length];
            float[] scores = new float[scoreDocs.length];
            for (int i = 0; i < docs.length; ++i) {
                ScoreDoc scoreDoc = scoreDocs[i];
                docs[i] = scoreDoc.doc;
                scores[i] = scoreDoc.score;
            }
            DocSlice slice = new DocSlice(0, docs.length, docs, scores, topDocs.totalHits, topDocs.getMaxScore());
            values.lookupOrd(ord, bytesRef);
            fieldType.indexedToReadable(bytesRef, charsRef);
            String group = charsRef.toString();
            outMap.put(group, slice);
        }
        rb.rsp.add("expanded", outMap);
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doExpand) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            SolrQueryRequest req = rb.req;
            HashMap<String, SolrDocumentList> expanded = (HashMap<String, SolrDocumentList>)req.getContext().get("expanded");
            if (expanded == null) {
                expanded = new HashMap<String, SolrDocumentList>();
                req.getContext().put("expanded", expanded);
            }
            for (ShardResponse srsp : sreq.responses) {
                NamedList response = srsp.getSolrResponse().getResponse();
                Map ex = (Map)response.get("expanded");
                for (Map.Entry entry : ex.entrySet()) {
                    String name = (String)entry.getKey();
                    SolrDocumentList val = (SolrDocumentList)entry.getValue();
                    expanded.put(name, val);
                }
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doExpand) {
            return;
        }
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        HashMap expanded = (HashMap)rb.req.getContext().get("expanded");
        if (expanded == null) {
            expanded = new HashMap();
        }
        rb.rsp.add("expanded", expanded);
    }

    @Override
    public String getDescription() {
        return "Expand Component";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/trunk/solr/core/src/java/org/apache/solr/handler/component/ExpandComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/ExpandComponent")};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private class GroupExpandCollector
    extends Collector {
        private SortedDocValues docValues;
        private IntObjectOpenHashMap groups;
        private int docBase;
        private FixedBitSet groupBits;
        private IntOpenHashSet collapsedSet;
        private List<Collector> collectors;

        public GroupExpandCollector(SortedDocValues docValues, FixedBitSet groupBits, IntOpenHashSet collapsedSet, int limit, Sort sort) throws IOException {
            int numGroups = collapsedSet.size();
            this.groups = new IntObjectOpenHashMap(numGroups * 2);
            this.collectors = new ArrayList<Collector>();
            DocIdSetIterator iterator = groupBits.iterator();
            int group = -1;
            while ((group = iterator.nextDoc()) != Integer.MAX_VALUE) {
                TopScoreDocCollector collector = sort == null ? TopScoreDocCollector.create((int)limit, (boolean)true) : TopFieldCollector.create((Sort)sort, (int)limit, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                this.groups.put(group, (Object)collector);
                this.collectors.add((Collector)collector);
            }
            this.collapsedSet = collapsedSet;
            this.groupBits = groupBits;
            this.docValues = docValues;
        }

        public IntObjectOpenHashMap getGroups() {
            return this.groups;
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void collect(int docId) throws IOException {
            int doc = docId + this.docBase;
            int ord = this.docValues.getOrd(doc);
            if (ord > -1 && this.groupBits.get(ord) && !this.collapsedSet.contains(doc)) {
                Collector c = (Collector)this.groups.get(ord);
                c.collect(docId);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.docBase = context.docBase;
            for (Collector c : this.collectors) {
                c.setNextReader(context);
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            for (Collector c : this.collectors) {
                c.setScorer(scorer);
            }
        }
    }
}

