/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema.analysis;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceStorage;
import org.apache.solr.rest.schema.analysis.BaseManagedTokenFilterFactory;
import org.apache.solr.rest.schema.analysis.FSTSynonymFilterFactory;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedSynonymFilterFactory
extends BaseManagedTokenFilterFactory {
    public static final Logger log = LoggerFactory.getLogger(ManagedSynonymFilterFactory.class);
    public static final String SYNONYM_MAPPINGS = "synonymMappings";
    public static final String IGNORE_CASE_INIT_ARG = "ignoreCase";
    protected FSTSynonymFilterFactory delegate;

    public ManagedSynonymFilterFactory(Map<String, String> args) {
        super(args);
    }

    @Override
    public String getResourceId() {
        return "/schema/analysis/synonyms/" + this.handle;
    }

    @Override
    protected Class<? extends ManagedResource> getManagedResourceImplClass() {
        return SynonymManager.class;
    }

    @Override
    public void onManagedResourceInitialized(NamedList<?> initArgs, final ManagedResource res) throws SolrException {
        NamedList<?> args = initArgs;
        args.add("synonyms", (Object)this.getResourceId());
        args.add("expand", (Object)"false");
        args.add("format", (Object)"solr");
        HashMap filtArgs = new HashMap();
        for (Map.Entry entry : args) {
            filtArgs.put(entry.getKey(), entry.getValue().toString());
        }
        this.delegate = new FSTSynonymFilterFactory(filtArgs){

            @Override
            protected SynonymMap loadSynonyms(ResourceLoader loader, String cname, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
                ManagedSynonymParser parser = new ManagedSynonymParser((SynonymManager)res, dedup, analyzer);
                parser.parse(null);
                return parser.build();
            }
        };
        try {
            this.delegate.inform(res.getResourceLoader());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public TokenStream create(TokenStream input) {
        if (this.delegate == null) {
            throw new IllegalStateException(this.getClass().getName() + " not initialized correctly! The SynonymFilterFactory delegate was not initialized.");
        }
        return this.delegate.create(input);
    }

    private class ManagedSynonymParser
    extends SynonymMap.Parser {
        SynonymManager synonymManager;

        public ManagedSynonymParser(SynonymManager synonymManager, boolean dedup, Analyzer analyzer) {
            super(dedup, analyzer);
            this.synonymManager = synonymManager;
        }

        public void parse(Reader in) throws IOException, ParseException {
            for (String term : this.synonymManager.synonymMappings.keySet()) {
                for (String mapping : this.synonymManager.synonymMappings.get(term)) {
                    this.add(new CharsRef(term), new CharsRef(mapping), false);
                }
            }
        }
    }

    public static class SynonymManager
    extends ManagedResource
    implements ManagedResource.ChildResourceSupport {
        protected Map<String, Set<String>> synonymMappings;

        public SynonymManager(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
            super(resourceId, loader, storageIO);
        }

        @Override
        protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
            NamedList<?> initArgs = managedInitArgs;
            String format = (String)initArgs.get("format");
            if (format != null && !"solr".equals(format)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid format " + format + "! Only 'solr' is supported.");
            }
            if (initArgs.get(ManagedSynonymFilterFactory.IGNORE_CASE_INIT_ARG) == null) {
                initArgs.add(ManagedSynonymFilterFactory.IGNORE_CASE_INIT_ARG, (Object)Boolean.FALSE);
            }
            boolean ignoreCase = this.getIgnoreCase(managedInitArgs);
            this.synonymMappings = new TreeMap<String, Set<String>>();
            if (managedData != null) {
                Map storedSyns = (Map)managedData;
                for (String key : storedSyns.keySet()) {
                    Object mapping = storedSyns.get(key);
                    if (!(mapping instanceof List)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid synonym file format! Expected a list of synonyms for " + key + " but got " + mapping.getClass().getName());
                    }
                    List vals = (List)storedSyns.get(key);
                    TreeSet<String> sortedVals = new TreeSet<String>();
                    if (ignoreCase) {
                        for (String next : vals) {
                            sortedVals.add(this.applyCaseSetting(ignoreCase, next));
                        }
                    } else {
                        sortedVals.addAll(vals);
                    }
                    this.synonymMappings.put(this.applyCaseSetting(ignoreCase, key), sortedVals);
                }
            }
            log.info("Loaded {} synonym mappings for {}", (Object)this.synonymMappings.size(), (Object)this.getResourceId());
        }

        @Override
        protected Object applyUpdatesToManagedData(Object updates) {
            if (!(updates instanceof Map)) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Unsupported data format (" + updates.getClass().getName() + "); expected a JSON object (Map)!");
            }
            boolean ignoreCase = this.getIgnoreCase();
            boolean madeChanges = false;
            Map jsonMap = (Map)updates;
            for (String term : jsonMap.keySet()) {
                term = this.applyCaseSetting(ignoreCase, term);
                Set<String> output = this.synonymMappings.get(term);
                Object val = jsonMap.get(term);
                if (val instanceof String) {
                    String strVal = this.applyCaseSetting(ignoreCase, (String)val);
                    if (output == null) {
                        output = new TreeSet<String>();
                        this.synonymMappings.put(term, output);
                    }
                    if (!output.add(strVal)) continue;
                    madeChanges = true;
                    continue;
                }
                if (val instanceof List) {
                    List vals = (List)val;
                    if (output == null) {
                        output = new TreeSet<String>();
                        this.synonymMappings.put(term, output);
                    }
                    for (String nextVal : vals) {
                        if (!output.add(this.applyCaseSetting(ignoreCase, nextVal))) continue;
                        madeChanges = true;
                    }
                    continue;
                }
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Unsupported value " + val + " for " + term + "; expected single value or a JSON array!");
            }
            return madeChanges ? this.synonymMappings : null;
        }

        @Override
        protected boolean updateInitArgs(NamedList<?> updatedArgs) {
            if (updatedArgs == null || updatedArgs.size() == 0) {
                return false;
            }
            boolean currentIgnoreCase = this.getIgnoreCase(this.managedInitArgs);
            boolean updatedIgnoreCase = this.getIgnoreCase(updatedArgs);
            if (currentIgnoreCase && !updatedIgnoreCase) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Changing a managed word set's ignoreCase arg from true to false is not permitted.");
            }
            if (!currentIgnoreCase && updatedIgnoreCase) {
                TreeMap<String, Set<String>> rebuild = new TreeMap<String, Set<String>>();
                for (String curr : this.synonymMappings.keySet()) {
                    TreeSet<String> newMappings = new TreeSet<String>();
                    for (String next : this.synonymMappings.get(curr)) {
                        newMappings.add(this.applyCaseSetting(updatedIgnoreCase, next));
                    }
                    rebuild.put(this.applyCaseSetting(updatedIgnoreCase, curr), newMappings);
                }
                this.synonymMappings = rebuild;
            }
            return super.updateInitArgs(updatedArgs);
        }

        protected String applyCaseSetting(boolean ignoreCase, String str) {
            return ignoreCase && str != null ? str.toLowerCase(Locale.ROOT) : str;
        }

        public boolean getIgnoreCase() {
            return this.getIgnoreCase(this.managedInitArgs);
        }

        public boolean getIgnoreCase(NamedList<?> initArgs) {
            Boolean ignoreCase = initArgs.getBooleanArg(ManagedSynonymFilterFactory.IGNORE_CASE_INIT_ARG);
            return null == ignoreCase ? false : ignoreCase;
        }

        @Override
        public void doGet(BaseSolrResource endpoint, String childId) {
            SolrQueryResponse response = endpoint.getSolrResponse();
            if (childId != null) {
                boolean ignoreCase = this.getIgnoreCase();
                String key = this.applyCaseSetting(ignoreCase, childId);
                Set<String> output = this.synonymMappings.get(key);
                if (output == null) {
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", key, this.getResourceId()));
                }
                response.add(key, output);
            } else {
                response.add(ManagedSynonymFilterFactory.SYNONYM_MAPPINGS, this.buildMapToStore(this.synonymMappings));
            }
        }

        @Override
        public synchronized void doDeleteChild(BaseSolrResource endpoint, String childId) {
            boolean ignoreCase = this.getIgnoreCase();
            String key = this.applyCaseSetting(ignoreCase, childId);
            Set<String> output = this.synonymMappings.get(key);
            if (output == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", key, this.getResourceId()));
            }
            this.synonymMappings.remove(key);
            this.storeManagedData(this.synonymMappings);
            log.info("Removed synonym mappings for: {}", (Object)key);
        }
    }
}

