/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.AbstractLuceneSpellChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedSpellChecker
extends AbstractLuceneSpellChecker {
    private static final Logger log = LoggerFactory.getLogger(FileBasedSpellChecker.class);
    public static final String SOURCE_FILE_CHAR_ENCODING = "characterEncoding";
    private String characterEncoding;
    public static final String WORD_FIELD_NAME = "word";

    @Override
    public String init(NamedList config, SolrCore core) {
        super.init(config, core);
        this.characterEncoding = (String)config.get(SOURCE_FILE_CHAR_ENCODING);
        return this.name;
    }

    @Override
    public void build(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        this.loadExternalFileDictionary(core, searcher);
        this.spellChecker.clearIndex();
        this.spellChecker.indexDictionary(this.dictionary, new IndexWriterConfig(core.getSolrConfig().luceneMatchVersion, null), false);
    }

    @Override
    protected IndexReader determineReader(IndexReader reader) {
        return null;
    }

    private void loadExternalFileDictionary(SolrCore core, SolrIndexSearcher searcher) {
        try {
            IndexSchema schema;
            IndexSchema indexSchema = schema = null == searcher ? core.getLatestSchema() : searcher.getSchema();
            if (this.fieldTypeName != null && schema.getFieldTypeNoEx(this.fieldTypeName) != null) {
                FieldType fieldType = schema.getFieldTypes().get(this.fieldTypeName);
                RAMDirectory ramDir = new RAMDirectory();
                LogByteSizeMergePolicy mp = new LogByteSizeMergePolicy();
                mp.setMergeFactor(300);
                IndexWriter writer = new IndexWriter((Directory)ramDir, new IndexWriterConfig(core.getSolrConfig().luceneMatchVersion, fieldType.getAnalyzer()).setMaxBufferedDocs(150).setMergePolicy((MergePolicy)mp).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                List<String> lines = core.getResourceLoader().getLines(this.sourceLocation, this.characterEncoding);
                for (String s : lines) {
                    Document d = new Document();
                    d.add((IndexableField)new TextField(WORD_FIELD_NAME, s, Field.Store.NO));
                    writer.addDocument((Iterable)d);
                }
                writer.forceMerge(1);
                writer.close();
                this.dictionary = new HighFrequencyDictionary((IndexReader)DirectoryReader.open((Directory)ramDir), WORD_FIELD_NAME, 0.0f);
            } else {
                this.dictionary = this.characterEncoding == null ? new PlainTextDictionary(core.getResourceLoader().openResource(this.sourceLocation)) : new PlainTextDictionary((Reader)new InputStreamReader(core.getResourceLoader().openResource(this.sourceLocation), this.characterEncoding));
            }
        }
        catch (IOException e) {
            log.error("Unable to load spellings", (Throwable)e);
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

