/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.fst;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.BlendedInfixSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.fst.AnalyzingInfixLookupFactory;

public class BlendedInfixLookupFactory
extends AnalyzingInfixLookupFactory {
    private static final String BLENDER_TYPE = "blenderType";
    private static final String NUM_FACTOR = "numFactor";
    private static final String DEFAULT_INDEX_PATH = "blendedInfixSuggesterIndexDir";
    private static final String FILENAME = "bifsta.bin";

    @Override
    public Lookup create(NamedList params, SolrCore core) {
        Object fieldTypeName = params.get("suggestAnalyzerFieldType");
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getLatestSchema().getFieldTypeByName(fieldTypeName.toString());
        if (ft == null) {
            throw new IllegalArgumentException("Error in configuration: " + fieldTypeName.toString() + " is not defined in the schema");
        }
        Analyzer indexAnalyzer = ft.getAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        String indexPath = params.get("indexPath") != null ? params.get("indexPath").toString() : DEFAULT_INDEX_PATH;
        int minPrefixChars = params.get("minPrefixChars") != null ? Integer.parseInt(params.get("minPrefixChars").toString()) : 4;
        BlendedInfixSuggester.BlenderType blenderType = this.getBlenderType(params.get(BLENDER_TYPE));
        int numFactor = params.get(NUM_FACTOR) != null ? Integer.parseInt(params.get(NUM_FACTOR).toString()) : BlendedInfixSuggester.DEFAULT_NUM_FACTOR;
        try {
            return new BlendedInfixSuggester(core.getSolrConfig().luceneMatchVersion, (Directory)FSDirectory.open((File)new File(indexPath)), indexAnalyzer, queryAnalyzer, minPrefixChars, blenderType, numFactor);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public String storeFileName() {
        return FILENAME;
    }

    private BlendedInfixSuggester.BlenderType getBlenderType(Object blenderTypeParam) {
        String blenderTypeStr;
        BlendedInfixSuggester.BlenderType blenderType = BlendedInfixSuggester.BlenderType.POSITION_LINEAR;
        if (blenderTypeParam != null && (blenderTypeStr = blenderTypeParam.toString()).equalsIgnoreCase("reciprocal")) {
            blenderType = BlendedInfixSuggester.BlenderType.POSITION_RECIPROCAL;
        }
        return blenderType;
    }
}

