/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Resource;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.S2RobotThread;
import org.seasar.robot.client.S2RobotClientFactory;
import org.seasar.robot.filter.UrlFilter;
import org.seasar.robot.interval.IntervalController;
import org.seasar.robot.rule.RuleManager;
import org.seasar.robot.service.DataService;
import org.seasar.robot.service.UrlQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S2Robot
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(S2Robot.class);
    @Resource
    protected UrlQueueService urlQueueService;
    @Resource
    protected DataService dataService;
    @Resource
    protected UrlFilter urlFilter;
    @Resource
    protected RuleManager ruleManager;
    @Resource
    protected S2Container container;
    @Resource
    protected IntervalController intervalController;
    @Resource
    protected S2RobotClientFactory clientFactory;
    protected S2RobotContext robotContext = new S2RobotContext();
    protected boolean background = false;
    protected boolean daemon = false;
    protected int threadPriority = 5;
    protected Thread parentThread;
    protected ThreadGroup robotThreadGroup;

    public S2Robot() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
        this.robotContext.sessionId = sdf.format(new Date());
    }

    public void addUrl(String url) {
        this.urlQueueService.add(this.robotContext.sessionId, url);
        this.urlFilter.processUrl(url);
    }

    public String getSessionId() {
        return this.robotContext.sessionId;
    }

    public void setSessionId(String sessionId) {
        if (StringUtil.isNotBlank((String)sessionId) && !sessionId.equals(this.robotContext.sessionId)) {
            this.urlQueueService.updateSessionId(this.robotContext.sessionId, sessionId);
            this.robotContext.sessionId = sessionId;
        }
    }

    public String execute() {
        this.parentThread = new Thread((Runnable)this, "Robot-" + this.robotContext.sessionId);
        this.parentThread.setDaemon(this.daemon);
        this.parentThread.start();
        if (!this.background) {
            this.awaitTermination();
        }
        return this.robotContext.sessionId;
    }

    public void awaitTermination() {
        this.awaitTermination(0L);
    }

    public void awaitTermination(long millis) {
        if (this.parentThread != null) {
            try {
                this.parentThread.join(millis);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted job at " + this.parentThread.getName());
            }
        }
    }

    public void cleanup(String sessionId) {
        this.urlQueueService.delete(sessionId);
        this.dataService.delete(sessionId);
        this.urlFilter.clear();
    }

    public void addIncludeFilter(String regexp) {
        if (StringUtil.isNotBlank((String)regexp)) {
            this.urlFilter.addInclude(regexp);
        }
    }

    public void addExcludeFilter(String regexp) {
        if (StringUtil.isNotBlank((String)regexp)) {
            this.urlFilter.addExclude(regexp);
        }
    }

    public void stop() {
        this.robotContext.running = false;
        try {
            if (this.robotThreadGroup != null) {
                this.robotThreadGroup.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UrlFilter getUrlFilter() {
        return this.urlFilter;
    }

    public void setUrlFilter(UrlFilter urlFilter) {
        this.urlFilter = urlFilter;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public IntervalController getIntervalController() {
        return this.intervalController;
    }

    public void setIntervalController(IntervalController intervalController) {
        this.intervalController = intervalController;
    }

    public S2RobotClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @Override
    public void run() {
        int i;
        this.robotContext.urlFilter = this.urlFilter;
        this.robotContext.ruleManager = this.ruleManager;
        this.robotContext.intervalController = this.intervalController;
        this.urlFilter.init(this.robotContext.sessionId);
        this.robotThreadGroup = new ThreadGroup("Robot-" + this.robotContext.sessionId);
        Thread[] threads = new Thread[this.robotContext.getNumOfThread()];
        for (i = 0; i < this.robotContext.getNumOfThread(); ++i) {
            S2RobotThread robotThread = (S2RobotThread)this.container.getComponent((Object)"robotThread");
            robotThread.robotContext = this.robotContext;
            robotThread.clientFactory = this.clientFactory;
            threads[i] = new Thread(this.robotThreadGroup, robotThread, "Robot-" + this.robotContext.sessionId + "-" + Integer.toString(i + 1));
            threads[i].setDaemon(this.daemon);
            threads[i].setPriority(this.threadPriority);
        }
        this.robotContext.running = true;
        for (i = 0; i < this.robotContext.numOfThread; ++i) {
            threads[i].start();
        }
        for (i = 0; i < this.robotContext.numOfThread; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted job at " + threads[i].getName());
            }
        }
        this.robotContext.running = false;
        this.urlQueueService.saveSession(this.robotContext.sessionId);
    }

    public S2RobotContext getRobotContext() {
        return this.robotContext;
    }

    public void setNumOfThread(int numOfThread) {
        this.robotContext.numOfThread = numOfThread;
    }

    public void setMaxThreadCheckCount(int maxThreadCheckCount) {
        this.robotContext.maxThreadCheckCount = maxThreadCheckCount;
    }

    public void setMaxDepth(int maxDepth) {
        this.robotContext.maxDepth = maxDepth;
    }

    public void setMaxAccessCount(long maxAccessCount) {
        this.robotContext.maxAccessCount = maxAccessCount;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }
}

