/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.entity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RobotsTxt {
    private static final String ALL_BOTS = "*";
    protected final Map<Pattern, Directive> directiveMap = new LinkedHashMap<Pattern, Directive>();
    private final List<String> sitemapList = new ArrayList<String>();

    public boolean allows(String path, String userAgent) {
        Directive directive = this.getMatchedDirective(userAgent);
        if (directive == null) {
            return true;
        }
        return directive.allows(path);
    }

    public int getCrawlDelay(String userAgent) {
        Directive directive = this.getMatchedDirective(userAgent);
        if (directive == null) {
            return 0;
        }
        return directive.getCrawlDelay();
    }

    public Directive getMatchedDirective(String userAgent) {
        String target = userAgent == null ? "" : userAgent;
        int maxUaLength = -1;
        Directive matchedDirective = null;
        for (Map.Entry<Pattern, Directive> entry : this.directiveMap.entrySet()) {
            if (!entry.getKey().matcher(target).find()) continue;
            Directive directive = entry.getValue();
            String ua = directive.getUserAgent();
            int uaLength = 0;
            if (!ALL_BOTS.equals(ua)) {
                uaLength = ua.length();
            }
            if (uaLength <= maxUaLength) continue;
            matchedDirective = directive;
            maxUaLength = uaLength;
        }
        return matchedDirective;
    }

    public Directive getDirective(String userAgent) {
        if (userAgent == null) {
            return null;
        }
        for (Directive directive : this.directiveMap.values()) {
            if (!userAgent.equals(directive.getUserAgent())) continue;
            return directive;
        }
        return null;
    }

    public void addDirective(Directive directive) {
        this.directiveMap.put(Pattern.compile(directive.getUserAgent().replace(ALL_BOTS, ".*"), 2), directive);
    }

    public void addSitemap(String url) {
        this.sitemapList.add(url);
    }

    public String[] getSitemaps() {
        return this.sitemapList.toArray(new String[this.sitemapList.size()]);
    }

    public String toString() {
        return "RobotsTxt [directiveMap=" + this.directiveMap + ", sitemapList=" + this.sitemapList + "]";
    }

    public static class Directive {
        private final String userAgent;
        private int crawlDelay;
        private final List<String> allowedPaths = new ArrayList<String>();
        private final List<String> disallowedPaths = new ArrayList<String>();

        public Directive(String userAgent) {
            this.userAgent = userAgent;
        }

        public void setCrawlDelay(int crawlDelay) {
            this.crawlDelay = crawlDelay;
        }

        public int getCrawlDelay() {
            return this.crawlDelay;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public boolean allows(String path) {
            for (String allowedPath : this.allowedPaths) {
                if (!path.startsWith(allowedPath)) continue;
                return true;
            }
            for (String disallowedPath : this.disallowedPaths) {
                if (!path.startsWith(disallowedPath)) continue;
                return false;
            }
            return true;
        }

        public void addAllow(String path) {
            this.allowedPaths.add(path);
        }

        public void addDisallow(String path) {
            this.disallowedPaths.add(path);
        }

        public String[] getAllows() {
            return this.allowedPaths.toArray(new String[this.allowedPaths.size()]);
        }

        public String[] getDisallows() {
            return this.disallowedPaths.toArray(new String[this.disallowedPaths.size()]);
        }
    }
}

