/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Resource;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.entity.AccessResult;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.entity.UrlQueueImpl;
import org.seasar.robot.helper.MemoryDataHelper;
import org.seasar.robot.service.UrlQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlQueueServiceImpl
implements UrlQueueService {
    private static final Logger logger = LoggerFactory.getLogger(UrlQueueServiceImpl.class);
    @Resource
    protected MemoryDataHelper dataHelper;

    @Override
    public void updateSessionId(String oldSessionId, String newSessionId) {
        Queue<UrlQueue> urlQueueList = this.dataHelper.getUrlQueueList(oldSessionId);
        this.dataHelper.addUrlQueueList(newSessionId, urlQueueList);
        this.dataHelper.removeUrlQueueList(oldSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String sessionId, String url) {
        Queue<UrlQueue> urlQueueList;
        Queue<UrlQueue> queue = urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        synchronized (queue) {
            UrlQueueImpl urlQueue = new UrlQueueImpl();
            urlQueue.setSessionId(sessionId);
            urlQueue.setMethod("GET");
            urlQueue.setUrl(url);
            urlQueue.setDepth(0);
            urlQueue.setCreateTime(new Timestamp(new Date().getTime()));
            urlQueueList.add(urlQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(UrlQueue urlQueue) {
        Queue<UrlQueue> urlQueueList;
        Queue<UrlQueue> queue = urlQueueList = this.dataHelper.getUrlQueueList(urlQueue.getSessionId());
        synchronized (queue) {
            urlQueueList.add(urlQueue);
        }
    }

    @Override
    public void delete(String sessionId) {
        this.dataHelper.removeUrlQueueList(sessionId);
    }

    @Override
    public void deleteAll() {
        this.dataHelper.clearUrlQueueList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerAll(String sessionId, List<UrlQueue> newUrlQueueList) {
        Queue<UrlQueue> urlQueueList;
        Queue<UrlQueue> queue = urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        synchronized (queue) {
            ArrayList<UrlQueueImpl> targetList = new ArrayList<UrlQueueImpl>();
            for (UrlQueue urlQueue : newUrlQueueList) {
                if (!this.isNewUrl(urlQueue, urlQueueList)) continue;
                targetList.add((UrlQueueImpl)urlQueue);
            }
            urlQueueList.addAll(targetList);
        }
    }

    protected boolean isNewUrl(UrlQueue urlQueue, Queue<UrlQueue> urlQueueList) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: " + url);
            }
            return false;
        }
        for (UrlQueue urlInQueue : urlQueueList) {
            if (!url.equals(urlInQueue.getUrl())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a queue: " + url);
            }
            return false;
        }
        AccessResult accessResult = this.dataHelper.getAccessResultMap(urlQueue.getSessionId()).get(url);
        if (accessResult != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a result: " + url);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UrlQueue poll(String sessionId) {
        Queue<UrlQueue> urlQueueList;
        Queue<UrlQueue> queue = urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        synchronized (queue) {
            return urlQueueList.poll();
        }
    }

    @Override
    public void saveSession(String sessionId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visited(UrlQueue urlQueue) {
        Queue<UrlQueue> urlQueueList;
        Queue<UrlQueue> queue = urlQueueList = this.dataHelper.getUrlQueueList(urlQueue.getSessionId());
        synchronized (queue) {
            return !this.isNewUrl(urlQueue, urlQueueList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateUrlQueues(String previousSessionId, String sessionId) {
        Queue<UrlQueue> urlQueueList = this.dataHelper.getUrlQueueList(sessionId);
        Map<String, AccessResult> arMap = this.dataHelper.getAccessResultMap(previousSessionId);
        for (Map.Entry<String, AccessResult> entry : arMap.entrySet()) {
            Queue<UrlQueue> queue = urlQueueList;
            synchronized (queue) {
                UrlQueueImpl urlQueue = new UrlQueueImpl();
                urlQueue.setSessionId(sessionId);
                urlQueue.setMethod(entry.getValue().getMethod());
                urlQueue.setUrl(entry.getValue().getUrl());
                urlQueue.setParentUrl(entry.getValue().getParentUrl());
                urlQueue.setDepth(0);
                urlQueue.setLastModified(entry.getValue().getLastModified());
                urlQueue.setCreateTime(new Timestamp(new Date().getTime()));
                urlQueueList.add(urlQueue);
            }
        }
    }
}

