/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.transformer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.CachedXPathAPI;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.Constants;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResultData;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.ResultData;
import org.seasar.robot.transformer.impl.AbstractTransformer;
import org.seasar.robot.util.ResponseDataUtil;
import org.seasar.robot.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTransformer
extends AbstractTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XmlTransformer.class);
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+", 8);
    private boolean namespaceAware;
    private boolean coalescing;
    private boolean expandEntityRef = true;
    private boolean ignoringComments;
    private boolean ignoringElementContentWhitespace;
    private boolean validating;
    private boolean includeAware;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final Map<String, String> featureMap = new HashMap<String, String>();
    protected Map<String, String> fieldRuleMap = new LinkedHashMap<String, String>();
    protected boolean trimSpace = true;
    protected String charsetName = "UTF-8";
    protected Class<?> dataClass = null;
    private final ThreadLocal<CachedXPathAPI> xpathAPI = new ThreadLocal();

    @Override
    public Object getData(AccessResultData accessResultData) {
        if (this.dataClass == null) {
            if (!this.getName().equals(accessResultData.getTransformerName())) {
                throw new RobotSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
            }
            byte[] data = accessResultData.getData();
            if (data == null) {
                return null;
            }
            String encoding = accessResultData.getEncoding();
            try {
                return new String(data, encoding == null ? "UTF-8" : encoding);
            }
            catch (UnsupportedEncodingException e) {
                if (logger.isInfoEnabled()) {
                    logger.info("Invalid charsetName: " + encoding + ". Changed to " + "UTF-8", (Throwable)e);
                }
                return new String(data, Constants.UTF_8_CHARSET);
            }
        }
        Map<String, Object> dataMap = XmlUtil.getDataMap(accessResultData);
        if (Map.class.equals(this.dataClass)) {
            return dataMap;
        }
        try {
            Object obj = this.dataClass.newInstance();
            Beans.copy(dataMap, obj).execute();
            return obj;
        }
        catch (Exception e) {
            throw new RobotSystemException("Could not create/copy a data map to " + this.dataClass, e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultData transform(ResponseData responseData) {
        ResultData resultData;
        if (responseData == null || responseData.getResponseBody() == null) {
            throw new RobotCrawlAccessException("No response body.");
        }
        File tempFile = ResponseDataUtil.createResponseBodyFile(responseData);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(tempFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (Map.Entry<String, Object> entry : this.attributeMap.entrySet()) {
                factory.setAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.featureMap.entrySet()) {
                factory.setFeature(entry.getKey(), "true".equalsIgnoreCase((String)entry.getValue()));
            }
            factory.setCoalescing(this.coalescing);
            factory.setExpandEntityReferences(this.expandEntityRef);
            factory.setIgnoringComments(this.ignoringComments);
            factory.setIgnoringElementContentWhitespace(this.ignoringElementContentWhitespace);
            factory.setNamespaceAware(this.namespaceAware);
            factory.setValidating(this.validating);
            factory.setXIncludeAware(this.includeAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fis);
            StringBuilder buf = new StringBuilder(1000);
            buf.append(this.getResultDataHeader());
            for (Map.Entry<String, String> entry : this.fieldRuleMap.entrySet()) {
                ArrayList<String> nodeStrList = new ArrayList<String>();
                try {
                    NodeList nodeList = this.getNodeList(document, entry.getValue());
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        nodeStrList.add(node.getTextContent());
                    }
                }
                catch (TransformerException e) {
                    logger.warn("Could not parse a value of " + entry.getKey() + ":" + entry.getValue(), (Throwable)e);
                }
                if (nodeStrList.size() == 1) {
                    buf.append(this.getResultDataBody(entry.getKey(), (String)nodeStrList.get(0)));
                    continue;
                }
                if (nodeStrList.size() <= 1) continue;
                buf.append(this.getResultDataBody(entry.getKey(), nodeStrList));
            }
            buf.append(this.getAdditionalData(responseData, document));
            buf.append(this.getResultDataFooter());
            ResultData resultData2 = new ResultData();
            resultData2.setTransformerName(this.getName());
            try {
                resultData2.setData(buf.toString().getBytes(this.charsetName));
            }
            catch (UnsupportedEncodingException e) {
                if (logger.isInfoEnabled()) {
                    logger.info("Invalid charsetName: " + this.charsetName + ". Changed to " + "UTF-8", (Throwable)e);
                }
                this.charsetName = Constants.UTF_8_CHARSET.name();
                resultData2.setData(buf.toString().getBytes(Constants.UTF_8_CHARSET));
            }
            resultData2.setEncoding(this.charsetName);
            resultData = resultData2;
        }
        catch (RobotSystemException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RobotSystemException("Could not store data.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                if (!tempFile.delete()) {
                    logger.warn("Could not delete a temp file: " + tempFile);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        if (!tempFile.delete()) {
            logger.warn("Could not delete a temp file: " + tempFile);
        }
        return resultData;
    }

    protected NodeList getNodeList(Document doc, String xpath) throws TransformerException {
        DefaultPrefixResolver prefixResolver = new DefaultPrefixResolver(doc.getNodeType() == 9 ? doc.getDocumentElement() : doc);
        return this.getXPathAPI().eval((Node)doc, xpath, (PrefixResolver)prefixResolver).nodelist();
    }

    protected CachedXPathAPI getXPathAPI() {
        CachedXPathAPI cachedXPathAPI = this.xpathAPI.get();
        if (cachedXPathAPI == null) {
            cachedXPathAPI = new CachedXPathAPI();
            this.xpathAPI.set(cachedXPathAPI);
        }
        return cachedXPathAPI;
    }

    protected String getResultDataHeader() {
        return "<?xml version=\"1.0\"?>\n<doc>\n";
    }

    protected String getResultDataBody(String name, String value) {
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + this.trimSpace(XmlUtil.escapeXml(value != null ? value : "")) + "</field>\n";
    }

    protected String getResultDataBody(String name, List<String> values) {
        StringBuilder buf = new StringBuilder();
        buf.append("<list>");
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                buf.append("<item>");
                buf.append(this.trimSpace(XmlUtil.escapeXml(value)));
                buf.append("</item>");
            }
        }
        buf.append("</list>");
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + buf.toString() + "</field>\n";
    }

    protected String getAdditionalData(ResponseData responseData, Document document) {
        return "";
    }

    protected String getResultDataFooter() {
        return "</doc>";
    }

    protected String trimSpace(String value) {
        if (this.trimSpace) {
            Matcher matcher = SPACE_PATTERN.matcher(value);
            return matcher.replaceAll(" ").trim();
        }
        return value;
    }

    public void addAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public void addFeature(String key, String value) {
        this.featureMap.put(key, value);
    }

    public void addFieldRule(String name, String xpath) {
        this.fieldRuleMap.put(name, xpath);
    }

    public Map<String, String> getFieldRuleMap() {
        return this.fieldRuleMap;
    }

    public void setFieldRuleMap(Map<String, String> fieldRuleMap) {
        this.fieldRuleMap = fieldRuleMap;
    }

    public boolean isTrimSpace() {
        return this.trimSpace;
    }

    public void setTrimSpace(boolean trimSpace) {
        this.trimSpace = trimSpace;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isExpandEntityRef() {
        return this.expandEntityRef;
    }

    public void setExpandEntityRef(boolean expandEntityRef) {
        this.expandEntityRef = expandEntityRef;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public void setIgnoringComments(boolean ignoringComments) {
        this.ignoringComments = ignoringComments;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringElementContentWhitespace) {
        this.ignoringElementContentWhitespace = ignoringElementContentWhitespace;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isIncludeAware() {
        return this.includeAware;
    }

    public void setIncludeAware(boolean includeAware) {
        this.includeAware = includeAware;
    }

    public static class DefaultPrefixResolver
    extends PrefixResolverDefault {
        public DefaultPrefixResolver(Node xpathExpressionContext) {
            super(xpathExpressionContext);
        }

        public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
            String namespace = super.getNamespaceForPrefix(prefix, namespaceContext);
            if (StringUtil.isNotBlank((String)namespace)) {
                return namespace;
            }
            return "http://s2robot.sandbox.seasar.org/namespace/" + prefix;
        }
    }
}

