/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.transformer.impl;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.apache.xpath.objects.XObject;
import org.cyberneko.html.parsers.DOMParser;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.Constants;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResultData;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.ResultData;
import org.seasar.robot.transformer.impl.HtmlTransformer;
import org.seasar.robot.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XpathTransformer
extends HtmlTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XpathTransformer.class);
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+", 8);
    protected Map<String, String> fieldRuleMap = new LinkedHashMap<String, String>();
    protected boolean trimSpace = true;
    protected String charsetName = "UTF-8";
    protected Class<?> dataClass = null;

    @Override
    protected void storeData(ResponseData responseData, ResultData resultData) {
        DOMParser parser = this.getDomParser();
        try {
            InputSource is = new InputSource(responseData.getResponseBody());
            if (responseData.getCharSet() != null) {
                is.setEncoding(responseData.getCharSet());
            }
            parser.parse(is);
        }
        catch (Exception e) {
            throw new RobotCrawlAccessException("Could not parse " + responseData.getUrl(), e);
        }
        Document document = parser.getDocument();
        StringBuilder buf = new StringBuilder(1000);
        buf.append(this.getResultDataHeader());
        for (Map.Entry<String, String> entry : this.fieldRuleMap.entrySet()) {
            String path = entry.getValue();
            try {
                XObject xObj = this.getXPathAPI().eval((Node)document, path);
                int type = xObj.getType();
                switch (type) {
                    case 1: {
                        boolean b = xObj.bool();
                        buf.append(this.getResultDataBody(entry.getKey(), Boolean.toString(b)));
                        break;
                    }
                    case 2: {
                        double d = xObj.num();
                        buf.append(this.getResultDataBody(entry.getKey(), Double.toString(d)));
                        break;
                    }
                    case 3: {
                        String str = xObj.str();
                        buf.append(this.getResultDataBody(entry.getKey(), str.trim()));
                        break;
                    }
                    case 4: {
                        NodeList nodeList = xObj.nodelist();
                        ArrayList<String> strList = new ArrayList<String>();
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            strList.add(node.getTextContent());
                        }
                        buf.append(this.getResultDataBody(entry.getKey(), strList));
                        break;
                    }
                    case 5: {
                        int rtf = xObj.rtf();
                        buf.append(this.getResultDataBody(entry.getKey(), Integer.toString(rtf)));
                        break;
                    }
                    default: {
                        Object obj = xObj.object();
                        if (obj == null) {
                            obj = "";
                        }
                        buf.append(this.getResultDataBody(entry.getKey(), obj.toString()));
                        break;
                    }
                }
            }
            catch (TransformerException e) {
                logger.warn("Could not parse a value of " + entry.getKey() + ":" + entry.getValue());
            }
        }
        buf.append(this.getAdditionalData(responseData, document));
        buf.append(this.getResultDataFooter());
        try {
            resultData.setData(buf.toString().getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Invalid charsetName: " + this.charsetName + ". Changed to " + "UTF-8", (Throwable)e);
            }
            this.charsetName = Constants.UTF_8_CHARSET.name();
            resultData.setData(buf.toString().getBytes(Constants.UTF_8_CHARSET));
        }
        resultData.setEncoding(this.charsetName);
    }

    protected String getResultDataHeader() {
        return "<?xml version=\"1.0\"?>\n<doc>\n";
    }

    protected String getResultDataBody(String name, String value) {
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + this.trimSpace(XmlUtil.escapeXml(value != null ? value : "")) + "</field>\n";
    }

    protected String getResultDataBody(String name, List<String> values) {
        StringBuilder buf = new StringBuilder();
        buf.append("<list>");
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                buf.append("<item>");
                buf.append(this.trimSpace(XmlUtil.escapeXml(value)));
                buf.append("</item>");
            }
        }
        buf.append("</list>");
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + buf.toString() + "</field>\n";
    }

    protected String getAdditionalData(ResponseData responseData, Document document) {
        return "";
    }

    protected String getResultDataFooter() {
        return "</doc>";
    }

    protected String trimSpace(String value) {
        if (this.trimSpace) {
            Matcher matcher = SPACE_PATTERN.matcher(value);
            return matcher.replaceAll(" ").trim();
        }
        return value;
    }

    public void addFieldRule(String name, String xpath) {
        this.fieldRuleMap.put(name, xpath);
    }

    @Override
    public Object getData(AccessResultData accessResultData) {
        if (this.dataClass == null) {
            return super.getData(accessResultData);
        }
        Map<String, Object> dataMap = XmlUtil.getDataMap(accessResultData);
        if (Map.class.equals(this.dataClass)) {
            return dataMap;
        }
        try {
            Object obj = this.dataClass.newInstance();
            Beans.copy(dataMap, obj).execute();
            return obj;
        }
        catch (Exception e) {
            throw new RobotSystemException("Could not create/copy a data map to " + this.dataClass, e);
        }
    }

    @Deprecated
    protected Map<String, Object> getDataMap(AccessResultData accessResultData) {
        InputSource is = new InputSource(new ByteArrayInputStream(accessResultData.getData()));
        if (StringUtil.isNotBlank((String)accessResultData.getEncoding())) {
            is.setEncoding(accessResultData.getEncoding());
        }
        DocHandler handler = new DocHandler();
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
            return handler.getDataMap();
        }
        catch (Exception e) {
            throw new RobotSystemException("Could not create a data map from XML content.", e);
        }
    }

    public Map<String, String> getFieldRuleMap() {
        return this.fieldRuleMap;
    }

    public void setFieldRuleMap(Map<String, String> fieldRuleMap) {
        this.fieldRuleMap = fieldRuleMap;
    }

    public boolean isTrimSpace() {
        return this.trimSpace;
    }

    public void setTrimSpace(boolean trimSpace) {
        this.trimSpace = trimSpace;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    @Deprecated
    protected String escapeXml(String value) {
        return XmlUtil.escapeXml(value);
    }

    @Deprecated
    protected static class DocHandler
    extends DefaultHandler {
        private final Map<String, Object> dataMap = new HashMap<String, Object>();
        private String fieldName;
        private boolean listData = false;
        private boolean itemData = false;

        protected DocHandler() {
        }

        @Override
        public void startDocument() {
            this.dataMap.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("field".equals(qName)) {
                this.fieldName = attributes.getValue("name");
            } else if ("list".equals(qName)) {
                this.listData = true;
                if (!this.dataMap.containsKey(this.fieldName)) {
                    this.dataMap.put(this.fieldName, new ArrayList());
                }
            } else if ("item".equals(qName)) {
                this.itemData = true;
            }
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            if (this.fieldName != null) {
                Object value = this.dataMap.get(this.fieldName);
                if (this.listData && this.itemData) {
                    if (value != null) {
                        List list = (List)value;
                        list.add(new String(ch, offset, length));
                    }
                } else if (value == null) {
                    this.dataMap.put(this.fieldName, new String(ch, offset, length));
                } else {
                    this.dataMap.put(this.fieldName, value + new String(ch, offset, length));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("field".equals(qName)) {
                this.fieldName = null;
            } else if ("list".equals(qName)) {
                this.listData = false;
            } else if ("item".equals(qName)) {
                this.itemData = false;
            }
        }

        @Override
        public void endDocument() {
        }

        public Map<String, Object> getDataMap() {
            return this.dataMap;
        }
    }
}

