/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseDataUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResponseDataUtil.class);

    private ResponseDataUtil() {
    }

    public static File createResponseBodyFile(ResponseData responseData) {
        File tempFile = null;
        InputStream is = responseData.getResponseBody();
        FileOutputStream fos = null;
        try {
            tempFile = File.createTempFile("s2robot-", ".tmp");
            fos = new FileOutputStream(tempFile);
            StreamUtil.drain(is, fos);
        }
        catch (Exception e) {
            try {
                IOUtils.closeQuietly(fos);
                if (tempFile != null && !tempFile.delete()) {
                    logger.warn("Could not delete a temp file: " + tempFile);
                }
                throw new RobotCrawlAccessException("Could not read a response body: " + responseData.getUrl(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)fos);
        return tempFile;
    }
}

