/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.util;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResultData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static String escapeXml(String value) {
        return XmlUtil.stripInvalidXMLCharacters(value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;"));
    }

    public static String stripInvalidXMLCharacters(String in) {
        if (StringUtil.isEmpty((String)in)) {
            return in;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static Map<String, Object> getDataMap(AccessResultData accessResultData) {
        InputSource is = new InputSource(new ByteArrayInputStream(accessResultData.getData()));
        if (StringUtil.isNotBlank((String)accessResultData.getEncoding())) {
            is.setEncoding(accessResultData.getEncoding());
        }
        DocHandler handler = new DocHandler();
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
            return handler.getDataMap();
        }
        catch (Exception e) {
            throw new RobotSystemException("Could not create a data map from XML content.", e);
        }
    }

    private static class DocHandler
    extends DefaultHandler {
        private final Map<String, Object> dataMap = new HashMap<String, Object>();
        private String fieldName;
        private final StringBuilder buffer = new StringBuilder(1000);

        private DocHandler() {
        }

        @Override
        public void startDocument() {
            this.dataMap.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("field".equals(qName)) {
                this.fieldName = attributes.getValue("name");
                if (StringUtil.isBlank((String)this.fieldName)) {
                    this.fieldName = null;
                }
                this.buffer.setLength(0);
            } else if ("list".equals(qName)) {
                if (this.fieldName != null && !this.dataMap.containsKey(this.fieldName)) {
                    this.dataMap.put(this.fieldName, new ArrayList());
                }
            } else if ("item".equals(qName)) {
                this.buffer.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            this.buffer.append(new String(ch, offset, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            Object obj;
            if ("field".equals(qName)) {
                if (this.fieldName != null) {
                    Object obj2 = this.dataMap.get(this.fieldName);
                    if (obj2 == null) {
                        this.dataMap.put(this.fieldName, this.buffer.toString());
                    }
                    this.fieldName = null;
                }
            } else if ("item".equals(qName) && this.fieldName != null && (obj = this.dataMap.get(this.fieldName)) instanceof List) {
                List list = (List)obj;
                list.add(this.buffer.toString());
            }
        }

        @Override
        public void endDocument() {
        }

        public Map<String, Object> getDataMap() {
            return this.dataMap;
        }
    }
}

