/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.analysis;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.fess.suggest.analysis.SuggestReadingAttribute;
import jp.sf.fess.suggest.io.AccessibleStringReader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTokenizer
extends Tokenizer {
    private static final String NOUN = "\u540d\u8a5e";
    private static final String MIDDLE = "middle";
    private static final String START = "start";
    private static final Logger logger = LoggerFactory.getLogger(SuggestTokenizer.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final SuggestReadingAttribute readingAtt = (SuggestReadingAttribute)this.addAttribute(SuggestReadingAttribute.class);
    private String inputStr = "";
    private int offset = 0;
    private final List<String> termListByKuromoji = new ArrayList<String>();
    private final List<String> readingList = new ArrayList<String>();
    private final List<String> partOfSpeechList = new ArrayList<String>();
    private final List<String> suggestStringList = new ArrayList<String>();
    private final UserDictionary userDictionary;
    private final boolean discardPunctuation;
    private final JapaneseTokenizer.Mode tokenizerMode;
    private final boolean allTokenMode;
    private final TermChecker termChecker;
    private final int maxLength;
    private final Transliterator transliterator = Transliterator.getInstance((String)"Hiragana-Katakana");

    public SuggestTokenizer(Reader input, int bufferSize, UserDictionary userDictionaryPara, boolean discardPunctuationPara, JapaneseTokenizer.Mode modePara, TermChecker termChecker, int maxLength, boolean allTokenMode) {
        super(input);
        this.userDictionary = userDictionaryPara;
        this.discardPunctuation = discardPunctuationPara;
        this.tokenizerMode = modePara;
        this.termAtt.resizeBuffer(bufferSize);
        this.termChecker = termChecker;
        this.maxLength = maxLength;
        this.allTokenMode = allTokenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.termListByKuromoji.clear();
        this.partOfSpeechList.clear();
        this.readingList.clear();
        this.suggestStringList.clear();
        this.offset = 0;
        try {
            String s = this.input instanceof AccessibleStringReader ? ((AccessibleStringReader)this.input).getString() : IOUtils.toString((Reader)this.input);
            if (s != null && s.length() > 0) {
                if (this.maxLength > 0 && s.length() > this.maxLength) {
                    s = this.truncateInput(s);
                }
                this.inputStr = s;
            } else {
                this.inputStr = "";
            }
        }
        catch (IOException e) {
            this.inputStr = "";
        }
        StringReader rd = new StringReader(this.inputStr);
        JapaneseTokenizer stream = null;
        try {
            stream = new JapaneseTokenizer((Reader)rd, this.userDictionary, this.discardPunctuation, this.tokenizerMode);
            stream.reset();
            while (stream.incrementToken()) {
                CharTermAttribute att = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                this.termListByKuromoji.add(att.toString());
                PartOfSpeechAttribute psAtt = (PartOfSpeechAttribute)stream.getAttribute(PartOfSpeechAttribute.class);
                String pos = psAtt.getPartOfSpeech();
                this.partOfSpeechList.add(pos);
                ReadingAttribute rdAttr = (ReadingAttribute)stream.getAttribute(ReadingAttribute.class);
                String reading = rdAttr.getReading() != null ? rdAttr.getReading() : this.transliterator.transliterate(att.toString());
                this.readingList.add(reading);
            }
        }
        catch (Exception e) {
            logger.warn("JapaneseTokenizer stream error", (Throwable)e);
        }
        finally {
            try {
                this.input.reset();
            }
            catch (Exception e) {}
            try {
                stream.end();
            }
            catch (Exception e) {}
            try {
                ((Reader)rd).close();
            }
            catch (Exception exception) {}
        }
    }

    private String truncateInput(String s) {
        int ch;
        int pos;
        for (pos = this.maxLength; pos > 0 && Character.isLetterOrDigit(ch = s.codePointAt(pos)); --pos) {
        }
        if (pos == 0) {
            pos = this.maxLength;
        }
        return s.substring(0, pos);
    }

    public final boolean incrementToken() throws IOException {
        this.termAtt.setEmpty();
        this.readingAtt.setEmpty();
        int termListByKuromojiSize = this.termListByKuromoji.size();
        if (!this.allTokenMode && this.offset < termListByKuromojiSize) {
            while (this.partOfSpeechList.get(this.offset).indexOf(NOUN) == -1) {
                ++this.offset;
                if (this.offset < termListByKuromojiSize) continue;
            }
        }
        if (this.offset < termListByKuromojiSize) {
            this.termAtt.append(this.termListByKuromoji.get(this.offset));
            this.readingAtt.append(this.readingList.get(this.offset));
            ++this.offset;
        } else {
            int tmpOffset = this.offset - termListByKuromojiSize;
            if (tmpOffset < termListByKuromojiSize) {
                StringBuilder buffer = new StringBuilder(100);
                StringBuilder readingBuf = new StringBuilder(100);
                int end = 1;
                int partOfSpeechListSize = this.partOfSpeechList.size();
                while (tmpOffset < partOfSpeechListSize) {
                    buffer.setLength(0);
                    readingBuf.setLength(0);
                    String termByKuromoji = this.termListByKuromoji.get(tmpOffset);
                    if (this.termChecker.check(this.partOfSpeechList.get(tmpOffset), termByKuromoji, START)) {
                        buffer.append(termByKuromoji);
                        readingBuf.append(this.readingList.get(tmpOffset));
                        int i = 1;
                        while (tmpOffset + i < partOfSpeechListSize) {
                            String termPairByKuromoji = this.termListByKuromoji.get(tmpOffset + i);
                            if (!this.termChecker.check(this.partOfSpeechList.get(tmpOffset + i), termPairByKuromoji, MIDDLE) || this.inputStr.indexOf(buffer.toString() + termPairByKuromoji) == -1) break;
                            buffer.append(termPairByKuromoji);
                            readingBuf.append(this.readingList.get(tmpOffset + i));
                            ++end;
                            ++i;
                        }
                        if (end > 1) break;
                    }
                    ++tmpOffset;
                }
                if (buffer == null || tmpOffset >= partOfSpeechListSize || buffer.length() <= this.termListByKuromoji.get(tmpOffset).length()) {
                    return false;
                }
                this.termAtt.append(buffer.toString());
                this.readingAtt.append(readingBuf.toString());
                this.offset = tmpOffset + termListByKuromojiSize + end;
            } else {
                return false;
            }
        }
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.initialize();
    }

    public static class TermChecker {
        private static final String INCLUDE_CHAR_TERM = "includeCharTerm";
        private static final String EXCLUDE_PART_OF_SPEECH = "excludePartOfSpeech";
        private static final String INCLUDE_PART_OF_SPEECH = "includePartOfSpeech";
        private final Map<String, Map<String, List<String>>> paramMap = new HashMap<String, Map<String, List<String>>>(2);

        public TermChecker() {
            HashMap startParamMap = new HashMap(3);
            startParamMap.put(INCLUDE_PART_OF_SPEECH, new ArrayList());
            startParamMap.put(EXCLUDE_PART_OF_SPEECH, new ArrayList());
            startParamMap.put(INCLUDE_CHAR_TERM, new ArrayList());
            this.paramMap.put(SuggestTokenizer.START, startParamMap);
            HashMap middleParamMap = new HashMap(3);
            middleParamMap.put(INCLUDE_PART_OF_SPEECH, new ArrayList());
            middleParamMap.put(EXCLUDE_PART_OF_SPEECH, new ArrayList());
            middleParamMap.put(INCLUDE_CHAR_TERM, new ArrayList());
            this.paramMap.put(SuggestTokenizer.MIDDLE, middleParamMap);
        }

        public void includePartOfSpeech(String mode, String value) {
            this.updateParam(mode, INCLUDE_PART_OF_SPEECH, value);
        }

        public void excludePartOfSpeech(String mode, String value) {
            this.updateParam(mode, EXCLUDE_PART_OF_SPEECH, value);
        }

        public void includeCharTerm(String mode, String value) {
            this.updateParam(mode, INCLUDE_CHAR_TERM, value);
        }

        private void updateParam(String mode, String target, String value) {
            List<String> list;
            Map<String, List<String>> modeParamMap = this.paramMap.get(mode);
            if (modeParamMap != null && (list = modeParamMap.get(target)) != null) {
                list.add(value);
            }
        }

        public boolean check(String partOfSpeech, String termByKuromoji, String mode) {
            int i;
            Map<String, List<String>> modeParamMap = this.paramMap.get(mode);
            List<String> includePartOfSpeechList = modeParamMap.get(INCLUDE_PART_OF_SPEECH);
            List<String> excludePartOfSpeechList = modeParamMap.get(EXCLUDE_PART_OF_SPEECH);
            List<String> includeCharTermList = modeParamMap.get(INCLUDE_CHAR_TERM);
            boolean ret = false;
            for (i = 0; i < includePartOfSpeechList.size(); ++i) {
                if (partOfSpeech.indexOf(includePartOfSpeechList.get(i)) == -1) continue;
                boolean isNg = false;
                for (int j = 0; j < excludePartOfSpeechList.size(); ++j) {
                    if (partOfSpeech.indexOf(excludePartOfSpeechList.get(j)) == -1) continue;
                    isNg = true;
                }
                if (isNg) continue;
                ret = true;
                break;
            }
            if (!ret) {
                for (i = 0; i < includeCharTermList.size(); ++i) {
                    if (!termByKuromoji.equals(includeCharTermList.get(i))) continue;
                    ret = true;
                    break;
                }
            }
            return ret;
        }

        public String toString() {
            return "TermChecker [paramMap=" + this.paramMap + "]";
        }
    }
}

