/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorfologikFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class MorfologikFilterFactory
extends TokenFilterFactory {
    public static final String DEFAULT_DICTIONARY_RESOURCE = "pl";
    private final String dictionaryResource;
    @Deprecated
    public static final String DICTIONARY_SCHEMA_ATTRIBUTE = "dictionary";
    public static final String DICTIONARY_RESOURCE_ATTRIBUTE = "dictionary-resource";

    public MorfologikFilterFactory(Map<String, String> args) {
        super(args);
        String dictionaryName = this.get(args, DICTIONARY_SCHEMA_ATTRIBUTE);
        if (dictionaryName != null && !dictionaryName.isEmpty()) {
            Logger.getLogger(MorfologikFilterFactory.class.getName()).warning("The dictionary attribute is no longer supported (Morfologik now offers one unified Polish dictionary): " + dictionaryName + ". Perhaps you wanted to use 'dictionary-resource' attribute instead?");
        }
        this.dictionaryResource = this.get(args, DICTIONARY_RESOURCE_ATTRIBUTE, DEFAULT_DICTIONARY_RESOURCE);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public TokenStream create(TokenStream ts) {
        return new MorfologikFilter(ts, this.dictionaryResource, this.luceneMatchVersion);
    }
}

