/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest;

import java.util.ArrayList;
import java.util.List;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.normalizer.SuggestNormalizer;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;

public class Suggester {
    private static final String _AND_ = " AND ";
    private static final String _OR_ = " OR ";
    private SuggestReadingConverter converter = null;
    private SuggestNormalizer normalizer = null;

    public void setConverter(SuggestReadingConverter converter) {
        this.converter = converter;
    }

    public void setNormalizer(SuggestNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public String buildSuggestQuery(String query, List<String> targetFields, List<String> labels, List<String> roles) {
        boolean isFirst;
        String q = this.buildQuery(query);
        if (StringUtils.isBlank((String)q)) {
            return "";
        }
        StringBuilder queryBuf = new StringBuilder(q.length() + 100);
        queryBuf.append(q);
        if (targetFields != null && !targetFields.isEmpty()) {
            queryBuf.append(_AND_);
            if (targetFields.size() >= 2) {
                queryBuf.append("(");
            }
            for (int i = 0; i < targetFields.size(); ++i) {
                String fieldName = targetFields.get(i);
                if (i > 0) {
                    queryBuf.append(_OR_);
                }
                queryBuf.append("fieldname_s_m");
                queryBuf.append(':');
                queryBuf.append(fieldName);
            }
            if (targetFields.size() >= 2) {
                queryBuf.append(')');
            }
        }
        if (labels != null && !labels.isEmpty()) {
            queryBuf.append(_AND_);
            if (labels.size() >= 2) {
                queryBuf.append('(');
            }
            isFirst = true;
            for (String label : labels) {
                if (!isFirst) {
                    queryBuf.append(_OR_);
                }
                queryBuf.append("label_s_m");
                queryBuf.append(':');
                queryBuf.append(label);
                isFirst = false;
            }
            if (labels.size() >= 2) {
                queryBuf.append(')');
            }
        }
        if (roles != null && !roles.isEmpty()) {
            queryBuf.append(_AND_);
            if (roles.size() >= 2) {
                queryBuf.append('(');
            }
            isFirst = true;
            for (String role : roles) {
                if (!isFirst) {
                    queryBuf.append(_OR_);
                }
                queryBuf.append("role_s_m");
                queryBuf.append(':');
                queryBuf.append(role);
                isFirst = false;
            }
            if (roles.size() >= 2) {
                queryBuf.append(')');
            }
        }
        return queryBuf.toString();
    }

    protected String buildQuery(String query) {
        String q = query;
        if (this.normalizer != null) {
            q = this.normalizer.normalize(q);
        }
        q = ClientUtils.escapeQueryChars((String)q.trim());
        List<Object> readingList = new ArrayList<String>();
        if (this.converter != null) {
            readingList = this.converter.convert(q);
        } else {
            readingList.add(q);
        }
        if (readingList.isEmpty()) {
            return "reading_s_m:" + query + '*';
        }
        StringBuilder queryBuf = new StringBuilder(100);
        if (readingList.size() >= 2) {
            queryBuf.append('(');
        }
        for (String string : readingList) {
            if (queryBuf.length() > 1) {
                queryBuf.append(_OR_);
            }
            queryBuf.append("reading_s_m");
            queryBuf.append(':');
            queryBuf.append(string);
            queryBuf.append('*');
        }
        if (readingList.size() >= 2) {
            queryBuf.append(')');
        }
        return queryBuf.toString();
    }
}

