/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random.sampling;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;

public final class RandomSampler {
    private RandomSampler() {
    }

    private static void rejectMethodD(long n, long N, int count, long low, long[] values, int fromIndex, Random randomGenerator) {
        long S;
        n = N - n;
        long chosen = -1L + low;
        double nreal = n;
        double ninv = 1.0 / nreal;
        double Nreal = N;
        double Vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * ninv);
        long qu1 = -n + 1L + N;
        double qu1real = -nreal + 1.0 + Nreal;
        while (n > 1L && count > 0) {
            double negSreal;
            double nmin1inv = 1.0 / (-1.0 + nreal);
            while (true) {
                long limit;
                double bottom;
                double X;
                if ((S = (long)(X = Nreal * (-Vprime + 1.0))) >= qu1) {
                    Vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * ninv);
                    continue;
                }
                double U = randomGenerator.nextDouble();
                negSreal = -S;
                double y1 = Math.exp(Math.log(U * Nreal / qu1real) * nmin1inv);
                Vprime = y1 * (-X / Nreal + 1.0) * qu1real / (negSreal + qu1real);
                if (Vprime <= 1.0) break;
                double top = -1.0 + Nreal;
                if (n - 1L > S) {
                    bottom = -nreal + Nreal;
                    limit = -S + N;
                } else {
                    bottom = -1.0 + negSreal + Nreal;
                    limit = qu1;
                }
                double y2 = 1.0;
                for (long t = N - 1L; t >= limit; --t) {
                    y2 *= top / bottom;
                    top -= 1.0;
                    bottom -= 1.0;
                }
                if (Nreal / (-X + Nreal) >= y1 * Math.exp(Math.log(y2) * nmin1inv)) {
                    Vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * nmin1inv);
                    break;
                }
                Vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * ninv);
            }
            int iter = count;
            if (S < (long)iter) {
                iter = (int)S;
            }
            count -= iter;
            while (--iter >= 0) {
                values[fromIndex++] = ++chosen;
            }
            ++chosen;
            N -= S + 1L;
            Nreal = negSreal - 1.0 + Nreal;
            --n;
            nreal -= 1.0;
            ninv = nmin1inv;
            qu1 = -S + qu1;
            qu1real = negSreal + qu1real;
        }
        if (count > 0) {
            S = (long)((double)N * Vprime);
            int iter = count;
            if (S < (long)iter) {
                iter = (int)S;
            }
            count -= iter;
            while (--iter >= 0) {
                values[fromIndex++] = ++chosen;
            }
            ++chosen;
            while (--count >= 0) {
                values[fromIndex++] = ++chosen;
            }
        }
    }

    public static void sample(long n, long N, int count, long low, long[] values, int fromIndex, Random randomGenerator) {
        if (n <= 0L || count <= 0) {
            return;
        }
        if ((long)count > n) {
            throw new IllegalArgumentException("count must not be greater than n");
        }
        if (randomGenerator == null) {
            randomGenerator = RandomUtils.getRandom();
        }
        if ((long)count == N) {
            long val = low;
            int limit = fromIndex + count;
            for (int i = fromIndex; i < limit; ++i) {
                ++val;
            }
            return;
        }
        if ((double)n < (double)N * 0.95) {
            RandomSampler.sampleMethodD(n, N, count, low, values, fromIndex, randomGenerator);
        } else {
            RandomSampler.rejectMethodD(n, N, count, low, values, fromIndex, randomGenerator);
        }
    }

    private static void sampleMethodA(long n, long N, int count, long low, long[] values, int fromIndex, Random randomGenerator) {
        long S;
        long chosen = -1L + low;
        double top = N - n;
        double Nreal = N;
        while (n >= 2L && count > 0) {
            double V = randomGenerator.nextDouble();
            S = 0L;
            for (double quot = top / Nreal; quot > V; quot *= (top -= 1.0) / (Nreal -= 1.0)) {
                ++S;
            }
            values[fromIndex++] = chosen += S + 1L;
            --count;
            Nreal -= 1.0;
            --n;
        }
        if (count > 0) {
            S = (long)((double)Math.round(Nreal) * randomGenerator.nextDouble());
            values[fromIndex] = chosen += S + 1L;
        }
    }

    private static void sampleMethodD(long n, long N, int count, long low, long[] values, int fromIndex, Random randomGenerator) {
        long S;
        long chosen = -1L + low;
        double nreal = n;
        double ninv = 1.0 / nreal;
        double Nreal = N;
        double vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * ninv);
        long qu1 = -n + 1L + N;
        double qu1real = -nreal + 1.0 + Nreal;
        long negalphainv = -13L;
        for (long threshold = -negalphainv * n; n > 1L && count > 0 && threshold < N; threshold += negalphainv) {
            double negSreal;
            double nmin1inv = 1.0 / (-1.0 + nreal);
            while (true) {
                long limit;
                double bottom;
                double X;
                if ((S = (long)(X = Nreal * (-vprime + 1.0))) >= qu1) {
                    vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * ninv);
                    continue;
                }
                double U = randomGenerator.nextDouble();
                negSreal = -S;
                double y1 = Math.exp(Math.log(U * Nreal / qu1real) * nmin1inv);
                vprime = y1 * (-X / Nreal + 1.0) * qu1real / (negSreal + qu1real);
                if (vprime <= 1.0) break;
                double top = -1.0 + Nreal;
                if (n - 1L > S) {
                    bottom = -nreal + Nreal;
                    limit = -S + N;
                } else {
                    bottom = -1.0 + negSreal + Nreal;
                    limit = qu1;
                }
                double y2 = 1.0;
                for (long t = N - 1L; t >= limit; --t) {
                    y2 *= top / bottom;
                    top -= 1.0;
                    bottom -= 1.0;
                }
                if (Nreal / (-X + Nreal) >= y1 * Math.exp(Math.log(y2) * nmin1inv)) {
                    vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * nmin1inv);
                    break;
                }
                vprime = Math.exp(Math.log(randomGenerator.nextDouble()) * ninv);
            }
            values[fromIndex++] = chosen += S + 1L;
            --count;
            N -= S + 1L;
            Nreal = negSreal - 1.0 + Nreal;
            --n;
            nreal -= 1.0;
            ninv = nmin1inv;
            qu1 = -S + qu1;
            qu1real = negSreal + qu1real;
        }
        if (count > 0) {
            if (n > 1L) {
                RandomSampler.sampleMethodA(n, N, count, chosen + 1L, values, fromIndex, randomGenerator);
            } else {
                S = (long)((double)N * vprime);
                values[fromIndex++] = chosen += S + 1L;
            }
        }
    }
}

