/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.AbstractPreferenceImportExportPage;

class PreferenceImportExportFileSelectionPage
extends AbstractPreferenceImportExportPage {
    private static final String[] DIALOG_PREFERENCE_EXTENSIONS = new String[]{"*.epf", "*.*"};
    private static final String EXPORT_MESSAGE = WorkbenchMessages.getString("ImportExportPages.exportFileSelect");
    private static final String IMPORT_MESSAGE = WorkbenchMessages.getString("ImportExportPages.importFileSelect");
    private static final String NAME = "org.eclipse.ui.preferences.importExportFileSelectionPage";
    public final Listener changeListener = new PageChangeListener();
    private Text fileText;

    PreferenceImportExportFileSelectionPage(boolean exportWizard) {
        super(NAME, exportWizard);
    }

    boolean canFinish() {
        return this.validate();
    }

    private void chooseFile() {
        String currentFileName = this.fileText.getText();
        FileDialog fileDialog = null;
        fileDialog = this.export ? new FileDialog(this.getShell(), 8192) : new FileDialog(this.getShell(), 4096);
        fileDialog.setFileName(currentFileName);
        fileDialog.setFilterExtensions(DIALOG_PREFERENCE_EXTENSIONS);
        currentFileName = fileDialog.open();
        if (currentFileName == null) {
            return;
        }
        String fileName = new File(currentFileName).getName();
        if (fileName.lastIndexOf(".") == -1) {
            currentFileName = String.valueOf(currentFileName) + ".epf";
        }
        this.fileText.setText(currentFileName);
        this.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        Font parentFont = parent.getFont();
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        page.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)page);
        if (this.export) {
            this.setTitle(AbstractPreferenceImportExportPage.EXPORT_TITLE);
            this.setMessage(EXPORT_MESSAGE);
            this.setImageDescriptor(AbstractPreferenceImportExportPage.getImageDescriptor("wizban/export_wiz.gif"));
        } else {
            this.setTitle(AbstractPreferenceImportExportPage.IMPORT_TITLE);
            this.setMessage(IMPORT_MESSAGE);
            this.setImageDescriptor(AbstractPreferenceImportExportPage.getImageDescriptor("wizban/import_wiz.gif"));
        }
        Label fileLabel = new Label(page, 0);
        fileLabel.setText(WorkbenchMessages.getString("ImportExportPages.fileLabel"));
        fileLabel.setFont(parentFont);
        GridData layoutData = new GridData();
        fileLabel.setLayoutData((Object)layoutData);
        this.fileText = new Text(page, 2052);
        this.fileText.setFont(parentFont);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.fileText.setLayoutData((Object)layoutData);
        this.fileText.addListener(24, this.changeListener);
        Button browseButton = new Button(page, 8);
        browseButton.setFont(parentFont);
        layoutData = new GridData();
        browseButton.setText(WorkbenchMessages.getString("ImportExportPages.browseButton"));
        layoutData.heightHint = this.convertVerticalDLUsToPixels(14);
        layoutData.widthHint = this.computePushButtonWidthHint(browseButton);
        browseButton.setLayoutData((Object)layoutData);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                PreferenceImportExportFileSelectionPage.this.chooseFile();
            }
        });
        Composite verticalSpacer = new Composite(page, 0);
        layoutData = new GridData();
        layoutData.heightHint = 15;
        layoutData.horizontalSpan = 3;
        verticalSpacer.setLayoutData((Object)layoutData);
        this.setControl((Control)page);
        this.init();
    }

    String getPath() {
        return this.fileText.getText();
    }

    private void init() {
        String lastFileName = WorkbenchPlugin.getDefault().getDialogSettings().get("PreferenceImportExportFileSelectionPage.filePath");
        if (lastFileName == null) {
            if (this.export) {
                this.fileText.setText(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + WorkbenchMessages.getString("ImportExportPages.preferenceFileName") + ".epf");
            }
        } else if (this.export || new File(lastFileName).exists()) {
            this.fileText.setText(lastFileName);
        }
    }

    boolean validate() {
        String fileName = this.fileText.getText();
        if (fileName.equals("")) {
            this.setErrorMessage(null);
            return false;
        }
        File currentFile = new File(fileName);
        if (this.export) {
            File parentFile = currentFile.getParentFile();
            if (parentFile == null || !parentFile.exists()) {
                this.setErrorMessage(WorkbenchMessages.getString("ImportExportPages.errorDirectoryDoesNotExist"));
                return false;
            }
        } else if (!currentFile.exists()) {
            this.setErrorMessage(WorkbenchMessages.getString("ImportExportPages.errorImportFileDoesNotExist"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class PageChangeListener
    implements Listener {
        PageChangeListener() {
        }

        public void handleEvent(Event event) {
            IWizardContainer container = PreferenceImportExportFileSelectionPage.this.getContainer();
            if (container.getCurrentPage() != null) {
                container.updateButtons();
            }
        }
    }
}

