/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.toc.DirectoryToc;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.eclipse.help.internal.toc.Topic;
import org.xml.sax.Attributes;

public class Toc
extends TocNode
implements IToc,
ITocElement {
    private static final int SIZE_UNINITIALIZED = -1;
    private String link_to;
    private String href;
    private String label;
    private TocFile tocFile;
    private ITopic[] topicArray;
    private Topic descriptionTopic;
    private List childrenTocs;
    private DirectoryToc directoryToc;
    private Map topicMap = new HashMap();
    private int size = -1;

    protected Toc(TocFile tocFile, Attributes attrs) {
        if (attrs == null) {
            return;
        }
        this.tocFile = tocFile;
        this.label = attrs.getValue("label");
        if (this.label == null) {
            throw new RuntimeException("toc label==null");
        }
        this.link_to = attrs.getValue("link_to");
        this.link_to = HrefUtil.normalizeHref(tocFile.getPluginID(), this.link_to);
        this.href = HrefUtil.normalizeHref(tocFile.getPluginID(), tocFile.getHref());
        try {
            this.descriptionTopic = new Topic(tocFile, null);
            this.descriptionTopic.setLabel(this.label);
            String topic = attrs.getValue("topic");
            if (topic != null && topic.trim().length() > 0) {
                this.descriptionTopic.setHref(HrefUtil.normalizeHref(tocFile.getPluginID(), topic));
            } else {
                this.descriptionTopic.setHref("");
            }
        }
        catch (Exception exception) {}
        this.childrenTocs = new ArrayList();
        this.directoryToc = new DirectoryToc(tocFile);
    }

    public void build(TocBuilder builder) {
        builder.buildToc(this);
    }

    public TocFile getTocFile() {
        return this.tocFile;
    }

    protected String getLink_to() {
        return this.link_to;
    }

    public String getHref() {
        return this.href;
    }

    public String getLabel() {
        return this.label;
    }

    public ITopic getTopic(String href) {
        if (href == null || href.equals(this.descriptionTopic.getHref())) {
            return this.descriptionTopic;
        }
        return this.getTopicNoDescr(href);
    }

    private ITopic getTopicNoDescr(String href) {
        ITopic result = this.getOwnedTopic(href);
        if (result != null) {
            return result;
        }
        Iterator it = this.getChildrenTocs().iterator();
        while (it.hasNext()) {
            Toc childToc = (Toc)it.next();
            result = childToc.getTopicNoDescr(href);
            if (result != null) break;
        }
        return result;
    }

    public ITopic[] getTopics() {
        if (this.topicArray == null) {
            List topics = this.getChildTopics();
            this.topicArray = new ITopic[topics.size()];
            topics.toArray(this.topicArray);
            this.tocFile = null;
        }
        return this.topicArray;
    }

    public String getTocTopicHref() {
        if (this.descriptionTopic != null) {
            return this.descriptionTopic.getHref();
        }
        return null;
    }

    public ITopic getOwnedTopic(String href) {
        return (ITopic)this.topicMap.get(href);
    }

    public ITopic[] getExtraTopics() {
        Collection dirTopicCollection = this.directoryToc.getExtraTopics().values();
        ITopic[] dirTopics = dirTopicCollection.toArray(new ITopic[dirTopicCollection.size()]);
        Iterator it = this.childrenTocs.iterator();
        while (it.hasNext()) {
            ITopic[] moreDirTopics;
            IToc toc = (IToc)it.next();
            if (!(toc instanceof Toc) || (moreDirTopics = ((Toc)toc).getExtraTopics()).length <= 0) continue;
            ITopic[] newDirTopics = new ITopic[dirTopics.length + moreDirTopics.length];
            System.arraycopy(dirTopics, 0, newDirTopics, 0, dirTopics.length);
            System.arraycopy(moreDirTopics, 0, newDirTopics, dirTopics.length, moreDirTopics.length);
            dirTopics = newDirTopics;
        }
        return dirTopics;
    }

    public ITopic getOwnedExtraTopic(String href) {
        return (ITopic)this.directoryToc.getExtraTopics().get(href);
    }

    public String toString() {
        return this.href != null ? this.href : super.toString();
    }

    public List getChildrenTocs() {
        return this.childrenTocs;
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.topicMap.size();
            Iterator it = this.childrenTocs.iterator();
            while (it.hasNext()) {
                this.size += ((Toc)it.next()).size();
            }
        }
        return this.size;
    }

    void registerTopic(ITopic topic) {
        String topicHref = topic.getHref();
        if (topicHref != null) {
            this.topicMap.put(topicHref, topic);
        }
    }
}

