/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.ffplug.rcp.models.data.Constants;
import jp.sourceforge.ffplug.rcp.models.data.DateUtils;
import jp.sourceforge.ffplug.rcp.models.data.FileIOUtils;
import org.apache.commons.collections.map.LinkedMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.WorkbenchWindow;

public class NetworkUpdateAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IStatusLineManager lineManager;
    private String errorMessage;
    private String infoMessage;

    public void run(IAction action) {
        this.lineManager.setErrorMessage("");
        this.lineManager.setMessage("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u4e2d...");
        this.errorMessage = null;
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        this.networkUpdateProject(root, monitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }

            private void dummy(IWorkspaceRoot root2, IProgressMonitor monitor) throws CoreException, IOException {
                monitor.beginTask("\u6642\u9593\u306e\u639b\u304b\u308b\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3059\u2026", 100);
                int i = 0;
                while (i < 100) {
                    monitor.subTask(String.valueOf(i) + "%");
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    monitor.worked(1);
                    ++i;
                }
                String fileName = "item20050228.txt";
                URL url = new URL(String.valueOf(Constants.RECIPE_URL_BASE) + fileName);
                url.openConnection();
                new File(fileName);
                monitor.done();
            }

            private void networkUpdateProject(IWorkspaceRoot root2, IProgressMonitor monitor) throws CoreException, IOException {
                IProject project = root2.getProject(Constants.MYPROJECT);
                if (!project.exists()) {
                    project.create(monitor);
                    project.open(monitor);
                }
                project.refreshLocal(2, monitor);
                IFolder folder = project.getFolder(Constants.MYFOLDER);
                if (folder.exists()) {
                    System.out.println("[MyFolder] exists.");
                    ArrayList<Date> recipeFileDates = new ArrayList<Date>();
                    ArrayList<Date> itemFileDates = new ArrayList<Date>();
                    IResource[] resources = folder.members();
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i] instanceof IFile) {
                            IFile file = (IFile)resources[i];
                            String fileName = file.getName();
                            Date recipeDate = DateUtils.parseDateFilename("recipe", fileName);
                            Date itemDate = DateUtils.parseDateFilename("item", fileName);
                            if (recipeDate != null) {
                                recipeFileDates.add(recipeDate);
                            }
                            if (itemDate != null) {
                                itemFileDates.add(itemDate);
                            }
                        }
                        ++i;
                    }
                    Date recipeLatest = DateUtils.latestDate(recipeFileDates);
                    Date itemLatest = DateUtils.latestDate(itemFileDates);
                    if (recipeLatest == null) {
                        System.out.println("file not found. (recipe.txt)");
                    }
                    if (itemLatest == null) {
                        System.out.println("file not found. (item.txt)");
                    }
                    Date newLatestRecipeDate = this.networkUpdateBeforeDate(folder, monitor, Constants.RECIPE_URL_BASE, "recipe", recipeLatest);
                    Date newLatestItemDate = this.networkUpdateBeforeDate(folder, monitor, Constants.RECIPE_URL_BASE, "item", itemLatest);
                    if (newLatestRecipeDate != null) {
                        recipeLatest = newLatestRecipeDate;
                    }
                    if (newLatestItemDate != null) {
                        itemLatest = newLatestItemDate;
                    }
                    if (recipeLatest == null) {
                        NetworkUpdateAction.this.errorMessage = "\u30d5\u30a1\u30a4\u30eb\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                        return;
                    }
                    if (itemLatest == null) {
                        NetworkUpdateAction.this.errorMessage = "\u30d5\u30a1\u30a4\u30eb\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                        return;
                    }
                    IFile recipeFile = folder.getFile("recipe." + DateUtils.formatDate(recipeLatest) + ".txt");
                    IFile itemFile = folder.getFile("item." + DateUtils.formatDate(itemLatest) + ".txt");
                    if (recipeFile.exists() && itemFile.exists()) {
                        InputStreamReader recipeReader = new InputStreamReader(recipeFile.getContents());
                        InputStreamReader itemReader = new InputStreamReader(itemFile.getContents());
                        LinkedMap items = FileIOUtils.readItemData(itemReader);
                        LinkedMap synths = FileIOUtils.readRecipeData(recipeReader);
                        FileIOUtils.fillSynthNameBeans(synths, items);
                        IFile priceFile = folder.getFile("price.txt");
                        if (priceFile.exists()) {
                            InputStreamReader priceReader = new InputStreamReader(priceFile.getContents());
                            FileIOUtils.addItemPriceBeanFromReader(items, priceReader);
                        }
                        project.setSessionProperty(new QualifiedName(null, Constants.SESSION_SYNTH), (Object)synths);
                        project.setSessionProperty(new QualifiedName(null, Constants.SESSION_ITEM), (Object)items);
                    } else {
                        System.out.println("file not found. (recipe.txt or item.txt)");
                        NetworkUpdateAction.this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
                    }
                } else {
                    folder.create(true, true, monitor);
                    System.out.println("file not found. (new folder)");
                    NetworkUpdateAction.this.errorMessage = "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002";
                }
            }

            private Date networkUpdateBeforeDate(IFolder folder, IProgressMonitor monitor, String urlBase, String prefix, Date latest) {
                Date monday = DateUtils.lastMonday(DateUtils.getNowDate());
                Date latestDate = latest;
                if (latest == null) {
                    latestDate = DateUtils.parseDate("19900101");
                }
                int i = 0;
                while (i < 10 && latestDate.before(monday)) {
                    System.out.println("monday = [" + monday + "]");
                    String fileName = String.valueOf(prefix) + "." + DateUtils.formatDate(monday) + ".txt";
                    String urlStr = String.valueOf(urlBase) + fileName;
                    System.out.println("urlStr = [" + urlStr + "]");
                    try {
                        URL url = new URL(urlStr);
                        URLConnection conn = url.openConnection();
                        BufferedInputStream inStream = new BufferedInputStream(conn.getInputStream());
                        folder.getFile(fileName).create((InputStream)inStream, true, monitor);
                        return monday;
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    monday = DateUtils.lastWeekDay(monday);
                    ++i;
                }
                return null;
            }
        };
        try {
            new ProgressMonitorDialog(new Shell()).run(true, false, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.errorMessage != null) {
            this.lineManager.setErrorMessage(this.errorMessage);
            this.errorMessage = null;
        } else if (this.infoMessage != null) {
            this.lineManager.setMessage(this.infoMessage);
            this.infoMessage = null;
        } else {
            this.lineManager.setMessage("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u66f4\u65b0\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        IWorkbench workbench = window.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        this.lineManager = workbenchWindow.getActionBars().getStatusLineManager();
    }
}

