/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.models.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import jp.sourceforge.ffplug.rcp.models.data.ItemPriceBean;
import jp.sourceforge.ffplug.rcp.models.data.SynthPriceBean;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LinkedMap;

public class FileIOUtils {
    public static LinkedMap readRecipeData(Reader reader) throws IOException {
        String line;
        LinkedMap lmap = new LinkedMap();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String[] cells = line.split("\t");
            if (cells.length != 33) {
                System.out.println("cells.length != 33 [" + cells.length + "]");
                return null;
            }
            Integer recipeIdInteger = new Integer(cells[0]);
            int recipeId = recipeIdInteger;
            SynthPriceBean synth = new SynthPriceBean();
            synth.setRecipeId(recipeId);
            synth.setItemId(FileIOUtils.parseIntLoose(cells[1]));
            synth.setAmount(FileIOUtils.parseIntLoose(cells[2]));
            int[] hqItemIds = new int[3];
            int[] hqAmounts = new int[3];
            hqItemIds[0] = FileIOUtils.parseIntLoose(cells[3]);
            hqAmounts[0] = FileIOUtils.parseIntLoose(cells[4]);
            hqItemIds[1] = FileIOUtils.parseIntLoose(cells[5]);
            hqAmounts[1] = FileIOUtils.parseIntLoose(cells[6]);
            hqItemIds[2] = FileIOUtils.parseIntLoose(cells[7]);
            hqAmounts[2] = FileIOUtils.parseIntLoose(cells[8]);
            synth.setHqItemIds(hqItemIds);
            synth.setHqAmounts(hqAmounts);
            synth.setSkillId(FileIOUtils.parseIntLoose(cells[9]));
            synth.setRankId(FileIOUtils.parseIntLoose(cells[10]));
            synth.setCrystalId(FileIOUtils.parseIntLoose(cells[11]));
            synth.setKeyItem(FileIOUtils.parseIntLoose(cells[12]));
            synth.setMaterialItemId1(FileIOUtils.parseIntLoose(cells[13]));
            synth.setMaterialItemId2(FileIOUtils.parseIntLoose(cells[14]));
            synth.setMaterialItemId3(FileIOUtils.parseIntLoose(cells[15]));
            synth.setMaterialItemId4(FileIOUtils.parseIntLoose(cells[16]));
            synth.setMaterialItemId5(FileIOUtils.parseIntLoose(cells[17]));
            synth.setMaterialItemId6(FileIOUtils.parseIntLoose(cells[18]));
            synth.setMaterialItemId7(FileIOUtils.parseIntLoose(cells[19]));
            synth.setMaterialItemId8(FileIOUtils.parseIntLoose(cells[20]));
            int[] skillCaps = new int[9];
            int i = 0;
            while (i < 9) {
                skillCaps[i] = FileIOUtils.parseIntLoose(cells[21 + i]);
                ++i;
            }
            synth.setSkillCaps(skillCaps);
            synth.setDecomp(FileIOUtils.parseBooleanLoose(cells[30]));
            synth.setInsertedDate(cells[31]);
            synth.setUpdatedDate(cells[32]);
            lmap.put((Object)recipeIdInteger, (Object)synth);
        }
        in.close();
        return lmap;
    }

    public static LinkedMap readItemData(Reader reader) throws IOException {
        String line;
        LinkedMap lmap = new LinkedMap();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String[] cells = line.split("\t");
            if (cells.length != 9) {
                System.out.println("cells.length != 9 [" + cells.length + "]");
                return null;
            }
            Integer itemIdInteger = new Integer(cells[0]);
            int itemId = itemIdInteger;
            ItemPriceBean item = new ItemPriceBean();
            item.setItemId(itemId);
            item.setItemName(cells[1]);
            item.setItemText(cells[2]);
            item.setRare(FileIOUtils.parseBooleanLoose(cells[3]));
            item.setEx(FileIOUtils.parseBooleanLoose(cells[4]));
            item.setStackAmount(FileIOUtils.parseIntLoose(cells[5]));
            item.setItemNameEnglish(cells[6]);
            item.setInsertedDate(cells[7]);
            item.setUpdatedDate(cells[8]);
            lmap.put((Object)itemIdInteger, (Object)item);
        }
        in.close();
        return lmap;
    }

    public static void addItemPriceBeanFromReader(LinkedMap itemPriceBeans, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line = in.readLine();
        while ((line = in.readLine()) != null) {
            String[] cells = line.split("\t");
            if (cells.length != 16) {
                System.out.println("cells.length != 16 [" + cells.length + "]");
                return;
            }
            Integer itemIdInteger = new Integer(cells[0]);
            itemIdInteger.intValue();
            ItemPriceBean item = (ItemPriceBean)itemPriceBeans.get((Object)itemIdInteger);
            int i = 0;
            while (i < 5) {
                item.getAhPrice().getPrices()[i] = FileIOUtils.parseIntLoose(cells[i + 2]);
                item.getAhPrice().getStackPrices()[i] = FileIOUtils.parseIntLoose(cells[i + 7]);
                ++i;
            }
            item.setShopSellPrice(FileIOUtils.parseIntLoose(cells[12]));
            item.setShopBuyPrice(FileIOUtils.parseIntLoose(cells[13]));
            item.setGuildSellPrice(FileIOUtils.parseIntLoose(cells[14]));
            item.setGuildBuyPrice(FileIOUtils.parseIntLoose(cells[15]));
        }
        in.close();
    }

    public static void saveItemPriceBean(LinkedMap itemPriceBeans, Writer writer) throws IOException {
        FileIOUtils.saveItemPriceBean(itemPriceBeans, writer, false);
    }

    public static void saveItemPriceBean(LinkedMap itemPriceBeans, Writer writer, boolean saveAll) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        out.write("ITEM_ID\tITEM_NAME\tAH_S\tAH_B\tAH_W\tAH_J\tAH_U\tAHS_S\tAHS_B\tAHS_W\tAHS_J\tAHS_U\tSHOP_SELL\tSHOP_BUY\tGUILD_SELL\tGUILD_BUY");
        out.newLine();
        MapIterator mi = itemPriceBeans.mapIterator();
        while (mi.hasNext()) {
            Integer cfr_ignored_0 = (Integer)mi.next();
            ItemPriceBean item = (ItemPriceBean)mi.getValue();
            if (!saveAll && !FileIOUtils.hasAnyPrice(item)) continue;
            StringBuffer line = new StringBuffer();
            line.append(String.valueOf(item.getItemId()) + "\t");
            line.append(String.valueOf(item.getItemName()) + "\t");
            int i = 0;
            while (i < 5) {
                line.append(String.valueOf(item.getAhPrice().getPrices()[i]) + "\t");
                ++i;
            }
            i = 0;
            while (i < 5) {
                line.append(String.valueOf(item.getAhPrice().getStackPrices()[i]) + "\t");
                ++i;
            }
            line.append(String.valueOf(item.getShopSellPrice()) + "\t");
            line.append(String.valueOf(item.getShopBuyPrice()) + "\t");
            line.append(String.valueOf(item.getGuildSellPrice()) + "\t");
            line.append(item.getGuildBuyPrice());
            out.write(line.toString());
            out.newLine();
        }
        out.flush();
        out.close();
    }

    private static boolean hasAnyPrice(ItemPriceBean item) {
        int i = 0;
        while (i < 5) {
            if (item.getAhPrice().getPrices()[i] != 0) {
                return true;
            }
            if (item.getAhPrice().getStackPrices()[i] != 0) {
                return true;
            }
            ++i;
        }
        if (item.getShopSellPrice() != 0) {
            return true;
        }
        if (item.getShopBuyPrice() != 0) {
            return true;
        }
        if (item.getGuildSellPrice() != 0) {
            return true;
        }
        return item.getGuildBuyPrice() != 0;
    }

    public static void fillSynthNameBeans(LinkedMap synthNameBeans, LinkedMap itemPriceBeans) {
        MapIterator i = synthNameBeans.mapIterator();
        while (i.hasNext()) {
            Integer cfr_ignored_0 = (Integer)i.next();
            SynthPriceBean synth = (SynthPriceBean)i.getValue();
            synth.fillItems((Map)itemPriceBeans);
        }
    }

    public static int parseIntLoose(String str) {
        try {
            int num = Integer.parseInt(str);
            return num;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static boolean parseBooleanLoose(String str) {
        int booleanInt = FileIOUtils.parseIntLoose(str);
        boolean ret = false;
        ret = booleanInt == 0 ? false : booleanInt == 1;
        return ret;
    }
}

