/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.foolishmerge.diff;

import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.foolishmerge.FoolishMergeConfig;
import jp.sourceforge.foolishmerge.diff.LineDifference;

public class Delta
implements Comparable {
    public static final int ADD = 1;
    public static final int DEL = -1;
    public static final int CHANGE = 0;
    public static final int NO_STATE = Integer.MIN_VALUE;
    private LineDifference[] lines = null;
    private LineDifference[] original = null;
    private LineDifference[] modified = null;
    private int state = Integer.MIN_VALUE;
    private static final String NL = FoolishMergeConfig.getLineSeparator();
    public static final int NO_CONFLICT_LT = -2;
    public static final int CONFLICT_LT = -1;
    public static final int CONFLICT_EQ = 0;
    public static final int CONFLICT_GT = 1;
    public static final int NO_CONFLICT_GT = 2;

    public Delta(List list) {
        this.lines = list.toArray(new LineDifference[list.size()]);
        LinkedList<LineDifference> linkedList = new LinkedList<LineDifference>();
        LinkedList<LineDifference> linkedList2 = new LinkedList<LineDifference>();
        block4: for (int i = 0; i < this.lines.length; ++i) {
            switch (this.lines[i].getState()) {
                case 1: {
                    linkedList2.add(this.lines[i]);
                    continue block4;
                }
                case -1: {
                    linkedList.add(this.lines[i]);
                }
            }
        }
        this.original = linkedList.toArray(new LineDifference[linkedList.size()]);
        this.modified = linkedList2.toArray(new LineDifference[linkedList2.size()]);
        if (this.original.length > 0 && this.modified.length > 0) {
            this.state = 0;
        } else if (this.original.length > 0) {
            this.state = -1;
        } else if (this.modified.length > 0) {
            this.state = 1;
        }
    }

    public LineDifference[] getLineDifference() {
        return this.lines;
    }

    public String[] getOrgLines() {
        String[] stringArray = new String[this.original.length];
        for (int i = 0; i < this.original.length; ++i) {
            stringArray[i] = this.original[i].getLine();
        }
        return stringArray;
    }

    public LineDifference[] getOrgDifference() {
        return this.original;
    }

    public String[] getModLines() {
        String[] stringArray = new String[this.modified.length];
        for (int i = 0; i < this.modified.length; ++i) {
            stringArray[i] = this.modified[i].getLine();
        }
        return stringArray;
    }

    public LineDifference[] getModDifference() {
        return this.modified;
    }

    public int getState() {
        return this.state;
    }

    public int patch(List list, int n) {
        int n2 = 0;
        block4: for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].patch(list, n + n2);
            switch (this.lines[i].getState()) {
                case 1: {
                    ++n2;
                    continue block4;
                }
                case -1: {
                    --n2;
                }
            }
        }
        return n2;
    }

    public boolean isConflict(Delta delta) {
        int n = this.compareTo(delta);
        return n != -2 && n != 2;
    }

    public int compareTo(Object object) {
        Delta delta = (Delta)object;
        int n = 0;
        int n2 = this.getOrgFirstLineNum();
        int n3 = this.getOrgLastLineNum();
        int n4 = delta.getOrgFirstLineNum();
        int n5 = delta.getOrgLastLineNum();
        if (n3 < n4) {
            n = -2;
        } else if (n2 > n5) {
            n = 2;
        } else if (n3 < n5) {
            n = -1;
        } else if (n3 > n5) {
            n = 1;
        }
        return n;
    }

    public String toString() {
        return this.toNormalFormat();
    }

    public String toNormalFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getOrgFirstLineNum() + 1;
        int n2 = this.getOrgLastLineNum() + 1;
        int n3 = this.getModFirstLineNum() + 1;
        int n4 = this.getModLastLineNum() + 1;
        String string = null;
        String string2 = null;
        string = n == n2 ? String.valueOf(n) : n + "," + n2;
        string2 = n3 == n4 || this.state == -1 ? String.valueOf(n3) : n3 + "," + n4;
        stringBuffer.append(string);
        switch (this.state) {
            case 1: {
                stringBuffer.append("a");
                break;
            }
            case -1: {
                stringBuffer.append("d");
                break;
            }
            case 0: {
                stringBuffer.append("c");
            }
        }
        stringBuffer.append(string2);
        stringBuffer.append(NL);
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        for (int i = 0; i < this.lines.length; ++i) {
            n6 = this.lines[i].getState();
            if (n5 != Integer.MIN_VALUE && n6 != n5) {
                stringBuffer.append("---" + NL);
            }
            n5 = n6;
            switch (n6) {
                case 1: {
                    stringBuffer.append("> ");
                    stringBuffer.append(this.lines[i].getLine());
                    break;
                }
                case -1: {
                    stringBuffer.append("< ");
                    stringBuffer.append(this.lines[i].getLine());
                }
            }
            stringBuffer.append(NL);
        }
        if (stringBuffer.length() >= NL.length()) {
            stringBuffer.delete(stringBuffer.length() - NL.length(), stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    public int getOrgFirstLineNum() {
        if (this.original.length < 1) {
            return this.lines[0].getOrgLineNum();
        }
        return this.original[0].getOrgLineNum();
    }

    public int getOrgLastLineNum() {
        if (this.original.length < 1) {
            return this.lines[this.lines.length - 1].getOrgLineNum();
        }
        return this.original[this.original.length - 1].getOrgLineNum();
    }

    public int getModFirstLineNum() {
        if (this.modified.length < 1) {
            return this.lines[0].getModLineNum();
        }
        return this.modified[0].getModLineNum();
    }

    public int getModLastLineNum() {
        if (this.modified.length < 1) {
            return this.lines[this.lines.length - 1].getOrgLineNum();
        }
        return this.modified[this.modified.length - 1].getModLineNum();
    }
}

