/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.foolishmerge.diff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.foolishmerge.FoolishMergeUtils;
import jp.sourceforge.foolishmerge.diff.Delta;
import jp.sourceforge.foolishmerge.diff.LineDifference;
import jp.sourceforge.foolishmerge.diff.MergedDocument;

public class DocDifference {
    private List passed = new ArrayList();
    private boolean reverse = false;
    private LineDifference current = null;
    private LineDifference[] lines = null;
    private LineDifference[] original = null;
    private LineDifference[] modified = null;
    private String[] A = null;
    private String[] B = null;
    private String[] orgDoc = null;
    private String[] modDoc = null;
    private Delta[] deltas = null;
    private int lcs = Integer.MIN_VALUE;

    public DocDifference() {
    }

    public DocDifference(String[] stringArray, String[] stringArray2) {
        this.orgDoc = stringArray;
        this.modDoc = stringArray2;
        if (stringArray2.length >= stringArray.length) {
            this.A = stringArray;
            this.B = stringArray2;
        } else {
            this.A = stringArray2;
            this.B = stringArray;
            this.reverse = true;
        }
    }

    public LineDifference[] getLines() {
        return this.lines;
    }

    public LineDifference[] getOriginal() {
        return this.original;
    }

    public LineDifference[] getModified() {
        return this.modified;
    }

    public Delta[] getDeltas() {
        return this.deltas;
    }

    public String[] patch(String[] stringArray, int n) {
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        for (int i = 0; i < this.deltas.length; ++i) {
            n += this.deltas[i].patch(linkedList, n);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public MergedDocument merge(DocDifference docDifference) {
        MergedDocument mergedDocument = new MergedDocument(this.orgDoc);
        Delta[] deltaArray = this.deltas;
        Delta[] deltaArray2 = docDifference.getDeltas();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < deltaArray.length || n3 < deltaArray2.length) {
            if (n2 < deltaArray.length && deltaArray2.length <= n3) {
                n += mergedDocument.patch(deltaArray[n2], n);
                ++n2;
                continue;
            }
            if (deltaArray.length <= n2 && n3 < deltaArray2.length) {
                n += mergedDocument.patch(deltaArray2[n3], n);
                ++n3;
                continue;
            }
            if (deltaArray[n2].isConflict(deltaArray2[n3])) {
                n += mergedDocument.merge(deltaArray[n2], deltaArray2[n3], n);
                ++n2;
                ++n3;
                continue;
            }
            if (deltaArray[n2].compareTo(deltaArray2[n3]) <= 0) {
                n += mergedDocument.patch(deltaArray[n2], n);
                ++n2;
                continue;
            }
            n += mergedDocument.patch(deltaArray2[n3], n);
            ++n3;
        }
        return mergedDocument;
    }

    public String toString() {
        return FoolishMergeUtils.arrayToString(this.deltas);
    }

    public int getSameLineRate() {
        BigDecimal bigDecimal = new BigDecimal((double)(this.A.length + this.B.length));
        BigDecimal bigDecimal2 = new BigDecimal((double)(this.lcs * 2));
        BigDecimal bigDecimal3 = bigDecimal2.divide(bigDecimal, 2, 4);
        return bigDecimal3.multiply(new BigDecimal(100.0)).intValue();
    }

    public int getLCS() {
        return this.lcs;
    }

    int getM() {
        return this.A.length;
    }

    int getN() {
        return this.B.length;
    }

    void close() {
        Object object;
        LinkedList<LineDifference> linkedList = new LinkedList<LineDifference>();
        LinkedList<LineDifference> linkedList2 = new LinkedList<LineDifference>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        LinkedList<Object> linkedList4 = new LinkedList<Object>();
        LinkedList<Object> linkedList5 = new LinkedList<Object>();
        block5: for (object = this.current; object != null; object = ((LineDifference)object).getPrev()) {
            switch (((LineDifference)object).getState()) {
                case 1: {
                    linkedList.addFirst((LineDifference)object);
                    linkedList3.addFirst(object);
                    linkedList4.addFirst(object);
                    continue block5;
                }
                case -1: {
                    linkedList.addFirst((LineDifference)object);
                    linkedList2.addFirst((LineDifference)object);
                    linkedList4.addFirst(object);
                    continue block5;
                }
                case 0: {
                    linkedList.addFirst((LineDifference)object);
                    linkedList2.addFirst((LineDifference)object);
                    linkedList3.addFirst(object);
                    if (linkedList4.size() == 0) continue block5;
                    Delta delta = new Delta(linkedList4);
                    linkedList5.addFirst(delta);
                    linkedList4.clear();
                    continue block5;
                }
            }
        }
        if (linkedList4.size() != 0) {
            object = new Delta(linkedList4);
            linkedList5.addFirst(object);
        }
        this.lines = linkedList.toArray(new LineDifference[linkedList.size()]);
        this.original = linkedList2.toArray(new LineDifference[linkedList2.size()]);
        this.modified = linkedList3.toArray(new LineDifference[linkedList3.size()]);
        this.deltas = linkedList5.toArray(new Delta[linkedList5.size()]);
    }

    static DocDifference getEquals(int n) {
        DocDifference docDifference = new DocDifference();
        LineDifference[] lineDifferenceArray = new LineDifference[n + 1];
        for (int i = 0; i < docDifference.lines.length; ++i) {
            LineDifference lineDifference = new LineDifference(i, i);
            lineDifference.setState(0);
            lineDifferenceArray[i] = lineDifference;
        }
        docDifference.lines = lineDifferenceArray;
        docDifference.original = lineDifferenceArray;
        docDifference.modified = lineDifferenceArray;
        return docDifference;
    }

    void setLCS(int n) {
        this.lcs = n;
    }

    int snake(int n, int n2) {
        int n3 = n2 - n;
        this.move(n3, n2);
        while (n3 < this.A.length && n2 < this.B.length && this.A[n3].equals(this.B[n2])) {
            this.moveAslant(++n3, ++n2);
        }
        return n2;
    }

    private void move(int n, int n2) {
        if (this.reverse) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        this.current = new LineDifference(n, n2);
        this.setPrev(this.current, n, n2 - 1, 1);
        this.setPrev(this.current, n - 1, n2, -1);
        this.setLine(this.current);
        this.passed.add(this.current);
    }

    private void moveAslant(int n, int n2) {
        if (this.reverse) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        this.current = new LineDifference(n, n2);
        this.setPrev(this.current, n - 1, n2 - 1, 0);
        this.setLine(this.current);
        this.passed.add(this.current);
    }

    private void setPrev(LineDifference lineDifference, int n, int n2, int n3) {
        if (lineDifference.getPrev() != null) {
            return;
        }
        for (int i = 0; i < this.passed.size(); ++i) {
            LineDifference lineDifference2 = (LineDifference)this.passed.get(i);
            if (lineDifference2.getX() != n || lineDifference2.getY() != n2) continue;
            lineDifference.setPrev(lineDifference2);
            lineDifference.setState(n3);
            break;
        }
    }

    private void setLine(LineDifference lineDifference) {
        int n = lineDifference.getX();
        int n2 = lineDifference.getY();
        int n3 = lineDifference.getState();
        if (n3 == Integer.MIN_VALUE) {
            return;
        }
        if (n3 == 1) {
            lineDifference.setLine(this.modDoc[n2 - 1]);
        } else {
            lineDifference.setLine(this.orgDoc[n - 1]);
        }
    }
}

