/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.foolishmerge.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.foolishmerge.FoolishMergeUtils;
import jp.sourceforge.foolishmerge.diff.Delta;
import jp.sourceforge.foolishmerge.diff.MergedDelta;

public class MergedDocument {
    private List doc = null;
    private boolean conflict = false;

    public MergedDocument(String[] stringArray) {
        this.doc = new LinkedList<String>(Arrays.asList(stringArray));
    }

    public int patch(Delta delta, int n) {
        int n2 = delta.patch(this.doc, n);
        return n2;
    }

    public int merge(Delta delta, Delta delta2, int n) {
        int n2 = 0;
        if (Arrays.equals(delta.getModLines(), delta2.getModLines())) {
            n2 = delta.patch(this.doc, n);
        } else if (delta.getState() == 1 && delta2.getState() == 1) {
            n2 = delta.patch(this.doc, n);
            n2 += delta2.patch(this.doc, n + n2);
        } else {
            this.conflict = true;
            MergedDelta mergedDelta = new MergedDelta(delta, delta2);
            n2 = mergedDelta.patch(this.doc, n);
        }
        return n2;
    }

    public String[] getLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.doc.size(); ++i) {
            Object e = this.doc.get(i);
            if (e instanceof MergedDelta) {
                MergedDelta mergedDelta = (MergedDelta)e;
                String[] stringArray = mergedDelta.getMergedLines();
                for (int j = 0; j < stringArray.length; ++j) {
                    arrayList.add(stringArray[j]);
                }
                continue;
            }
            arrayList.add((String)e);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return FoolishMergeUtils.arrayToString(this.getLines());
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public void setFilename(String string) {
        for (int i = 0; i < this.doc.size(); ++i) {
            Object e = this.doc.get(i);
            if (!(e instanceof MergedDelta)) continue;
            MergedDelta mergedDelta = (MergedDelta)e;
            mergedDelta.setFilename(string);
        }
    }

    public void setRevision(String string) {
        for (int i = 0; i < this.doc.size(); ++i) {
            Object e = this.doc.get(i);
            if (!(e instanceof MergedDelta)) continue;
            MergedDelta mergedDelta = (MergedDelta)e;
            mergedDelta.setRevision(string);
        }
    }
}

