package sample;

import jp.sourceforge.foolishmerge.DiffUtils;
import jp.sourceforge.foolishmerge.diff.MergedDocument;

/**
 * 差分取得/マージサンプル。
 */
public class Sample {

	public static void main(String[] args) {
		try {
			// サンプル1
			// コンフリクトなしの場合。
			log("[[[[[ SAMPLE1 ]]]]]\n");
			not_conflict();

			// サンプル2
			// コンフリクトありの場合。
			log("[[[[[ SAMPLE2 ]]]]]\n");
			conflict();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void not_conflict() {
		// 編集元文書
		String org =
	/* 1 */	"#include <stdio.h>\n" +
	/* 2 */	"\n" +
	/* 3 */	"main()\n" +
	/* 4 */	"{\n" +
	/* 5 */	"    printf(\"hello, world\\n\");\n" +
	/* 6 */	"}\n";

		// 編集後文書1
		String rev1 =
	/* 1 */	"#include <stdio.h>\n" +
	/* > */	"#include <stdlib.h>\n" +
	/* 2 */	"\n" +
	/* 3 */	"main()\n" +
	/* 4 */	"{\n" +
	/* > */	"    int i;\n" +
	/* > */	"    i = abs(-10);\n" +
	/* 5 */	"    printf(\"hello, world\\n\");\n" +
	/* > */	"    printf(\"i = %d\\n\", i);\n" +
	/* 6 */	"}\n";

		// 編集後文書2
		String rev2 =
	/* 1 */	"#include <stdio.h>\n" +
	/* 2 */	"\n" +
	/* 3 */	"main()\n" +
	/* 4 */	"{\n" +
	/* 5 */	"    printf(\"hello, world\\n\");\n" +
	/* > */	"    printf(\"good by, world\\n\");\n" +
	/* 6 */	"}\n";

		// 差分1を生成。
		DiffUtils fdiff1 = new DiffUtils(org, rev1);
		// 差分2を生成。
		DiffUtils fdiff2 = new DiffUtils(org, rev2);

		log("/// 差分1 ///////////////////////");
		log(fdiff1 + "\n");
		log("/// 差分2 ///////////////////////");
		log(fdiff2 + "\n");

		// 差分をマージ。
		MergedDocument merged = fdiff1.merge(fdiff2);

		log("/// 差分1 + 差分2 ///////////////");
		log(merged + "\n");

		log("(コンフリクトフラグ) " + merged.isConflict() + "\n");
	}

	private static void conflict() {
		// 編集元文書
		String org =
	/* 1 */	"#include <stdio.h>\n" +
	/* 2 */	"\n" +
	/* 3 */	"main()\n" +
	/* 4 */	"{\n" +
	/* 5 */	"    printf(\"hello, world\\n\");\n" +
	/* 6 */	"}\n";

		// 編集後文書1
		String rev1 =
	/* 1 */	"#include <stdio.h>\n" +
	/* 2 */	"\n" +
	/* 3 */	"main()\n" +
	/* 4 */	"{\n" +
	/**5**/	"    printf(\"good by, world\\n\");\n" +
	/* 6 */	"}\n";

		// 編集後文書2
		String rev2 =
	/* 1 */	"#include <stdio.h>\n" +
	/* 2 */	"\n" +
	/* 3 */	"main()\n" +
	/* 4 */	"{\n" +
	/**5**/	"    printf(\"hello, FoolishMerge\\n\");\n" +
	/* 6 */	"}\n";

		// 差分1を生成。
		DiffUtils fdiff1 = new DiffUtils(org, rev1);
		// 差分2を生成。
		DiffUtils fdiff2 = new DiffUtils(org, rev2);

		log("/// 差分1 ///////////////////////");
		log(fdiff1 + "\n");
		log("/// 差分2 ///////////////////////");
		log(fdiff2 + "\n");

		// 差分をマージ。
		MergedDocument merged = fdiff1.merge(fdiff2);
		log("/// 差分1 + 差分2 ///////////////");
		log(merged + "\n");

		log("/// ファイル名 リビジョン付き ///");
		merged.setFilename("hello.c");
		merged.setRevision("1.3");
		log(merged + "\n");

		log("(コンフリクトフラグ) " + merged.isConflict() + "\n");
	}

	private static void log(Object msg) {
		System.out.println(msg);
	}

}
