package jp.sourceforge.foolishmerge;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * 例外クラス。
 */
public class FoolishMergeException extends RuntimeException {

	/**
	 * 原因
	 */
	private Throwable cause = null;

	/**
	 * 詳細メッセージに null を使用して、新しい実行時例外を構築する。
	 */
	public FoolishMergeException() {
		super();
	}

	/**
	 * 指定された詳細メッセージを使用して、新しい実行時例外を構築する。 
	 * 
	 * @param message メッセージ
	 */
	public FoolishMergeException(String message) {
		super(message);
	}

	/**
	 * 指定された詳細メッセージおよび原因を使用して新しい実行時例外を構築する。 
	 * 
	 * @param message メッセージ
	 * @param cause 原因
	 */
	public FoolishMergeException(String message, Throwable cause) {
		super(message);
		this.cause = cause;
	}

	/**
	 * 指定された原因を使用して新しい実行時例外を構築する。 
	 * 
	 * @param cause 原因
	 */
	public FoolishMergeException(Throwable cause) {
		this.cause = cause;
	}

	/**
	 * 原因を取得する。
	 * 
	 * @return 原因
	 */
	public Throwable getCause() {
		return cause;
	}

	/**
	 * メッセージを取得する。
	 * 
	 * @return メッセージ
	 */
	public String getMessage() {
		if (cause == null) {
			// 原因がない場合はそのままメッセージを返す。
			return super.getMessage();
		} else {
			// 原因がある場合は原因のメッセージと結合して返す。
			return super.getMessage() + cause.toString();
		}
	}

	/**
	 * スタックトレースを出力する。
	 */
	public void printStackTrace() {
		super.printStackTrace(System.err);
	}

	/**
	 * スタックトレースを出力する。
	 * 
	 * @param ps プリントストリーム
	 */
	public void printStackTrace(PrintStream ps) {
		if (cause == null) {
			// 原因がない場合はそのままスタックトレースを出力。
			super.printStackTrace(ps);
		} else {
			// 原因がある場合は原因のスタックトレースも出力。
			super.printStackTrace(ps);
			ps.print("Caused by: ");
			cause.printStackTrace(ps);
		}
	}

	/**
	 * スタックトレースを出力する。
	 * 
	 * @param pw プリントライタ
	 */
	public void printStackTrace(PrintWriter pw) {
		if (cause == null) {
			// 原因がない場合はそのままスタックトレースを出力。
			super.printStackTrace(pw);
		} else {
			// 原因がある場合は原因のスタックトレースも出力。
			super.printStackTrace(pw);
			pw.print("Caused by: ");
			cause.printStackTrace(pw);
		}
	}

}
