package jp.sourceforge.foolishmerge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/**
 * ユーティリティクラス。
 */
public class FoolishMergeUtils {

	/**
	 * 改行コード
	 */
	private static final String NL = FoolishMergeConfig.getLineSeparator();

	/**
	 * 配列を文字列に変換する。
	 * 
	 * @param array 配列
	 * @return 配列を結合した文字列
	 */
	public static String arrayToString(Object[] array) {
		// バッファを生成。
		StringBuffer buf = new StringBuffer();

		// 配列の要素をバッファに追加。
		for (int i = 0; i < array.length; i++) {
			buf.append(array[i].toString() + NL);
		}

		// 末尾の改行を削除。 
		if (buf.length() >= NL.length()) {
			buf.delete(buf.length() - NL.length(), buf.length());
		}

		// バッファの文字列を返す。
		return buf.toString();
	}

	/**
	 * 文字列を改行で分割した配列に変換する。
	 * 
	 * @param str 文字列
	 * @return 文字列を改行で分割した配列
	 */
	public static String[] stringToArray(String str) {
		// バッファを生成。
		List buf = new ArrayList();

		// 文字列からリーダを生成。
		StringReader reader = new StringReader(str);
		BufferedReader bufReader = new BufferedReader(reader);
		String line = null;

		try {
			// １行づつ読み込んでバッファに追加。
			while ((line = bufReader.readLine()) != null) {
				buf.add(line);
			}
		} catch (IOException e) {
			throw new FoolishMergeException(e);
		}

		// バッファを配列に変換して返す。
		return (String[]) buf.toArray(new String[buf.size()]);
	}

}
