/**
 * Competency rule config.
 *
 * @module     tool_lp/competencyruleconfig
 * @copyright  2015 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/competencyruleconfig",["jquery","core/notification","core/templates","tool_lp/dialogue","tool_lp/competency_outcomes","core/str"],(function($,Notification,Templates,Dialogue,Outcomes,Str){var RuleConfig=function(tree,rulesModules){this._eventNode=$("<div></div>"),this._tree=tree,this._rulesModules=rulesModules,this._setUp()};return RuleConfig.prototype._competency=null,RuleConfig.prototype._eventNode=null,RuleConfig.prototype._outcomesOption=null,RuleConfig.prototype._popup=null,RuleConfig.prototype._ready=null,RuleConfig.prototype._rules=null,RuleConfig.prototype._rulesModules=null,RuleConfig.prototype._tree=null,RuleConfig.prototype._afterChange=function(){this._isValid()?this._find('[data-action="save"]').prop("disabled",!1):this._find('[data-action="save"]').prop("disabled",!0)},RuleConfig.prototype._afterRuleConfigChange=function(e,rule){rule==this._getRule()&&this._afterChange()},RuleConfig.prototype._afterRender=function(){var self=this;self._find('[name="outcome"]').on("change",(function(){self._switchedOutcome()})).trigger("change"),self._find('[name="rule"]').on("change",(function(){self._switchedRule()})).trigger("change"),self._find('[data-action="save"]').on("click",(function(){self._trigger("save",self._getConfig()),self.close()})),self._find('[data-action="cancel"]').on("click",(function(){self.close()}))},RuleConfig.prototype.canBeConfigured=function(){var can=!1;return $.each(this._rules,(function(index,rule){rule.canConfig()&&(can=!0)})),can},RuleConfig.prototype.close=function(){this._popup.close(),this._popup=null},RuleConfig.prototype.display=function(){var self=this;return!!self._competency&&$.when(Str.get_string("competencyrule","tool_lp"),self._render()).then((function(title,render){self._popup=new Dialogue(title,render[0],self._afterRender.bind(self))})).fail(Notification.exception)},RuleConfig.prototype._find=function(selector){return $(this._popup.getContent()).find(selector)},RuleConfig.prototype._getApplicableOutcomesOptions=function(){var self=this,options=[];return $.each(self._outcomesOption,(function(index,outcome){options.push({code:outcome.code,name:outcome.name,selected:outcome.code==self._competency.ruleoutcome})})),options},RuleConfig.prototype._getApplicableRulesOptions=function(){var self=this,options=[];return $.each(self._rules,(function(index,rule){rule.canConfig()&&options.push({name:self._getRuleName(rule.getType()),type:rule.getType(),selected:rule.getType()==self._competency.ruletype})})),options},RuleConfig.prototype._getConfig=function(){var rule=this._getRule();return{ruletype:rule?rule.getType():null,ruleconfig:rule?rule.getConfig():null,ruleoutcome:this._getOutcome()}},RuleConfig.prototype._getOutcome=function(){return this._find('[name="outcome"]').val()},RuleConfig.prototype._getRule=function(){var result,type=this._find('[name="rule"]').val();return $.each(this._rules,(function(index,rule){rule.getType()!=type||(result=rule)})),result},RuleConfig.prototype._getRuleName=function(type){var name;return $.each(this._rulesModules,(function(index,modInfo){modInfo.type!=type||(name=modInfo.name)})),name},RuleConfig.prototype._initOutcomes=function(){var self=this;return Outcomes.getAll().then((function(outcomes){self._outcomesOption=outcomes}))},RuleConfig.prototype._initRules=function(){var self=this,promises=[];return $.each(self._rules,(function(index,rule){var promise=rule.init().then((function(){rule.setTargetCompetency(self._competency),rule.on("change",self._afterRuleConfigChange.bind(self))}),(function(){return self._rules.splice(index,1),$.when()}));promises.push(promise)})),$.when.apply($.when,promises)},RuleConfig.prototype._isValid=function(){var outcome=this._getOutcome(),rule=this._getRule();return outcome==Outcomes.NONE||!!rule&&rule.isValid()},RuleConfig.prototype.on=function(type,handler){this._eventNode.on(type,handler)},RuleConfig.prototype._preRender=function(){return this.ready()},RuleConfig.prototype.ready=function(){return this._ready.promise()},RuleConfig.prototype._render=function(){var self=this;return this._preRender().then((function(){var config;self.canBeConfigured()?((config={}).outcomes=self._getApplicableOutcomesOptions(),config.rules=self._getApplicableRulesOptions()):config=!1;var context={competencyshortname:self._competency.shortname,config:config};return Templates.render("tool_lp/competency_rule_config",context)}))},RuleConfig.prototype.setTargetCompetencyId=function(competencyId){var self=this;self._competency=self._tree.getCompetency(competencyId),$.each(self._rules,(function(index,rule){rule.setTargetCompetency(self._competency)}))},RuleConfig.prototype._setUp=function(){var self=this,promises=[],modules=[];self._ready=$.Deferred(),self._rules=[],$.each(self._rulesModules,(function(index,rule){modules.push(rule.amd)})),require(modules,(function(){$.each(arguments,(function(index,Module){var rule=new Module(self._tree);self._rules.push(rule)})),promises.push(self._initRules()),promises.push(self._initOutcomes()),$.when.apply($.when,promises).always((function(){self._ready.resolve()}))}))},RuleConfig.prototype._switchedOutcome=function(){if(this._getOutcome()==Outcomes.NONE)return this._find('[data-region="rule-type"]').hide().find('[name="rule"]').val(-1),this._find('[data-region="rule-config"]').empty().hide(),void this._afterChange();this._find('[data-region="rule-type"]').show(),this._find('[data-region="rule-config"]').show(),this._afterChange()},RuleConfig.prototype._switchedRule=function(){var self=this,container=self._find('[data-region="rule-config"]'),rule=self._getRule();if(!rule)return container.empty().hide(),void self._afterChange();rule.injectTemplate(container).then((function(){container.show()})).always((function(){self._afterChange()})).catch((function(){container.empty().hide()}))},RuleConfig.prototype._trigger=function(type,data){this._eventNode.trigger(type,[data])},RuleConfig}));

//# sourceMappingURL=competencyruleconfig.min.js.map