/**
 * AJAX helper for the inline editing a value.
 *
 * This script is automatically included from template core/inplace_editable
 * It registers a click-listener on [data-inplaceeditablelink] link (the "inplace edit" icon),
 * then replaces the displayed value with an input field. On "Enter" it sends a request
 * to web service core_update_inplace_editable, which invokes the specified callback.
 * Any exception thrown by the web service (or callback) is displayed as an error popup.
 *
 * @module     core/inplace_editable
 * @copyright  2016 Marina Glancy
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("core/inplace_editable",["jquery","core/ajax","core/templates","core/notification","core/str","core/config","core/url","core/form-autocomplete","core/pending"],(function($,ajax,templates,notification,str,cfg,url,autocomplete,Pending){return $("body").on("click keypress","[data-inplaceeditable] [data-inplaceeditablelink]",(function(e){if("keypress"!==e.type||13===e.keyCode){var editingEnabledPromise=new Pending("autocomplete-start-editing");e.stopImmediatePropagation(),e.preventDefault();var mainelement=$(this).closest("[data-inplaceeditable]"),updateValue=function(mainelement,value){var pendingId=[mainelement.attr("data-itemid"),mainelement.attr("data-component"),mainelement.attr("data-itemtype")].join("-"),pendingPromise=new Pending(pendingId);!function(element){element.addClass("updating");var spinner=element.find("img.spinner");spinner.length?spinner.show():(spinner=$("<img/>").attr("src",url.imageUrl("i/loading_small")).addClass("spinner").addClass("smallicon"),element.append(spinner))}(mainelement),ajax.call([{methodname:"core_update_inplace_editable",args:{itemid:mainelement.attr("data-itemid"),component:mainelement.attr("data-component"),itemtype:mainelement.attr("data-itemtype"),value:value}}])[0].then((function(data){return templates.render("core/inplace_editable",data).then((function(html,js){var oldvalue=mainelement.attr("data-value"),newelement=$(html);templates.replaceNode(mainelement,newelement,js),newelement.find("[data-inplaceeditablelink]").focus(),newelement.trigger({type:"updated",ajaxreturn:data,oldvalue:oldvalue})}))})).then((function(){return pendingPromise.resolve()})).fail((function(ex){var element,e=$.Event("updatefailed",{exception:ex,newvalue:value});(element=mainelement).removeClass("updating"),element.find("img.spinner").hide(),M.util.js_complete(pendingId),mainelement.trigger(e),e.isDefaultPrevented()||notification.exception(ex)}))},turnEditingOff=function(el){el.find("input").off(),el.find("select").off(),el.html(el.attr("data-oldcontent")),el.removeAttr("data-oldcontent"),el.removeClass("inplaceeditingon"),el.find("[data-inplaceeditablelink]").focus()},uniqueId=function uniqueId(prefix,idlength){var i,uniqid=prefix;for(i=0;i<idlength;i++)uniqid+=String(Math.floor(10*Math.random()));return 0===$("#"+uniqid).length?uniqid:uniqueId(prefix,idlength)};$("span.inplaceeditable.inplaceeditingon").each((function(){turnEditingOff($(this))})),function(el){el.addClass("inplaceeditingon"),el.attr("data-oldcontent",el.html());var type=el.attr("data-type"),options=el.attr("data-options");"toggle"===type?function(el,newvalue){turnEditingOff(el),updateValue(el,newvalue)}(el,options):"select"===type?function(el,options){var i,inputelement=$("<select></select>").attr("id",uniqueId("id_inplacevalue_",20)).addClass("custom-select"),lbl=$('<label class="accesshide">'+mainelement.attr("data-editlabel")+"</label>").attr("for",inputelement.attr("id"));for(i in options)inputelement.append($("<option>").attr("value",options[i].key).html(options[i].value));inputelement.val(el.attr("data-value")),el.html("").append(lbl).append(inputelement),inputelement.focus(),inputelement.select(),inputelement.on("keyup change focusout",(function(e){if(!cfg.behatsiterunning||"focusout"!==e.type){if("change"===e.type){var val=inputelement.val();turnEditingOff(el),updateValue(el,val)}("keyup"===e.type&&27===e.keyCode||"focusout"===e.type)&&turnEditingOff(el)}}))}(el,$.parseJSON(options)):"autocomplete"===type?function(el,args){var i,inputelement=$("<select></select>").attr("id",uniqueId("id_inplacevalue_",20)).addClass("form-autocomplete-original-select").addClass("custom-select"),lbl=$('<label class="accesshide">'+mainelement.attr("data-editlabel")+"</label>").attr("for",inputelement.attr("id")),options=args.options,attributes=args.attributes,saveelement=$('<a href="#"></a>'),cancelelement=$('<a href="#"></a>');for(i in options)inputelement.append($("<option>").attr("value",options[i].key).html(options[i].value));attributes.multiple&&inputelement.attr("multiple","true"),inputelement.val(JSON.parse(el.attr("data-value"))),str.get_string("savechanges","core").then((function(s){return templates.renderPix("e/save","core",s)})).then((function(html){saveelement.append(html)})).fail(notification.exception),str.get_string("cancel","core").then((function(s){return templates.renderPix("e/cancel","core",s)})).then((function(html){cancelelement.append(html)})).fail(notification.exception),el.html("").append(lbl).append(inputelement).append(saveelement).append(cancelelement),inputelement.focus(),inputelement.select(),autocomplete.enhance(inputelement,attributes.tags,attributes.ajax,attributes.placeholder,attributes.caseSensitive,attributes.showSuggestions,attributes.noSelectionString).then((function(){el.find("[role=combobox]").focus()})).fail(notification.exception),inputelement.on("keyup",(function(e){("keyup"===e.type&&27===e.keyCode||"focusout"===e.type)&&turnEditingOff(el)})),saveelement.on("click",(function(e){var val=JSON.stringify(inputelement.val());inputelement.empty(),turnEditingOff(el),updateValue(el,val),e.preventDefault()})),cancelelement.on("click",(function(e){inputelement.empty(),turnEditingOff(el),e.preventDefault()}))}(el,$.parseJSON(options)):function(el){str.get_string("edittitleinstructions").done((function(s){var instr=$('<span class="editinstructions">'+s+"</span>").attr("id",uniqueId("id_editinstructions_",20)),inputelement=$('<input type="text"/>').attr("id",uniqueId("id_inplacevalue_",20)).attr("value",el.attr("data-value")).attr("aria-describedby",instr.attr("id")).addClass("ignoredirty").addClass("form-control"),lbl=$('<label class="accesshide">'+mainelement.attr("data-editlabel")+"</label>").attr("for",inputelement.attr("id"));el.html("").append(instr).append(lbl).append(inputelement),inputelement.focus(),inputelement.select(),inputelement.on("keyup keypress focusout",(function(e){if(!cfg.behatsiterunning||"focusout"!==e.type){if("keypress"===e.type&&13===e.keyCode){var val=inputelement.val();turnEditingOff(el),updateValue(el,val)}("keyup"===e.type&&27===e.keyCode||"focusout"===e.type)&&turnEditingOff(el)}}))}))}(el)}(mainelement),editingEnabledPromise.resolve()}})),{}}));

//# sourceMappingURL=inplace_editable.min.js.map