/**
 * Implement an accessible aria tree widget, from a nested unordered list.
 * Based on http://oaa-accessibility.org/example/41/.
 *
 * @module     tool_lp/tree
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/tree",["jquery"],(function($){var SELECTORS_ITEM="[role=treeitem]",SELECTORS_GROUP="[role=treeitem]:has([role=group]), [role=treeitem][aria-owns], [role=treeitem][data-requires-ajax=true]",SELECTORS_CLOSED_GROUP="[role=treeitem]:has([role=group])[aria-expanded=false], [role=treeitem][aria-owns][aria-expanded=false], [role=treeitem][data-requires-ajax=true][aria-expanded=false]",SELECTORS_FIRST_ITEM="[role=treeitem]:first",SELECTORS_VISIBLE_ITEM="[role=treeitem]:visible",SELECTORS_UNLOADED_AJAX_ITEM="[role=treeitem][data-requires-ajax=true][data-loaded=false][aria-expanded=true]",Tree=function(selector,selectCallback){this.treeRoot=$(selector),this.treeRoot.data("activeItem",null),this.selectCallback=selectCallback,this.keys={tab:9,enter:13,space:32,pageup:33,pagedown:34,end:35,home:36,left:37,up:38,right:39,down:40,asterisk:106},this.initialiseNodes(this.treeRoot),this.setActiveItem(this.treeRoot.find(SELECTORS_FIRST_ITEM)),this.refreshVisibleItemsCache(),this.bindEventHandlers()};return Tree.prototype.registerEnterCallback=function(callback){this.enterCallback=callback},Tree.prototype.refreshVisibleItemsCache=function(){this.treeRoot.data("visibleItems",this.treeRoot.find(SELECTORS_VISIBLE_ITEM))},Tree.prototype.getVisibleItems=function(){return this.treeRoot.data("visibleItems")},Tree.prototype.setActiveItem=function(item){var currentActive=this.treeRoot.data("activeItem");item!==currentActive&&(currentActive&&(currentActive.attr("tabindex","-1"),currentActive.attr("aria-selected","false")),item.attr("tabindex","0"),item.attr("aria-selected","true"),this.treeRoot.data("activeItem",item),"function"==typeof this.selectCallback&&this.selectCallback(item))},Tree.prototype.isGroupItem=function(item){return item.is(SELECTORS_GROUP)},Tree.prototype.getGroupFromItem=function(item){var ariaowns=this.treeRoot.find("#"+item.attr("aria-owns")),plain=item.children("[role=group]");return ariaowns.length>plain.length?ariaowns:plain},Tree.prototype.isGroupCollapsed=function(item){return"false"===item.attr("aria-expanded")},Tree.prototype.isGroupCollapsible=function(item){return"false"!==item.attr("data-collapsible")},Tree.prototype.initialiseNodes=function(node){this.removeAllFromTabOrder(node),this.setAriaSelectedFalseOnItems(node);var thisTree=this;node.find(SELECTORS_UNLOADED_AJAX_ITEM).each((function(){var unloadedNode=$(this);thisTree.collapseGroup(unloadedNode),thisTree.expandGroup(unloadedNode)}))},Tree.prototype.removeAllFromTabOrder=function(node){node.find("*").attr("tabindex","-1"),this.getGroupFromItem($(node)).find("*").attr("tabindex","-1")},Tree.prototype.setAriaSelectedFalseOnItems=function(node){node.find(SELECTORS_ITEM).attr("aria-selected","false")},Tree.prototype.expandAllGroups=function(){var thisTree=this;this.treeRoot.find(SELECTORS_CLOSED_GROUP).each((function(){var groupNode=$(this);thisTree.expandGroup($(this)).done((function(){thisTree.expandAllChildGroups(groupNode)}))}))},Tree.prototype.expandAllChildGroups=function(item){var thisTree=this;this.getGroupFromItem(item).find(SELECTORS_CLOSED_GROUP).each((function(){var groupNode=$(this);thisTree.expandGroup($(this)).done((function(){thisTree.expandAllChildGroups(groupNode)}))}))},Tree.prototype.expandGroup=function(item){var promise=$.Deferred();if("false"!==item.attr("data-expandable")&&this.isGroupCollapsed(item))if("true"===item.attr("data-requires-ajax")&&"true"!==item.attr("data-loaded")){item.attr("data-loaded",!1);var moduleName=item.closest("[data-ajax-loader]").attr("data-ajax-loader"),thisTree=this,p=item.find("p");p.addClass("loading"),require([moduleName],(function(loader){loader.load(item).done((function(){item.attr("data-loaded",!0),thisTree.initialiseNodes(item),thisTree.finishExpandingGroup(item),p.removeClass("loading"),promise.resolve()}))}))}else this.finishExpandingGroup(item),promise.resolve();else promise.resolve();return promise},Tree.prototype.finishExpandingGroup=function(item){this.getGroupFromItem(item).removeAttr("aria-hidden"),item.attr("aria-expanded","true"),this.refreshVisibleItemsCache()},Tree.prototype.collapseGroup=function(item){this.isGroupCollapsible(item)&&!this.isGroupCollapsed(item)&&(this.getGroupFromItem(item).attr("aria-hidden","true"),item.attr("aria-expanded","false"),this.refreshVisibleItemsCache())},Tree.prototype.toggleGroup=function(item){"true"===item.attr("aria-expanded")?this.collapseGroup(item):this.expandGroup(item)},Tree.prototype.handleKeyDown=function(e){var item=$(e.target),currentIndex=this.getVisibleItems().index(item);if(!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey&&e.keyCode!=this.keys.tab))switch(e.keyCode){case this.keys.home:return this.getVisibleItems().first().focus(),void e.preventDefault();case this.keys.end:return this.getVisibleItems().last().focus(),void e.preventDefault();case this.keys.enter:var links=item.children("a").length?item.children("a"):item.children().not(SELECTORS_GROUP).find("a");return links.length?links.first().data("overrides-tree-activation-key-handler")?links.first().triggerHandler(e):"function"==typeof this.enterCallback?this.enterCallback(item):window.location.href=links.first().attr("href"):this.isGroupItem(item)&&this.toggleGroup(item,!0),void e.preventDefault();case this.keys.space:if(this.isGroupItem(item))this.toggleGroup(item,!0);else if(item.children("a").length){var firstLink=item.children("a").first();firstLink.data("overrides-tree-activation-key-handler")&&firstLink.triggerHandler(e)}return void e.preventDefault();case this.keys.left:var focusParent=function(tree){tree.getVisibleItems().filter((function(){return tree.getGroupFromItem($(this)).has(item).length})).focus()};return this.isGroupItem(item)?this.isGroupCollapsed(item)?focusParent(this):this.collapseGroup(item):focusParent(this),void e.preventDefault();case this.keys.right:return this.isGroupItem(item)&&(this.isGroupCollapsed(item)?this.expandGroup(item):this.getGroupFromItem(item).find(SELECTORS_ITEM).first().focus()),void e.preventDefault();case this.keys.up:if(currentIndex>0)this.getVisibleItems().eq(currentIndex-1).focus();return void e.preventDefault();case this.keys.down:if(currentIndex<this.getVisibleItems().length-1)this.getVisibleItems().eq(currentIndex+1).focus();return void e.preventDefault();case this.keys.asterisk:return this.expandAllGroups(),void e.preventDefault()}},Tree.prototype.handleClick=function(e){if(!(e.altKey||e.ctrlKey||e.shiftKey||e.metaKey)){var item=$(e.target).closest('[role="treeitem"]');item.is(e.currentTarget)&&(item.focus(),this.isGroupItem(item)&&this.toggleGroup(item))}},Tree.prototype.handleFocus=function(e){this.setActiveItem($(e.target))},Tree.prototype.bindEventHandlers=function(){this.treeRoot.on({click:this.handleClick.bind(this),keydown:this.handleKeyDown.bind(this),focus:this.handleFocus.bind(this)},SELECTORS_ITEM)},Tree}));

//# sourceMappingURL=tree.min.js.map