#include "stdafx.h"
#include "FWatchApp.hpp"
#include "resource.h"

#include "SettingInfo.hpp"
#include "Utility.hpp"

#include <assert.h>

ShowWindowType::ShowWindowType()
	: showWindowType_(ShowWindowType::NORMAL)
{
}

ShowWindowType::ShowWindowType(const int v_showWindowType)
	: showWindowType_(v_showWindowType)
{
	assert( v_showWindowType >= 0 && v_showWindowType <= 4 && "͈͊OłB" );
}

ShowWindowType::ShowWindowType(const ShowWindowType& v_other)
	: showWindowType_(v_other.showWindowType_)
{
}

ShowWindowType& ShowWindowType::operator=(const ShowWindowType& v_other)
{
	showWindowType_ = v_other.showWindowType_;
	return *this;
}

ShowWindowType::operator int() const
{
	return showWindowType_;
}

tstring ShowWindowType::getDescription() const
{
	return app.LoadString( IDS_SHOWINDOWTYPE_0 + showWindowType_ );
}

int ShowWindowType::getShowCommand() const
{
	int nShowCmd = SW_SHOWNORMAL;
	switch( showWindowType_ )
	{
	case 0:
		nShowCmd = SW_SHOWMINNOACTIVE;
		break;
	case 1:
		nShowCmd = SW_SHOWNORMAL;
		break;
	case 2:
		nShowCmd = SW_SHOWMAXIMIZED;
		break;
	case 3:
		nShowCmd = SW_HIDE;
		break;
	case 4:
		nShowCmd = SW_SHOWMINIMIZED;
		break;
	default:
		break;
	}
	return nShowCmd;
}

ShowWindowType ShowWindowType::valueOf(const int v_showWindowType)
{
	if (v_showWindowType >= 0 && v_showWindowType <= 4) {
		return ShowWindowType(v_showWindowType);
	}
	return ShowWindowType(1);
}

///////////////////////////////////////////////////////

CSettingInfo::CSettingInfo()
{
	watchFile_ = app.LoadString(IDS_DEFAULTPARAM_FINDNAME);
	action_ = app.LoadString(IDS_DEFAULTPARAM_ACTION);
	param_ = app.LoadString(IDS_DEFAULTPARAM_PARAM);

	showWindow_ = ShowWindowType::valueOf(app.LoadInteger(IDS_DEFAULTPARAM_SHOW));

	nWaitWrite_ = app.LoadInteger(IDS_DEFAULTPARAM_WAIT);
	nTolerance_ = app.LoadInteger(IDS_DEFAULTPARAM_TOLERANCE);
	nMaxProcess_ = app.LoadInteger(IDS_DEFAULTPARAM_MAXPROCESS);

	nMaxDepth_ = app.LoadInteger(IDS_DEFAULTPARAM_MAXDEPTH);
	nForceInterval_ = app.LoadInteger(IDS_DEFAULTPARAM_FORCEINTERVAL);
	nDirNotificationAPIRetryInterval_ = app.LoadInteger(IDS_DEFAULTPARAM_DIRNOTIFICATIONRETRYSPAN);
	nDirNotificationAPIExpirySpan_ = app.LoadInteger(IDS_DEFAULTPARAM_DIRNOTIFICATIONEXPIRYSPAN);
	bUsingNotificationAPI_ = app.LoadInteger(IDS_DEFAULTPARAM_USEDIRNOTIFICATION) != 0 ? true : false;

	nDeletePending_ = app.LoadInteger(IDS_DEFAULTPARAM_DELETEPENDING);

	logLevel_ = app.LoadInteger(IDS_DEFAULTPARAM_LOGLEVEL);
	appCurrentDir_ = app.LoadString(IDS_DEFAULTPARAM_CURDIR);

	nWatchDelay_ = 0;
	archiveOnly_ = false;
	notifyOnStart_ = false;

	watchDir_.clear();
	appName_.clear();
	log_.clear();
	persist_.clear();

	ignoreDuplicate_ = false;

	impersonate_ = false;
	impersonateUser_.clear();
	impersonateDomain_.clear();
	impersonatePassword_.clear();

	watchDisabled_ = false;
}

CSettingInfo::CSettingInfo( const CSettingInfo& v_other )
	: watchDir_(v_other.watchDir_)
	, watchFile_(v_other.watchFile_)
	, action_(v_other.action_)
	, appName_(v_other.appName_)
	, param_(v_other.param_)
	, log_(v_other.log_)
	, nWaitWrite_(v_other.nWaitWrite_)
	, nMaxProcess_(v_other.nMaxProcess_)
	, showWindow_(v_other.showWindow_)
	, nTolerance_ (v_other.nTolerance_)
	, nDeletePending_ (v_other.nDeletePending_)
	, nMaxDepth_(v_other.nMaxDepth_)
	, nForceInterval_(v_other.nForceInterval_)
	, nDirNotificationAPIRetryInterval_(v_other.nDirNotificationAPIRetryInterval_)
	, nDirNotificationAPIExpirySpan_(v_other.nDirNotificationAPIExpirySpan_)
	, bUsingNotificationAPI_(v_other.bUsingNotificationAPI_)
	, logLevel_(v_other.logLevel_)
	, appCurrentDir_(v_other.appCurrentDir_)
	, persist_(v_other.persist_)
	, archiveOnly_(v_other.archiveOnly_)
	, notifyOnStart_(v_other.notifyOnStart_)
	, nWatchDelay_(v_other.nWatchDelay_)
	, ignoreDuplicate_(v_other.ignoreDuplicate_)
	, impersonate_(v_other.impersonate_)
	, impersonateUser_(v_other.impersonateUser_)
	, impersonateDomain_(v_other.impersonateDomain_)
	, impersonatePassword_(v_other.impersonatePassword_)
	, watchDisabled_(v_other.watchDisabled_)
{
}

CSettingInfo& CSettingInfo::operator=( const CSettingInfo& v_other )
{
	if( &v_other  == this ) {
		return *this;
	}

	watchDir_ = v_other.watchDir_;
	watchFile_ = v_other.watchFile_;
	action_ = v_other.action_;
	appName_ = v_other.appName_;
	param_ = v_other.param_;
	log_ = v_other.log_;

	nWaitWrite_ = v_other.nWaitWrite_;
	nMaxProcess_ = v_other.nMaxProcess_;
	showWindow_ = v_other.showWindow_;
	nTolerance_ = v_other.nTolerance_;
	nDeletePending_ = v_other.nDeletePending_;

	nMaxDepth_ = v_other.nMaxDepth_;
	nForceInterval_ = v_other.nForceInterval_;
	nDirNotificationAPIRetryInterval_ = v_other.nDirNotificationAPIRetryInterval_;
	nDirNotificationAPIExpirySpan_ = v_other.nDirNotificationAPIExpirySpan_;
	bUsingNotificationAPI_ = v_other.bUsingNotificationAPI_;

	logLevel_ = v_other.logLevel_;
	appCurrentDir_ = v_other.appCurrentDir_;
	persist_ = v_other.persist_;

	archiveOnly_ = v_other.archiveOnly_;
	notifyOnStart_ = v_other.notifyOnStart_;
	nWatchDelay_ = v_other.nWatchDelay_;

	ignoreDuplicate_ = v_other.ignoreDuplicate_;

	impersonate_ = v_other.impersonate_;
	impersonateUser_ = v_other.impersonateUser_;
	impersonateDomain_ = v_other.impersonateDomain_;
	impersonatePassword_ = v_other.impersonatePassword_;

	watchDisabled_ = v_other.watchDisabled_;

	return *this;
}


/*!
 * lł邩肵܂B
 * \param rΏ
 * \return łtrueAłȂfalse
 */
bool CSettingInfo::operator==(const CSettingInfo& v_other) const
{
	return
		watchDir_ == v_other.watchDir_ && 
		watchFile_ == v_other.watchFile_ && 
		action_ == v_other.action_ && 
		appName_ == v_other.appName_ && 
		param_ == v_other.param_ && 
		log_ == v_other.log_ && 
		nWaitWrite_ == v_other.nWaitWrite_ && 
		nMaxProcess_ == v_other.nMaxProcess_ && 
		showWindow_ == v_other.showWindow_ && 
		nTolerance_ == v_other.nTolerance_ && 
		nDeletePending_ == v_other.nDeletePending_ && 
		nMaxDepth_ == v_other.nMaxDepth_ && 
		nForceInterval_ == v_other.nForceInterval_ && 
		nDirNotificationAPIRetryInterval_ == v_other.nDirNotificationAPIRetryInterval_ && 
		nDirNotificationAPIExpirySpan_ == v_other.nDirNotificationAPIExpirySpan_ && 
		bUsingNotificationAPI_ == v_other.bUsingNotificationAPI_ && 
		logLevel_ == v_other.logLevel_ && 
		appCurrentDir_ == v_other.appCurrentDir_ && 
		persist_ == v_other.persist_ && 
		archiveOnly_ == v_other.archiveOnly_ && 
		notifyOnStart_ == v_other.notifyOnStart_ && 
		nWatchDelay_ == v_other.nWatchDelay_ && 
		ignoreDuplicate_ == v_other.ignoreDuplicate_ && 
		impersonate_ == v_other.impersonate_ && 
		impersonateUser_ == v_other.impersonateUser_ && 
		impersonateDomain_ == v_other.impersonateDomain_ && 
		impersonatePassword_ == v_other.impersonatePassword_ && 
		watchDisabled_ == v_other.watchDisabled_;
}

/*!
 * lłȂ肵܂B
 * \param rΏ
 * \return łfalseAłȂtrue
 */
bool CSettingInfo::operator!=(const CSettingInfo& v_other) const
{
	return !(*this == v_other);
}

CSettingInfo::~CSettingInfo()
{
}

