<?php

###############################################################################
# chinese_traditional_utf-8.php
#
# Last Modified: 2006-12-12
# Version: 1.4.1
#
# This is the Chinese Simplified (UTF-8) language set for GeekLog 1.4.1
#
# Copyright (C) 2003 Samuel M. Stone
# sam@stonemicro.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'UTF-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '作者︰',
    2 => '讀整文',
    3 => '個評論',
    4 => '編輯',
    5 => '投票',
    6 => '結果',
    7 => '投票結果',
    8 => '投票',
    9 => '管理者功能︰',
    10 => '提交物',
    11 => '文章',
    12 => '組件',
    13 => '主題',
    14 => '連結',
    15 => '事件',
    16 => '投票',
    17 => '用戶',
    18 => 'SQL 質問',
    19 => '退出',
    20 => '用戶訊息︰',
    21 => '用戶名',
    22 => '用戶識別號',
    23 => '安全等級',
    24 => '匿名',
    25 => '回復',
    26 => '以下評論只屬張貼者個人觀點。',
    27 => '最近發表的',
    28 => '刪除',
    29 => '沒有評論。',
    30 => '舊的文章',
    31 => '允許的 HTML 標記:',
    32 => '錯誤，無效的用戶名',
    33 => '錯誤，不能寫系統日誌;',
    34 => '錯誤',
    35 => '退出',
    36 => '於',
    37 => '沒有文章',
    38 => '內容辛迪加',
    39 => '使新',
    40 => '你的服務器的 <tt>php.ini</tt> 裏設定為 <tt>register_globals = Off</tt>. 可是此軟件需要將 <tt>register_globals</tt> 設定成 <strong>on</strong>. 所以在你繼續以前，必須將它設定為<strong>on</strong>，然後重新開機.',
    41 => '客人',
    42 => '作者:',
    43 => '回復這個',
    44 => '母體',
    45 => 'MySQL 錯誤號碼',
    46 => 'MySQL 錯誤訊息',
    47 => '用戶功能',
    48 => '我的帳戶',
    49 => '風格選擇',
    50 => '錯誤的 SQL 句子',
    51 => '幫助',
    52 => '新',
    53 => '管理者首頁',
    54 => '不能打開文件。',
    55 => '錯處',
    56 => '投票',
    57 => '密碼',
    58 => '登入',
    59 => "沒有帳戶？<a href=\"{$_CONF['site_url']}/users.php?mode=new\">在此登記</a>",
    60 => '發表評論',
    61 => '新增帳戶',
    62 => '字',
    63 => '評論設定',
    64 => '把文章電郵給朋友',
    65 => '觀看可列印的版本',
    66 => '我的日曆',
    67 => '歡迎來到',
    68 => '首頁',
    69 => '聯絡',
    70 => '搜尋',
    71 => '投稿',
    72 => '網路資源',
    73 => '投票中心',
    74 => '日曆',
    75 => '進階搜索',
    76 => '本站統計數據',
    77 => '插件',
    78 => '即將發生的事',
    79 => '新鮮的東西',
    80 => '個新文章(',
    81 => '新的文章(',
    82 => ' 小時內)',
    83 => '評論',
    84 => '連結',
    85 => '最近四十八小時',
    86 => '沒有新的評論',
    87 => '最近兩個星期',
    88 => '沒有新的連結',
    89 => '沒有事發生',
    90 => '首頁',
    91 => '載入這頁用了',
    92 => '秒',
    93 => '版權',
    94 => '此網站所有的商標和版權屬於他們各自的所有者.',
    95 => '動力於',
    96 => '小組',
    97 => '字詞單',
    98 => '插件',
    99 => '文章',
    100 => '沒有新的文章',
    101 => '你的事件',
    102 => '本站的事件',
    103 => '資料庫備份',
    104 => '由',
    105 => '寄給用戶',
    106 => '採樣數:',
    107 => 'GL 版本測試',
    108 => '清除緩衝貯存區',
    109 => '報告濫用',
    110 => '報告此濫登文給網站管理員',
    111 => '看PDF 版本',
    112 => '登記用戶',
    113 => '使用說明',
    114 => '跡回',
    115 => '沒有新跡回的評論',
    116 => '跡回',
    117 => '目錄',
    118 => '請繼續看下頁',
    119 => "丟失了<a ref=\"{$_CONF['site_url']}/users.php?mode=getpassword\">密碼</a>?",
    120 => '永久聯結此評論',
    121 => '評論 (%d)',
    122 => '跡回 (%d)',
    123 => '准許用所有的HTML',
    124 => '點擊刪除所選的項目',
    125 => '你肯定要刪除所選的項目嗎？',
    126 => '選 或 不選 所有的項目'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => '發表評論',
    2 => '發表方式',
    3 => '退出',
    4 => '新增帳戶',
    5 => '用戶名',
    6 => '本站需要登入才可發表評論，請登入。如果你沒有帳戶，請使用下面的表格登記。',
    7 => '你最後發表的評論是在 ',
    8 => " 秒之前。本站限定至少 {$_CONF['commentspeedlimit']} 秒後才可再發表評論",
    9 => '評論',
    10 => '送出報告',
    11 => '發表評論',
    12 => '請填寫標題注評論欄',
    13 => '供你參考',
    14 => '預覽',
    15 => '報告這篇濫登文',
    16 => '標題',
    17 => '錯誤',
    18 => '重要的東西',
    19 => '請儘量不要離題。',
    20 => '盡可能回復別人的評論，而不是開新的評論。',
    21 => '為避免重複，發表評論之前請先讀別人所寫的。',
    22 => '請儘量用簡潔的標題。',
    23 => '我們不會公開你的電郵地址。',
    24 => '匿名用戶',
    25 => '你肯定想要報告此濫登文給網站管理員否?',
    26 => '%s 報告以下濫登的評論:',
    27 => '濫用報告'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => '用戶概況',
    2 => '用戶名',
    3 => '全名',
    4 => '密碼',
    5 => '電子郵件',
    6 => '首頁',
    7 => '小傳',
    8 => 'PGP 鑰匙',
    9 => '保存設定',
    10 => '給用戶的最後十個評論',
    11 => '沒有評論',
    12 => '用戶設定',
    13 => '每夜電郵文摘',
    14 => '這是個隨機的密碼，請儘快更改。要更改密碼請先登入系統，然後點擊帳戶訊息。',
    15 => "你在 {$_CONF['site_name']} 的帳戶已建立了。請使用以下訊息登入系統並保留這郵件作日後參考。",
    16 => '你的帳戶訊息',
    17 => '帳戶並不存在',
    18 => '你提供的不是一個有效的的電郵',
    19 => '用戶名或電郵已經存在',
    20 => '提供的不是一個有效的的電郵',
    21 => '錯誤',
    22 => "登記用 {$_CONF['site_name']} ！",
    23 => "在 {$_CONF['site_name']} 登記的用戶可享有的會員好處。他們可以用自己的名字發表評論和存取本站的資源。請注意本站<b><i>絕不會</i></b>公開用戶的電郵。",
    24 => '你的密碼將被送到你輸入的電郵信箱',
    25 => '忘記了你的密碼嗎？',
    26 => '請你輸入的用戶名和點擊電郵密碼，我們會發送一個新的密碼到你的電郵信箱。',
    27 => '現在就登記！',
    28 => '電郵密碼',
    29 => '退出時',
    30 => '登入時',
    31 => '需要登入才可用',
    32 => '署名',
    33 => '絕不會公開',
    34 => '這是你的真名',
    35 => '要改變請輸入密碼',
    36 => '開始是 http://',
    37 => '將會附加在你發表的評論上',
    38 => '你的簡介',
    39 => '你的公共 PGP 鑰匙',
    40 => '沒有主題圖示',
    41 => '願意主持',
    42 => '日期格式',
    43 => '文章限度',
    44 => '沒有組件',
    45 => '顯示設定',
    46 => '不包括的',
    47 => '新組件配置為',
    48 => '主題',
    49 => '文章裏沒有圖像',
    50 => '不要打鉤如果你不感興趣',
    51 => '只是新文章',
    52 => '預設值的是',
    53 => '每晚接收當日的文章',
    54 => '打鉤如果你不看這些主題或作者。',
    55 => '如果你沒有選擇，這意味你要用預設的組件。如果你選擇組件，所有預設的箱將被忽略。預設的東西會用粗筆劃顯示。',
    56 => '作者',
    57 => '顯示方式',
    58 => '排序方式',
    59 => '評論限制(個)',
    60 => '可顯示你的評論嗎？',
    61 => '最新或最舊的先？',
    62 => '預設是100',
    63 => '密碼已被發送，你會很快收到的。',
    64 => '評論設定',
    65 => '請嘗試再登入',
    66 => "你可能打錯了，請嘗試再登入。你是否<a href=\"{$_CONF['site_url']}/users.php?mode=new\">新用戶</a>？",
    67 => '成員自',
    68 => '記住我為',
    69 => '在登入以後，我們應該記住你多久？',
    70 => "定做 {$_CONF['site_name']} 的佈局和內容",
    71 => "一個 {$_CONF['site_name']} 的主要特點是你可以定做自己的佈局和內容，但是你必須是本站的會員。<a href=\"{$_CONF['site_url']}/users.php?mode=new\">在此登記</a>。如果你已經是登記，請使用左邊的區域登入。",
    72 => '題材',
    73 => '語言',
    74 => '改變本站外表',
    75 => '主題已電郵給',
    76 => '請只選擇你感興趣的主題，因為所有當日新張貼的文章將會電郵到你的信箱。',
    77 => '相片',
    78 => '你自己的圖片',
    79 => '要刪除圖片，在這裏打鉤',
    80 => '登入',
    81 => '發送電子郵件',
    82 => '用戶最近發表的十個文章為',
    83 => '用戶發表統計',
    84 => '文章總數︰',
    85 => '評論總數︰',
    86 => '尋找所有發表過的文章︰',
    87 => '你的登入名',
    88 => "有人(也許是你)要了新密碼 \"%s\" 於 {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\n若你真的要這樣作, 請你點擊以下聯結:\n\n",
    89 => "你若不想要這樣作, 請忽視這信息。這項事就將會被拋棄，而你的密碼就保持原有.\n\n",
    90 => '你可在下面輸入一個新的密碼。請注意你的舊密碼任然有效直到你將此表提交。',
    91 => '設定新密碼',
    92 => '輸入新密碼',
    93 => '你在 %d 秒鐘前剛要了一個新密碼. 此站規定最少要 %d 秒鐘以後才可再次要求新密碼。',
    94 => '將用戶 \'%s\' 刪除',
    95 => '單據下面的 \'刪除用戶\' 便將你在我們資料庫裏的用戶。請注意，你以其用戶所登載過的文章和評論不會刪除，可是會以無名作者的身份顯示。',
    96 => '刪除用戶',
    97 => '確定用戶刪除',
    98 => '你肯定要刪除你的用戶嗎? 其後你就不在能使用此站,除非你重新設定新用戶. 若你肯定的話請再次單據下面的 “刪除用戶”.',
    99 => '隱私選項於',
    100 => '管理員來信',
    101 => '准許管理員來信',
    102 => '用戶來信',
    103 => '准許其他用戶來信',
    104 => '顯示聯機狀況',
    105 => '讓在“誰在聯機”組件裏顯示',
    106 => '位置',
    107 => '顯示在你的公開簡介',
    108 => '肯定新密碼',
    109 => '再次輸入密碼',
    110 => '目前的密碼',
    111 => '請輸入目前的密碼',
    112 => '你已超過准許的登入次數. 情稍候再努力.',
    113 => '登入失敗',
    114 => '賬戶已被中止',
    115 => '你的賬戶已被中止, 你不能繼續登入. 請跟管理員聯絡.',
    116 => '等待啟動的賬戶',
    117 => '你的賬戶現在等待管理員的啟動. 在賬戶未批准以前, 你還不能登入.',
    118 => "你的 {$_CONF['site_name']} 賬戶已被啟動. 你可通過以下的url 用先前以電信寄給你的用戶名 (<username>) 和密碼來登入.",
    119 => '你若已忘記了你的密碼你可通過此 url 來要求一個新密碼',
    120 => '帳戶已被啟動',
    121 => '服務',
    122 => '對不起, 目前禁止新用戶登記',
    123 => "你是否 <a href=\"{$_CONF['site_url']}/users.php?mode=new\">新用戶</a>?",
    124 => '確認電信',
    125 => '你必需要輸入同樣的電信地址!',
    126 => '請重複輸入來確認',
    127 => '你必須輸入目前的密碼來做任何修改.',
    128 => '姓名',
    129 => '密碼 &amp; 電信',
    130 => '關於你',
    131 => '每日摘要選項',
    132 => '每日摘要功能',
    133 => '評論顯示',
    134 => '評論選項',
    135 => '<li>顯示評論的默認模式</li><li>顯示評論的默認次序</li><li>設定顯示評論的極大數字 – 默認數字是 100</li>',
    136 => '排除標題和作者',
    137 => '過濾文章內容',
    138 => '其他設定',
    139 => '版面和語言',
    140 => '<li>不要標題的圖標：勾此處就不會顯示標題的圖標</li><li>不要組件：勾了此處就不會顯示組件，只會顯示管理菜單，用戶菜單，和主題菜單<li>設定每頁顯示的極大文章數字</li><li>設定你的版面主題和喜歡的日期格式</li>',
    141 => '隱私設定',
    142 => '默認設定的是讓用戶和管理員們彼此可用電信交通而顯示你的在線狀態。取消這設定可保護你的隱私權.',
    143 => '過濾組件內容',
    144 => '顯示或隱藏組件',
    145 => '你的公開簡介',
    146 => '密碼和電信',
    147 => '修改你的用戶密碼，電信，和自動登入作用。你需要輸入你的密碼或電信地址兩次來避免錯誤。',
    148 => '用戶信息',
    149 => '修改要顯示給其他用戶的你的用戶信息.<li>你的簽名會顯示在你的評論或論壇標語的下面</li><li>個人簡歷是用來分享你自己的簡介</li><li>分享你得 PGP 鑰匙</li>',
    150 => '注意: 建議用Javascript 來提高功能',
    151 => '預覽',
    152 => '用戶和密碼',
    153 => '版面和語言',
    154 => '內容',
    155 => '隱私',
    156 => '刪除用戶'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '沒有新聞可顯示',
    2 => '沒有新文章可顯示。',
    3 => '這也許是真的沒有新主題或是你的 %s 設定得太過限制性。',
    4 => '今天頭條',
    5 => '下頁',
    6 => '上頁',
    7 => '第一',
    8 => '最終'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => '發送電子郵件時發生錯誤。請再嘗試。',
    2 => '電郵已送出。',
    3 => '請確定你在回復欄有一個可用的電子郵件地址。',
    4 => '請填寫你的名字、回復欄、主題和內容',
    5 => '錯誤：沒有這用戶。',
    6 => '發生錯誤。',
    7 => '用戶資料',
    8 => '用戶名',
    9 => '用戶名的 URL',
    10 => '發送郵件到',
    11 => '你的名字：',
    12 => '回復到：',
    13 => '主題：',
    14 => '內容：',
    15 => 'HTML 不會被翻譯。',
    16 => '發送郵件',
    17 => '把文章電郵給朋友',
    18 => '收件人名字',
    19 => '收件人電郵',
    20 => '寄件人名字',
    21 => '寄件人電郵',
    22 => '所有欄都要填寫',
    23 => "這電子郵件是由 %s (%s) 寄給你的，他認為你也許對這篇在 {$_CONF['site_url']} 的文章感興趣。這不是垃圾郵件(SPAM)，你的電郵地址也不會被紀錄。",
    24 => '關於這個文章的評論在',
    25 => '為幫助我們防止系統被濫用，你必須登入。',
    26 => '這個表格允許你送電子郵件到你選擇的用戶中。請填寫所有的欄位。',
    27 => '短信',
    28 => '%s 寫道：',
    29 => "來自於 {$_CONF['site_name']} 的每日文摘，給予：",
    30 => ' 每日的時事通訊，給予：',
    31 => '標題',
    32 => '日期',
    33 => '完整的文章在：',
    34 => '電郵結束',
    35 => '對不起，此用戶不願意收電信.'
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '進階搜尋',
    2 => '關鍵詞',
    3 => '主題',
    4 => '所有',
    5 => '類型',
    6 => '文章',
    7 => '評論',
    8 => '作者',
    9 => '所有',
    10 => '搜尋',
    11 => '搜尋結果',
    12 => '相配',
    13 => '搜尋結果：沒有相配的',
    14 => '沒有你尋找的東西︰',
    15 => '請再嘗試',
    16 => '標題',
    17 => '日期',
    18 => '作者',
    19 => "搜尋整個 {$_CONF['site_name']} 的新舊文章資料庫",
    20 => '日期',
    21 => '到',
    22 => '(日期格式 年-月-日 YYYY-MM-DD)',
    23 => '採樣數',
    24 => '找到',
    25 => '個相配在',
    26 => '個項目中，共用了',
    27 => '秒',
    28 => '沒有你所尋找的文章或評論',
    29 => '文章和評論的結果',
    30 => '沒有你所尋找的連結',
    31 => '沒有你所尋找的插件',
    32 => '事件',
    33 => 'URL',
    34 => '地點',
    35 => '所有日子',
    36 => '沒有你所尋找的事件',
    37 => '事件的結果',
    38 => '連結的結果',
    39 => '連結',
    40 => '事件',
    41 => '搜尋的關鍵詞最少要有三個字。',
    42 => '請使用 YYYY-MM-DD (年-月-日) 日期格式。',
    43 => '整個短語',
    44 => '所有字詞',
    45 => '其中任何字詞',
    46 => '以下',
    47 => '以上',
    48 => '作者',
    49 => '日期',
    50 => '採樣數',
    51 => '聯結',
    52 => '位置',
    53 => '文章結果',
    54 => '評論結果',
    55 => '句子',
    56 => '和',
    57 => '或',
    58 => '更多的結果 &gt;&gt;',
    59 => '結果',
    60 => '每頁',
    61 => '改進搜尋'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => '本站統計數據',
    2 => '系統點擊總數',
    3 => '文章(評論)總數',
    4 => '投票(獲得投票)總數',
    5 => '連結(點擊)總數',
    6 => '事件總數',
    7 => '採樣數最高的十個文章',
    8 => '文章標題',
    9 => '採樣數',
    10 => '看來本站沒有文章或是沒人觀看過本站的文章。',
    11 => '最多評論的十個文章',
    12 => '評論',
    13 => '看來本站沒有文章或是沒人評論過本站的文章。',
    14 => '最多人投票的十個選舉',
    15 => '投票標題',
    16 => '投票',
    17 => '看來本站沒有投票或是沒人投過票。',
    18 => '最多人點擊的十個連結',
    19 => '連結',
    20 => '點擊',
    21 => '看來本站沒有連結或是沒人點擊過本站的連結。',
    22 => '最多人寄出的十個文章',
    23 => '電郵',
    24 => '看來沒人寄出過本站的文章',
    25 => '頭十個跡回評論的文章',
    26 => '找不到跡回評論.',
    27 => '用戶人數',
    28 => '頭十項事件',
    29 => '事件',
    30 => '採樣數',
    31 => '看來此站無事件, 或沒有人曾點擊過任何事件.'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '有什麽是相關的',
    2 => '寄文章給朋友',
    3 => '可印的文章格式',
    4 => '文章選項',
    5 => 'PDF 文章版本'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => '你需要登入才可發表 %s ',
    2 => '登入',
    3 => '新用戶',
    4 => '發表一件事',
    5 => '發表一個連結',
    6 => '發表一個文章',
    7 => '你需要登入',
    8 => '發表',
    9 => '在本站發表東西時請跟隨以下建議...<ul><li>填寫所有的欄<li>提供完全和準確的訊息<li>再三檢查那些 URLs</ul>',
    10 => '標題',
    11 => '連結',
    12 => '開始日期',
    13 => '結束日期',
    14 => '地點',
    15 => '描述',
    16 => '如果是其他，請指定',
    17 => '類別',
    18 => '其他',
    19 => '讀這先',
    20 => '錯誤：缺少類別',
    21 => '當選擇"其他"請提供一個類別名',
    22 => '錯誤：缺少欄位',
    23 => '請填寫所有的欄位',
    24 => '你發表的已被保存了',
    25 => '你的 %s 已被保存了',
    26 => '限速',
    27 => '用戶名',
    28 => '主題',
    29 => '文章',
    30 => '你最後發表的是',
    31 => " 秒之前。本站限定至少 {$_CONF['speedlimit']} 秒後才可再發表",
    32 => '預覽',
    33 => '文章 預覽',
    34 => '退出',
    35 => '不准許 HTML 標記',
    36 => '發表模式',
    37 => "加事件到 {$_CONF['site_name']} 會將你的事件加到主日曆中，其他的用戶可隨意地把它加進自己的個人日曆。請<b>不要</b>把你的個人事件譬如生日和周年紀念加進去。<br><br>只要管理員批准你的事件它將出現在主日曆上。",
    38 => '加事件到',
    39 => '主日曆',
    40 => '個人日曆',
    41 => '結束時間',
    42 => '開始時間',
    43 => '整日的事件',
    44 => '地址 1',
    45 => '地址 2',
    46 => '城市/市鎮',
    47 => '州',
    48 => '郵政編碼',
    49 => '事件類型',
    50 => '編輯事件類型',
    51 => '地點',
    52 => '刪除',
    53 => '新加帳戶'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '要求認證',
    2 => '拒絕！不正確的登入資料',
    3 => '無效的密碼',
    4 => '用戶名：',
    5 => '密碼：',
    6 => '這頁只供授權人員使用。<br>所有存取將被記錄和檢查。',
    7 => '登入'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => '權力不足',
    2 => '你沒有權去編輯這個組件。',
    3 => '組件編輯器',
    4 => '讀取此文流時發現錯誤，請在你的錯誤記錄檔案 error.log 裏看細節.',
    5 => '組件標題',
    6 => '主題',
    7 => '所有',
    8 => '組件安全水平',
    9 => '組件次序',
    10 => '組件類型',
    11 => '入口組件',
    12 => '正常組件',
    13 => '入口組件選項',
    14 => '文流 RDF 的 URL',
    15 => '最後的文流 RDF 更新',
    16 => '正常組件選項',
    17 => '組件內容',
    18 => '請填寫組件的標題和內容。',
    19 => '組件管理員',
    20 => '組件標題',
    21 => '組件安全水平',
    22 => '組件類型',
    23 => '組件次序',
    24 => '組件主題',
    25 => '點擊下面的組件可修改或刪除它，點擊上面的新組件可創造一個新的。',
    26 => '版面組件',
    27 => 'PHP 組件',
    28 => 'PHP 組件選項',
    29 => '組件函數',
    30 => '如果你想用自己的 PHP 函數組件，請在上面輸入函數的名字。為防止執行任性的編碼，PHP 組件函數名必須以 "phpblock_" 作開始 (e.g. phpblock_getweather)。請不要把空的圓括號 "()" 放在函數後。最後，建議你把所有的 PHP 組件放在 /path/to/geeklog/system/lib-custom.php 裏以方便系統升級。',
    31 => 'PHP 組件錯誤︰函數 %s 並不存在。',
    32 => '錯誤︰缺少欄位。',
    33 => '在入口組件你必須把 URL 輸入到 .rdf 檔案',
    34 => '在 PHP 組件你必須輸入標題和函數',
    35 => '在正常組件你必須輸入標題和內容',
    36 => '在版面組件你必須輸入內容',
    37 => '不適當的 PHP 組件函數名',
    38 => '為防止執行任性的編碼，PHP 組件函數名必須以 "phpblock_" 作開始 (e.g. phpblock_getweather)。',
    39 => '放在那邊',
    40 => '左',
    41 => '右',
    42 => '在本系統的預設組件你必須輸入組件標題和次序',
    43 => '只可是首頁',
    44 => '存取被拒絕',
    45 => "企圖存取不允許的組件已被記錄。請<a href=\"{$_CONF['site_admin_url']}/block.php\">反回組件管理員晝面</a>。",
    46 => '新組件',
    47 => '管理員首頁',
    48 => '組件名',
    49 => ' (不可有空隔和必須是唯一的)',
    50 => '求助文件的 URL',
    51 => '包括 http://',
    52 => '如果這裏留白，組件的求助文件圖示將不被顯示',
    53 => '使有效',
    54 => '保存',
    55 => '取消',
    56 => '刪除',
    57 => '下移組件',
    58 => '上移組件',
    59 => '移組件到右邊',
    60 => '移組件到左邊',
    61 => '無標題',
    62 => '文章限制',
    63 => '錯誤組件標題',
    64 => '你的標題不能空白或有HTML!',
    65 => '次序',
    66 => '自動標簽',
    67 => '打勾來准許自動標簽'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => '上篇文章',
    2 => '下篇文章',
    3 => '模式',
    4 => '發表模式',
    5 => '文章編輯器',
    6 => '沒有文章',
    7 => '作者',
    8 => '保存',
    9 => '預覽',
    10 => '取消',
    11 => '刪除',
    12 => 'ID',
    13 => '標題',
    14 => '主題',
    15 => '日期',
    16 => '文章簡介',
    17 => '文章內容',
    18 => '點擊次數',
    19 => '評論',
    20 => 'Ping',
    21 => '傳送 Ping',
    22 => '文章清單',
    23 => '點擊下面的文章編號可修改或刪除它，點擊下面的文章標題可觀看它，點擊上面的新文章可創造一個新的。',
    24 => '你選的用戶名以有人在用。請用另一個用戶名。',
    25 => '存續文章時發生錯誤',
    26 => '文章預覽',
    27 => '你若用 [unscaledX] 而不是[imageX], 圖像將會以原來的尺寸插入.',
    28 => '<p><b>預覽</b>: 預覽有圖像的文章的最好方法是將它存為草稿。用預覽按鈕來預覽沒有圖像的文章。',
    29 => '跡回',
    30 => '上載錯誤',
    31 => '你需要提供作者、標題和文章簡介！',
    32 => '頭條的',
    33 => '只可有一個頭條文章',
    34 => '草稿',
    35 => '是',
    36 => '否',
    37 => '更多來自於',
    38 => '更多發表於',
    39 => '電郵',
    40 => '存取被拒絕',
    41 => "企圖存取不允許的文章已被記錄。你可以以唯讀模式觀看下面文章。看完後請<a href=\"{$_CONF['site_admin_url']}/story.php\">反回文章管理員晝面</a>。",
    42 => "企圖存取不允許的文章已被記錄。請<a href=\"{$_CONF['site_admin_url']}/story.php\">反回文章管理員晝面</a>。",
    43 => '新文章',
    44 => '管理員首頁',
    45 => '存取權',
    46 => '<b>注意︰</b>如果你把日期改成將來，在那個日期前這篇文章將不會被發表。並且 意味著這篇文章不會包括在你的 RDF 標題內，在搜尋和統計頁中會被忽略。',
    47 => '圖像',
    48 => '圖像',
    49 => '右',
    50 => '左',
    51 => '請用特別格式的文字([imageX]、[imageX_right] 或 [imageX_left])來插入圖像， X 是你附加圖像的編號。注意︰你只可使用你附加的圖像否則你將無法保存你的文章。<BR><P><B>預覽</B>︰最佳預覽文章的方法是把文章保存成草稿而不是直擊預覽按鈕。只有沒有附加圖像時才用預覽按鈕。',
    52 => '刪除',
    53 => '沒有被使用。保存前，你必須把這個圖像包含在文章簡介或文章內容中。',
    54 => '附加圖像未被使用',
    55 => '保存你的文章時發生以下錯誤。請改正這些錯誤再保存',
    56 => '顯示主題圖示',
    57 => '看沒味縮小的圖像',
    58 => '有期文章管理',
    59 => '選項',
    60 => '定期',
    61 => '過期後自動存檔',
    62 => '過期後自動刪除',
    63 => '',
    64 => '',
    65 => '',
    66 => '',
    67 => '擴大內容編輯範圍',
    68 => '縮小內容編輯範圍',
    69 => '登高日期',
    70 => '工具列選擇',
    71 => '基本工具列',
    72 => '普通工具列',
    73 => '先進工具列',
    74 => '先進II 工具列',
    75 => '全部功能',
    76 => '出版選項',
    77 => '必須啟動Javascript 來用高級的編輯器。此選項可再config.php 關掉。',
    78 => '點擊<a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">這裏</a>來用預設值的編輯器',
    79 => '預覽',
    80 => '編輯器',
    81 => '出版選項',
    82 => '圖像處理',
    83 => '有期文章管理',
    84 => '權限',
    85 => '完全顯示',
    86 => '高等編輯器',
    87 => '文章統計'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '主題編輯器',
    2 => '主題編號',
    3 => '主題名',
    4 => '主題圖像',
    5 => '(不可有空隔)',
    6 => '刪除主題會同時刪除所有有關的文章和組件！',
    7 => '你需要提供主題編號和主題名！',
    8 => '主題管理員',
    9 => '點擊下面的主題可修改或刪除它，點擊上面的新主題可創造一個新的。在括號裏你將發現你的存取級別。',
    10 => '排序次序',
    11 => '文章 / 頁',
    12 => '存取被拒絕',
    13 => "企圖存取不允許的主題已被記錄。請<a href=\"{$_CONF['site_admin_url']}/topic.php\">反回主題管理員晝面</a>.",
    14 => '排序方法',
    15 => '按字母排序',
    16 => '預設是',
    17 => '新主題',
    18 => '管理員首頁',
    19 => '保存',
    20 => '取消',
    21 => '刪除',
    22 => '預設',
    23 => '用此主題作為新稿的預設主體',
    24 => '(*)',
    25 => '保存文件的題目',
    26 => '用此題目作保存文件的默認題目。只准許一個題目。',
    27 => '或上載主題圖像',
    28 => '最大',
    29 => '文件上載出了問題'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => '用戶編輯器',
    2 => '用戶編號',
    3 => '用戶名',
    4 => '全名',
    5 => '密碼',
    6 => '安全級別',
    7 => '電郵地址',
    8 => '首頁',
    9 => '(不可有空隔)',
    10 => '你需要提供用戶名、全名、安全級別和電郵地址。',
    11 => '用戶管理員',
    12 => '點擊下面的用戶可修改或刪除它，點擊上面的新用戶可創造一個新的。在下面的表格中輸入部份的用戶名、電郵地址或全名 (e.g.*son* or *.edu) ，可做簡單的尋找。',
    13 => '安全級別',
    14 => '登記日',
    15 => '新用戶',
    16 => '管理員首頁',
    17 => '改密碼',
    18 => '取消',
    19 => '刪除',
    20 => '保存',
    21 => '用戶名已經存在',
    22 => '錯誤',
    23 => '大量增加',
    24 => '大量輸入用戶',
    25 => '你可一次過輸入大量的用戶到志樂。輸入檔案必須是一個用 tab 分隔的文字檔案，欄位的順序是︰全名、用戶名、電郵地址。每一個被輸入的用戶將會收到一個以電子郵件發送的隨機密碼。檔案中每一行是一個用戶。沒遵守這些要求將造成問題，也許需要手動作業，請再三檢查你檔案！',
    26 => '尋找',
    27 => '結果範圍',
    28 => '在這裏打鉤可刪除這張圖片',
    29 => '路徑',
    30 => '輸入',
    31 => '新用戶',
    32 => '處理完成。輸入了 %d 個；%d 個失敗',
    33 => '遞交',
    34 => '錯誤︰你必須指定上載檔案。',
    35 => '最後一次登入',
    36 => '(從未)',
    37 => 'UID',
    38 => '小組目錄',
    39 => '密碼 (再次)',
    40 => '登記日期',
    41 => '最後登入日期',
    42 => '被禁止的',
    43 => '等待啟動',
    44 => '等待准許',
    45 => '有效的',
    46 => '用戶狀態',
    47 => '編輯',
    48 => '顯示管理組',
    49 => '管理組',
    50 => '打勾來准許過濾此組為管理組',
    51 => '在線日',
    52 => '<br>注: "在線日" 是從登記的第一天到最後一次登入.',
    53 => '登記過的',
    54 => '批量的刪除',
    55 => '這功能只會有效若你已在 config.php 裏設定為 <code>$_CONF[\'lastlogin\'] = true;</code>',
    56 => '請選你想要刪除的用戶種類，然後按 "更新名單". 然後, 取消那些你不想刪除的用戶，再按刪除. 請注意，你只會刪除你現在所看見的用戶。若有多頁，後頁不會刪除。',
    57 => '幻影用戶',
    58 => '短期用戶',
    59 => '老用戶',
    60 => '用戶登記超過 ',
    61 => ' 個月, 但未曾登入過.',
    62 => '用戶登記超過 ',
    63 => ' 個月, 然後在24小時內登入過, 但從此就未曾回來過.',
    64 => '正常用戶, 但已經沒有回來 ',
    65 => ' 個月.',
    66 => '更新名單',
    67 => '登記月數',
    68 => '在線時數',
    69 => '離線月數',
    70 => '無法刪除',
    71 => '刪除成功',
    72 => '為選任何要刪除的用戶',
    73 => '你肯定要將所選的用戶永久刪除嗎？',
    74 => '最近用戶',
    75 => '在最近',
    76 => ' 月內登記的用戶。'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => '批准',
    2 => '刪除',
    3 => '編輯',
    4 => '簡要描述',
    10 => '標題',
    11 => '開始日期',
    12 => 'URL',
    13 => '類別',
    14 => '日期',
    15 => '主題',
    16 => '用戶名',
    17 => '全名',
    18 => '電子郵件',
    34 => '命令和控制',
    35 => '已遞交的文章',
    36 => '已遞交的連結',
    37 => '已遞交的事件',
    38 => '遞交',
    39 => '此時沒有遞交的東西',
    40 => '申請的用戶'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} 郵件程式",
    2 => '寄件人',
    3 => '回復到',
    4 => '主題',
    5 => '內容',
    6 => '收件人︰',
    7 => '所有用戶',
    8 => '管理員',
    9 => '選項',
    10 => 'HTML',
    11 => '迫切的訊息！',
    12 => '發送',
    13 => '重設',
    14 => '忽略用戶設定',
    15 => '錯誤，當發送到︰',
    16 => '訊息已發送到︰',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>發送其它信件</a>",
    18 => '收件人',
    19 => '注意︰如果你希望發送訊息到本站所有的成員，請在小組選擇欄位中選擇 Logged-in Users group。',
    20 => "已發送 <successcount> 個訊息，有 <failcount> 個不能發送。發送的細節在下面。如不想看細節，你可<a href=\"{$_CONF['site_admin_url']}/mail.php\">發送其它訊息</a> 或 <a href=\"{$_CONF['site_admin_url']}/moderation.php\">反回管理員首頁</a>。",
    21 => '失敗',
    22 => '成功 ',
    23 => '全部成功 ',
    24 => '全部失敗',
    25 => '-- 請選小組 --',
    26 => '請填寫所有表格上的欄位和選擇一個小組。'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => '安裝插件能損壞你的主系統。 必需要特別小心。 最好不要安裝任何你不瞭解的插件。',
    2 => '插件安裝聲明',
    3 => '插件安裝表格',
    4 => '插件檔案',
    5 => '插件清單',
    6 => '警告︰插件已經被安裝過！',
    7 => '你想安裝的插件已經存在，請先把它刪除再安裝。',
    8 => '插件不能通過兼容性校驗。',
    9 => '這插件要求一個更新版本的志樂. 你可以升級你的<a href="http://www.geeklog.net">志樂</a>或是另找一個適合的版本。',
    10 => '<br><b>沒有安裝的插件。</b><br><br>',
    11 => '若想修改或刪除插件，點擊以下插件的名稱。這會顯示插件的詳細內容和製作者的網站。安裝的版本和從代碼中來的版本都會顯出來。這會讓你知道此插件是否應該更新。若要安裝或升級插件請咨詢它的說明文件。',
    12 => 'plugineditor() 找不到插件名',
    13 => '插件編輯器',
    14 => '新插件',
    15 => '管理員首頁',
    16 => '插件名字',
    17 => '插件版本',
    18 => '志樂版本',
    19 => '使有效',
    20 => '是',
    21 => '否',
    22 => '安裝',
    23 => '保存',
    24 => '取消',
    25 => '刪除',
    26 => '插件名',
    27 => '插件首頁',
    28 => '已安裝的插件版本',
    29 => '志樂版本',
    30 => '刪除插件？',
    31 => '你肯定要刪除這個插件嗎？這麽會刪除所有有關這插件的文件、資料和資料結構。如果你肯定的，請再點擊下面表格中的刪除鈕。',
    32 => '<p><b>錯誤：AutoLink 標簽不對</b></p>',
    33 => '代碼版本',
    34 => '更新',
    35 => '編輯',
    36 => '代碼',
    37 => '數據',
    38 => '更新!'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => '建立文流',
    2 => '保存',
    3 => '刪除',
    4 => '取消',
    10 => '內容辛迪加',
    11 => '新文流',
    12 => '管理處首頁',
    13 => '若要修改或刪除一個文流, 再一下主題上點擊. 若要建立新的文流, 點擊以上的新文流.',
    14 => '標題',
    15 => '種類',
    16 => '文件名',
    17 => '格式',
    18 => '最後一次更新',
    19 => '啟動',
    20 => '是',
    21 => '否',
    22 => '<i>(無文流)</i>',
    23 => '所有文章',
    24 => '文流編輯',
    25 => '文流標題',
    26 => '限定',
    27 => '條目長度',
    28 => '(0 = 無內文, 1 = 整文, other = 限定於此字數.)',
    29 => '說明',
    30 => '最後一次更新',
    31 => '字符集',
    32 => '語言',
    33 => '內容',
    34 => '條目',
    35 => '小時',
    36 => '選擇文流種類',
    37 => '你有最少一個安裝了的插件能配合內容辛迪加.一下你需要選擇你是否要建立一個主系統文流或插件文流.',
    38 => '錯誤: 缺少信息',
    39 => '請填入文流標題, 說明, 和文件名.',
    40 => '請輸入條目數目或小時數目.',
    41 => '連結',
    42 => '事件',
    43 => '全部',
    44 => '無',
    45 => '題目內的標題聯結',
    46 => '限制結果',
    47 => '搜尋',
    48 => '編輯',
    49 => '新聞 Feed 的標誌',
    50 => "跟網址有關 ({$_CONF['site_url']})",
    51 => '你所選的文件名已經在另一個文流中用著了。請選另一個。',
    52 => '錯誤: 文件名已存在'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "我們已電郵了你的密碼到你的電郵信箱，請跟隨郵件中的指示。多謝使用 {$_CONF['site_name']}",
    2 => "多謝遞交你的文章到 {$_CONF['site_name']} 。只要經過我們員工的核對，你的文章將出現在我們的綱頁上。",
    3 => "多謝遞交連結到 {$_CONF['site_name']} 。只要經過我們員工的核對，你的連結將出現在我們的綱頁上。",
    4 => "多謝遞交事件到 {$_CONF['site_name']} 。只要經過我們員工的核對，你的事件將出現在我們的<a href={$_CONF['site_url']}/calendar.php>日曆</a>上。",
    5 => '你的帳戶設定已被保存了。',
    6 => '你的個人設定已被保存了。',
    7 => '你的評論界面設定已被保存了。',
    8 => '你已退出。',
    9 => '你的文章已被保存了。',
    10 => '你的文章已被刪除了。',
    11 => '你的組件已被保存了。',
    12 => '你的組件已被刪除了。',
    13 => '你的主題已被保存了。',
    14 => '你的主題和所有相關的文章已被刪除了。',
    15 => '你的連結已被保存了。',
    16 => '你的連結已被刪除了。',
    17 => '你的事件已被保存了。',
    18 => '你的事件已被刪除了。',
    19 => '你的投票已被保存了。',
    20 => '你的投票已被刪除了。',
    21 => '用戶已被保存了。',
    22 => '用戶已被刪除了。',
    23 => '增加事件到你的日歷時發生錯誤，缺少了事件編號。',
    24 => '事件已增加到你的日曆中。',
    25 => '你要登入才可開啟你的個人日曆。',
    26 => '事件已從你的日曆中移除。',
    27 => '信息已發送。',
    28 => '插件已被保存了。',
    29 => '抱歉，本站並不提供個人日曆。',
    30 => '存取被拒絕',
    31 => '抱歉，你不能進入文章管理的首頁。請注意你的企圖已被記錄。',
    32 => '抱歉，你不能進入主題管理的首頁。請注意你的企圖已被記錄。',
    33 => '抱歉，你不能進入組件管理的首頁。請注意你的企圖已被記錄。',
    34 => '抱歉，你不能進入連結管理的首頁。請注意你的企圖已被記錄。',
    35 => '抱歉，你不能進入事件管理的首頁。請注意你的企圖已被記錄。',
    36 => '抱歉，你不能進入投票管理的首頁。請注意你的企圖已被記錄。',
    37 => '抱歉，你不能進入用戶管理的首頁。請注意你的企圖已被記錄。',
    38 => '抱歉，你不能進入 Plug-in 管理的首頁。請注意你的企圖已被記錄。',
    39 => '抱歉，你不能進入電郵管理的首頁。請注意你的企圖已被記錄。',
    40 => '系統訊息',
    41 => '抱歉，你不能進入字詞替換的首頁。請注意你的企圖已被記錄。',
    42 => '你的字詞已被保存了。',
    43 => '你的字詞已被刪除了。',
    44 => '插件已被安裝了。',
    45 => '插件已被刪除了。',
    46 => '抱歉，你不能進入資料庫備份程式。請注意你的企圖已被記錄。',
    47 => '這只適用於 *nix 如果你的作業系統是 *nix，那麽你的緩衝器已被清除了。如果你的作業系統是 Windows，你要手動尋找文件命名為 adodb _ *.php 的檔案並把它們除去。',
    48 => "感謝你申請成為 {$_CONF['site_name']} 的會員。只要經過我們員工的核對，我們會把密碼寄到你所登記的電郵中。",
    49 => '你的小組已被保存了。',
    50 => '小組已被刪除了。',
    51 => '此用戶名已有人在用。請選擇另一個。',
    52 => '你給的電信地址不像是有效。',
    53 => '你的新密碼已被接受。現在以下請用你的新密碼來登入.',
    54 => '你要求新密碼的期限以過。請在下面從新要求。',
    55 => '已經給你寄了一封電信。請照此信的說明來設定新密碼。',
    56 => '你供給的電信地址已有別的用戶在使用。',
    57 => '你的用戶已經成功地刪除了。',
    58 => '你的文流已成功的保存了.',
    59 => '你的文流已成功的刪除了.',
    60 => '插件已經更新成功',
    61 => '插件 %s: 不知名的信息占位符',
    62 => '跡回評論已被刪除.',
    63 => '刪除跡回評論時發生錯誤.',
    64 => '你的跡回評論已成功地傳送出.',
    65 => '網志目錄服務已成功的存續.',
    66 => '網志目錄服務已被刪除.',
    67 => '你輸入的新密碼跟證實密碼不同!',
    68 => '你必要輸入正確的目前密碼.',
    69 => '你的賬戶已被禁止!',
    70 => '你的賬戶在等待管理員的批准.',
    71 => '你的賬戶已證實並且等待管理員的批准.',
    72 => '安裝插件時發生錯誤，細節請看 error.log.',
    73 => '卸載插件時發生錯誤，細節請看error.log.',
    74 => 'Ping 回已成功地送出.',
    75 => '跡回必須用 POST 要求.',
    76 => '你真的要刪除這項目嗎？',
    77 => '警告:<br>你已默認UTF-8 為語文編碼。 但是，你的服務器不支持多字節編碼。請安裝 mbstring 入 PHP 或選另一種語文編碼。',
    78 => '請確定你的電信地址跟你的確認電信地址是完全同樣的。',
    79 => '你想打開的網頁提交到已經在這網站不存在的功能。',
    80 => '建立此文流的插件已被關閉。你不能修改此文流除非你從新啟動有關插件。',
    81 => '你可能錯誤的輸入了你的用戶資料。請在下面再次登入。',
    82 => '你已超過准許的登入次數。 等會兒再試。',
    83 => '要改密碼，電信地址，或要記得你多久，請輸入你的目前密碼。',
    84 => '要刪除你的用戶帳號，請輸入你的目前密碼。'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => '存取',
    'ownerroot' => '所有者/Root',
    'group' => '小組',
    'readonly' => '唯讀',
    'accessrights' => '存取權',
    'owner' => '所有者',
    'grantgrouplabel' => '給予之上小組編輯權利',
    'permmsg' => '注意︰會員是指所有註冊和登入的用戶；而匿名是指所有非註冊的瀏覽者或沒有登入的用戶。',
    'securitygroups' => '安全小組',
    'editrootmsg' => "即使你是用戶管理員；但你不能編輯 root 用戶。你能編輯所有的用戶除了 root 用戶。請注意所有企圖非法地編輯 root 用戶的動作已被記錄。請回到<a href=\"{$_CONF['site_admin_url']}/user.php\">用戶管理頁</a>去。",
    'securitygroupsmsg' => '選擇這位用戶屬於的小組。',
    'groupeditor' => '小組編輯器',
    'description' => '描述',
    'name' => '名字',
    'rights' => '權限',
    'missingfields' => '缺少欄位',
    'missingfieldsmsg' => '你必須提供小組的名字和描述',
    'groupmanager' => '小組管理員',
    'newgroupmsg' => '點擊下面的小組可修改或刪除它，點擊上面的新小組可創造一個新的。請注意所核心小組不能被刪除。',
    'groupname' => '組名',
    'coregroup' => '核心小組',
    'yes' => '是',
    'no' => '否',
    'corerightsdescr' => "這個小組的權限不能被編輯，因為這是個 {$_CONF['site_name']} 的核心小組。以下是這小組的權限清單(唯讀的)。",
    'groupmsg' => '安全小組在這綱站是有等級制度的。當增加這個小組到另一組別，這個小組將得到那組別的權限。請盡可能小組加下列的組別去。如果這小組需要特別的權限，你可以在以下的"權利"區域中挑選。要把小組加到組別去，你只需要在組別旁邊的挑選盒打鉤。',
    'coregroupmsg' => "因為這是個 {$_CONF['site_name']} 的核心小組，這個小組的權限不能被編輯。以下是這小組的組別清單(唯讀的)。",
    'rightsdescr' => '小組的權限可以是來自於小組本身或是這小組所屬的組別。以下的權限中如沒有檢驗盒即代表這權限是來自於小組所屬的組別；如有檢驗盒即代表你可以直接把權限給予這小組。',
    'lock' => '鎖住',
    'members' => '成員',
    'anonymous' => '匿名',
    'permissions' => '權限',
    'permissionskey' => 'R = 唯讀， E = 編輯，有編輯權即有唯讀權',
    'edit' => '編輯',
    'none' => '沒有',
    'accessdenied' => '存取被拒絕',
    'storydenialmsg' => "因未被批准，你不可以觀看這個文章。這是可能是因為你並不是 {$_CONF['site_name']} 的會員。請<a href=users.php?mode=new>成為會員</a>。",
    'nogroupsforcoregroup' => '這小組不屬於任何其它的小組',
    'grouphasnorights' => ' 這小組沒有管理權。',
    'newgroup' => '新小組',
    'adminhome' => '管理員首頁',
    'save' => '保存',
    'cancel' => '取消',
    'delete' => '刪除',
    'canteditroot' => '因為你不屬於 Root 小組，所以你對 Root 小組的修改被拒絕了。如有問題請與系統管理員聯繫。',
    'listusers' => '列出用戶',
    'listthem' => '列出',
    'usersingroup' => '屬於 "%s" 小組的用戶',
    'usergroupadmin' => '用戶小組管理',
    'add' => '加入',
    'remove' => '免除',
    'availmembers' => '可用的成員',
    'groupmembers' => '小組成員',
    'canteditgroup' => '若要修改此小組, 你必要時這個小組的成員. 若你認為這是錯誤, 請你聯絡系統管理員.',
    'cantlistgroup' => '要看此小組的會員，你必須是此小組的會員。你若認為這是錯誤，請聯絡系統管理員。',
    'editgroupmsg' => '若要修改小組會員，點擊會員名，然後用增加或刪除的按鈕. 如果一個會員是一個小組的會員，他們的名字只會顯現在右邊. 一旦完成，按 <b>保存</b> 來更新小組，然後回到小組管理主頁.',
    'listgroupmsg' => '列出此小組目前所有的會員: <b>%s</b>',
    'search' => '搜尋',
    'submit' => '提交',
    'limitresults' => '控制結果',
    'group_id' => '小組 ID',
    'plugin_access_denied_msg' => '你在非法的進入插件管理頁.  請注意所有的非法登入都被登記.',
    'groupexists' => '小組名稱已存在',
    'groupexistsmsg' => '目前已有用此名的小組. 小組名稱必須獨特.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => '最後十個備份',
    'do_backup' => '做備份',
    'backup_successful' => '資料庫備份完成。',
    'db_explanation' => '要做新的志樂備份，點擊以下的按鈕',
    'not_found' => "不正確的路徑或 mysqldump 程式不可執行。<br>檢查<strong>\$_DB_mysqldump_path</strong>定義在 config.php.<br>變數現在被定義為︰<var>{$_DB_mysqldump_path}</var>",
    'zero_size' => '備份失敗︰檔案是 0 大小',
    'path_not_found' => "{$_CONF['backup_path']} 不存在或不是目錄",
    'no_access' => "錯誤︰目錄 {$_CONF['backup_path']} ，不能存取。",
    'backup_file' => '備份檔案',
    'size' => '大小',
    'bytes' => '位元組',
    'total_number' => '總備份次數: %d'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => '首頁',
    2 => '聯絡',
    3 => '投稿',
    4 => '連結',
    5 => '投票',
    6 => '日曆',
    7 => '本站統計數據',
    8 => '個人化',
    9 => '搜索',
    10 => '進階搜尋',
    11 => '目錄'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 錯誤',
    2 => '咦，我到處都看過了但找不到<b>%s</b>.',
    3 => "<p>很抱歉，但你要求的文件不存在。請檢查<a href=\"{$_CONF['site_url']}\">主頁</a>或<a href=\"{$_CONF['site_url']}/search.php\">搜索頁</a>看看能發現什麽。"
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => '要求登入',
    2 => '抱歉，要求登入才可存取這個區域。',
    3 => '登入',
    4 => '新用戶'
);

###############################################################################
# pdfgenerator.php

$LANG_PDF = array(
    1 => 'PDF 版本的作用已被禁止',
    2 => '所提供的文件沒有呈遞。文件已收到，但是無法處理。請肯定你所提交的文件是 html 格式的文件寫於 xHTML 的標準。請注意過分複雜的 html 文件也可能無法正確呈遞。你的文件提交的結果是 0 bytes 而且已被刪除。你若肯定你的文件應該順利的呈遞，其再次提交。',
    3 => '不知名的PDF 文件製作錯誤。',
    4 => '沒提供頁數資料或你要用以下的特別 PDF 製作工具。若你認為你所得到的這頁是錯誤。 請聯絡系統管理員。要不然，你可用以下的表格來特別製作 PDF。',
    5 => '正在裝置你的文件。',
    6 => '你的文件被裝置時請等待。',
    7 => '你可用右擊以下的按鈕，然後選 \'save target...\' or \'save link location...\' 來存續你的文件的一個拷貝。',
    8 => '在配置檔案裏的 HTMLDoc二進制檔案路徑有錯誤，或此系統無法執行此檔案。若此問題繼續發生，請聯絡網站管理員。',
    9 => 'PDF 製作器',
    10 => '這是特別的 PDF 製作工具。它會將任何 URL 轉換成 PDF 版本。請注意，有些網頁不會正確的被這工具處理成功。這是 HTMLDoc PDF 製作工具的有限之處，而這樣的錯誤不需要報告給此網站的管理員。',
    11 => 'URL',
    12 => '製作 PDF!',
    13 => '此服務器的 PHP 配置不准許 fopen() 命令用在 URL 上。 系統管理員必須先修改  php.ini 檔案，然後設定 allow_url_fopen 到 On',
    14 => '你要求的 PDF 不存在或你在非法的入取一個檔案。'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => '跡回',
    'from' => '從',
    'tracked_on' => '跡回於',
    'read_more' => '[讀下文]',
    'intro_text' => '這是別人對 \'%s\' 的看法:',
    'no_comments' => '此登錄無跡回評論.',
    'this_trackback_url' => '此登錄的跡回 URL:',
    'num_comments' => '%d 跡回評論',
    'send_trackback' => '送出 Ping',
    'preview' => '預覽',
    'editor_title' => '送出跡回評論',
    'trackback_url' => '跡回 URL',
    'entry_url' => '登錄 URL',
    'entry_title' => '登錄標題',
    'blog_name' => '網站名',
    'excerpt' => '摘錄',
    'truncate_warning' => '注: 目的站可能將你的摘錄縮短',
    'button_send' => '送出',
    'button_preview' => '預覽',
    'send_error' => '錯誤',
    'send_error_details' => '送出跡回評論時發生錯誤:',
    'url_missing' => '無登錄 URL',
    'url_required' => '請輸入登錄的最少一個 URL.',
    'target_missing' => '無跡回 URL',
    'target_required' => '請輸入一個跡回 URL',
    'error_socket' => '無法打開 socket.',
    'error_response' => '不明白你的反應.',
    'error_unspecified' => '為指明的錯誤.',
    'select_url' => '選擇跡回 URL',
    'not_found' => '找不到跡回 URL',
    'autodetect_failed' => '志樂探測不到關於你要送出評論的跡回 URL. 以下請輸入.',
    'trackback_explain' => '從以下的聯結中，請選你要送出評論的 URL. 志樂將會決定正確的跡回 URL. 或者你若已知道的話，可 <a href="%s">在此輸入它</a>.',
    'no_links_trackback' => '找不到聯結. 你不能送出此登錄的跡回評論.',
    'pingback' => 'Ping 回',
    'pingback_results' => 'Ping 回的結果',
    'send_pings' => '送出 ping',
    'send_pings_for' => '送出ping 於 "%s"',
    'no_links_pingback' => '找不到聯結. 為此登錄無 Ping 回送出.',
    'pingback_success' => 'Ping 回已送出.',
    'no_pingback_url' => '無 ping 回 URL.',
    'resend' => '重送',
    'ping_all_explain' => '你現在可通知你所聯結的網站 (<a href="http://en.wikipedia.org/wiki/Pingback">Ping 回</a>), 廣告你的站已經被更新於ping 過網志目錄服務, 或送出一個 <a href="http://en.wikipedia.org/wiki/Trackback">跡回</a> 評論若你寫過有關一個在別人的網站上的登錄.',
    'pingback_button' => '送出Ping 回',
    'pingback_short' => '送出Ping 回到所有跟此登錄聯結的網站.',
    'pingback_disabled' => '(Ping 回已中止)',
    'ping_button' => '送出Ping',
    'ping_short' => 'Ping 網志目錄服務.',
    'ping_disabled' => '(Ping 已中止)',
    'trackback_button' => '送出跡回',
    'trackback_short' => '送出一個跡回評論.',
    'trackback_disabled' => '(跡回一中止)',
    'may_take_a_while' => '請注意，送出 Ping回 和 Ping 可需要一段時間.',
    'ping_results' => 'Ping 的結果',
    'unknown_method' => '無知 ping 法',
    'ping_success' => 'Ping 已送出.',
    'error_site_name' => '請輸入網站名.',
    'error_site_url' => '請輸入網站 URL.',
    'error_ping_url' => '請輸入正確的 Ping URL.',
    'no_services' => '未設定網志目錄服務.',
    'services_headline' => '網志目錄服務',
    'service_explain' => '若要更改或刪除網志目錄服務，請點擊一下服務的編輯標圖. 要增加一個新的網志目錄服務，請點擊以上的 "建新".',
    'service' => '服務',
    'ping_method' => 'Ping 法',
    'service_website' => '網站',
    'service_ping_url' => '要ping 的URL',
    'ping_standard' => '標準 Ping',
    'ping_extended' => '擴大的 Ping',
    'ping_unknown' => '(無知法)',
    'edit_service' => '編輯網志目錄服務',
    'trackbacks' => '跡回',
    'editor_intro' => '準備你的跡回評論於 <a href="%s">%s</a>.',
    'editor_intro_none' => '準備你的跡回評論.',
    'trackback_note' => '若要送出一個跡回評論于一個文章，去到文章目錄然後點擊那文章的"傳送 Ping". 若要送出跟任何文章都無關的跡回, <a href="%s">請點擊此處</a>.',
    'pingback_explain' => '輸入一個 URL 來送出 Ping回. Ping回將會指到你的網站主頁.',
    'pingback_url' => 'Ping回 URL',
    'site_url' => '此站的 URL',
    'pingback_note' => '若要給一個文章送出 ping回, 去到文章目錄然後點擊那文章的 "傳送 Ping". 要送出一個跟任何文章都無關的 ping回, <a href="%s">請點擊此處</a>.',
    'pbtarget_missing' => '無 Ping回 URL',
    'pbtarget_required' => '請輸入一個ping回 URL',
    'pb_error_details' => '送出 ping回時發生錯誤:',
    'delete_trackback' => '要刪除這跡回請按: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => '文章目錄',
    'title_year' => '文章目錄為 %d',
    'title_month_year' => '文章目錄為 %s %d',
    'nav_top' => '回到文章目錄',
    'no_articles' => '沒有文章.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n 新 %i 在最後 %t %s',
    'new_last' => '最後 %t %s',
    'minutes' => '分鐘',
    'hours' => '小時',
    'days' => '日',
    'weeks' => '周',
    'months' => '月',
    'minute' => '分鐘',
    'hour' => '小時',
    'day' => '日',
    'week' => '周',
    'month' => '月'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => '一月',
    2 => '二月',
    3 => '三月',
    4 => '四月',
    5 => '五月',
    6 => '六月',
    7 => '七月',
    8 => '八月',
    9 => '九月',
    10 => '十月',
    11 => '十一月',
    12 => '十二月'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Sunday',
    2 => 'Monday',
    3 => 'Tuesday',
    4 => 'Wednesday',
    5 => 'Thursday',
    6 => 'Friday',
    7 => 'Saturday'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => '搜尋',
    'limit_results' => '限制結果',
    'submit' => '提交',
    'edit' => '編輯',
    'edit_adv' => 'Adv. 編輯',
    'admin_home' => '管理主頁',
    'create_new' => '建新',
    'create_new_adv' => '建新 (Adv.)',
    'enabled' => '啟動',
    'title' => '標題',
    'type' => '類型',
    'topic' => '題目',
    'help_url' => '幫助文 URL',
    'save' => '存續',
    'cancel' => '取消',
    'delete' => '刪除',
    'delete_sel' => '刪除所選的',
    'copy' => '複製',
    'no_results' => '- 找不到任何登錄 -',
    'data_error' => '處理訂閱資料時發現錯誤. 請檢查資料來源.',
    'preview' => '預覽',
    'records_found' => '已找到的資料'
);

###############################################################################
# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => '評論已啟動',
    -1 => '評論已關掉'
);


$LANG_commentmodes = array(
    'flat' => '平面的',
    'nested' => '嵌套的',
    'threaded' => '線狀的',
    'nocomment' => '勿評論'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 小時',
    7200 => '2 小時',
    10800 => '3 小時',
    28800 => '8 小時',
    86400 => '1 日',
    604800 => '1 周',
    2678400 => '1 月'
);

$LANG_dateformats = array(
    0 => '系統指定的'
);

$LANG_featurecodes = array(
    0 => '不定為重要文章',
    1 => '定為重要文章'
);

$LANG_frontpagecodes = array(
    0 => '只顯在主提版',
    1 => '顯在標題版'
);

$LANG_postmodes = array(
    'plaintext' => '普通文字',
    'html' => 'HTML 格式'
);

$LANG_sortcodes = array(
    'ASC' => '最老的在前',
    'DESC' => '最新的在前'
);

$LANG_trackbackcodes = array(
    0 => '跡回已啟動',
    -1 => '跡回已關掉'
);

?>
